/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.RuntimeEnvironment;
import org.eclipse.jdt.ls.core.internal.managers.GradleBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.GradleProjectImporter;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.GradleEnvironment;

public class GradleUtils {
    public static String INVALID_TYPE_FIXED_VERSION = "7.2";
    public static String JPMS_SUPPORTED_VERSION = "7.0.1";
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA-256";

    public static boolean isIncompatible(GradleVersion gradleVersion, String javaVersion) {
        if (gradleVersion == null || javaVersion == null || javaVersion.isEmpty()) {
            return false;
        }
        String highestSupportedJava = GradleUtils.getHighestSupportedJava(gradleVersion);
        return JavaCore.compareJavaVersions((String)javaVersion, (String)highestSupportedJava) > 0;
    }

    public static String getHighestSupportedJava(GradleVersion gradleVersion) {
        GradleVersion baseVersion;
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    baseVersion = gradleVersion.getBaseVersion();
                                                    if (baseVersion.compareTo(GradleVersion.version((String)"8.3")) < 0) break block14;
                                                    return "20";
                                                }
                                                if (baseVersion.compareTo(GradleVersion.version((String)"7.6")) < 0) break block15;
                                                return "19";
                                            }
                                            if (baseVersion.compareTo(GradleVersion.version((String)"7.5")) < 0) break block16;
                                            return "18";
                                        }
                                        if (baseVersion.compareTo(GradleVersion.version((String)"7.3")) < 0) break block17;
                                        return "17";
                                    }
                                    if (baseVersion.compareTo(GradleVersion.version((String)"7.0")) < 0) break block18;
                                    return "16";
                                }
                                if (baseVersion.compareTo(GradleVersion.version((String)"6.7")) < 0) break block19;
                                return "15";
                            }
                            if (baseVersion.compareTo(GradleVersion.version((String)"6.3")) < 0) break block20;
                            return "14";
                        }
                        if (baseVersion.compareTo(GradleVersion.version((String)"6.0")) < 0) break block21;
                        return "13";
                    }
                    if (baseVersion.compareTo(GradleVersion.version((String)"5.4")) < 0) break block22;
                    return "12";
                }
                if (baseVersion.compareTo(GradleVersion.version((String)"5.0")) < 0) break block23;
                return "11";
            }
            if (baseVersion.compareTo(GradleVersion.version((String)"4.7")) < 0) break block24;
            return "10";
        }
        try {
            if (baseVersion.compareTo(GradleVersion.version((String)"4.3")) >= 0) {
                return "9";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "1.8";
    }

    public static boolean hasGradleInvalidTypeCodeException(IStatus status, Path projectFolder, IProgressMonitor monitor) {
        if (!GradleProjectImporter.isFailedStatus(status)) {
            return false;
        }
        if (!GradleUtils.isGradleInvalidTypeCodeException(status.getException())) {
            return false;
        }
        GradleVersion version = GradleUtils.getGradleVersion(projectFolder, monitor);
        return version != null && version.compareTo(GradleVersion.version((String)INVALID_TYPE_FIXED_VERSION)) < 0;
    }

    public static boolean isGradleInvalidTypeCodeException(Throwable throwable) {
        Throwable cause = throwable;
        while (cause != null) {
            String message = cause.getMessage();
            if (cause instanceof StreamCorruptedException && message.contains("invalid type code")) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    public static GradleVersion getGradleVersion(Path projectFolder, IProgressMonitor monitor) {
        try {
            BuildConfiguration build = GradleProjectImporter.getBuildConfiguration(projectFolder, true);
            GradleBuild gradleBuild = GradleCore.getWorkspace().createBuild(build);
            BuildEnvironment environment = (BuildEnvironment)gradleBuild.withConnection(connection -> (BuildEnvironment)connection.getModel(BuildEnvironment.class), monitor);
            GradleEnvironment gradleEnvironment = environment.getGradle();
            String gradleVersion = gradleEnvironment.getGradleVersion();
            return GradleVersion.version((String)gradleVersion);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getGradleInitScript(String scriptPath) {
        try {
            URL fileURL = FileLocator.toFileURL((URL)JavaLanguageServerPlugin.class.getResource(scriptPath));
            String fileString = fileURL.getFile();
            if (fileString.contains(" ")) {
                return GradleUtils.getGradleInitScriptTempFile(scriptPath);
            }
            File initScript = new File(fileString);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream input = JavaLanguageServerPlugin.class.getResourceAsStream(scriptPath);){
                if (!initScript.exists()) {
                    initScript.createNewFile();
                    Files.copy(input, initScript.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    return initScript;
                }
                byte[] fileBytes = input.readAllBytes();
                byte[] contentDigest = GradleUtils.getContentDigest(fileBytes);
                if (GradleUtils.needReplaceContent(initScript, contentDigest)) {
                    Files.write(initScript.toPath(), fileBytes, new OpenOption[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return initScript;
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e);
            return GradleUtils.getGradleInitScriptTempFile(scriptPath);
        }
    }

    private static File getGradleInitScriptTempFile(String scriptPath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream input = JavaLanguageServerPlugin.class.getResourceAsStream(scriptPath);){
                byte[] fileBytes = input.readAllBytes();
                byte[] contentDigest = GradleUtils.getContentDigest(fileBytes);
                String fileName = GradleUtils.bytesToHex(contentDigest) + ".gradle";
                File initScript = new File(System.getProperty("java.io.tmpdir"), fileName);
                if (GradleUtils.needReplaceContent(initScript, contentDigest)) {
                    Files.write(initScript.toPath(), fileBytes, new OpenOption[0]);
                }
                return initScript;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            JavaLanguageServerPlugin.logException(e);
            return null;
        }
    }

    public static boolean needReplaceContent(File initScript, byte[] checksum) throws IOException, NoSuchAlgorithmException {
        if (!initScript.exists() || initScript.length() == 0L) {
            return true;
        }
        byte[] digest = GradleUtils.getContentDigest(Files.readAllBytes(initScript.toPath()));
        return !Arrays.equals(digest, checksum);
    }

    private static byte[] getContentDigest(byte[] contentBytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        md.update(contentBytes);
        return md.digest();
    }

    private static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(String.format("%02x", b));
            ++n2;
        }
        return builder.toString();
    }

    public static Map<String, String> parseProcessorOptions(List<Object> compilerArgs) {
        if (compilerArgs == null || compilerArgs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (Object arg : compilerArgs) {
            String argString = String.valueOf(arg);
            if (!argString.startsWith("-A")) continue;
            GradleUtils.parse(argString.substring(2), options);
        }
        return options;
    }

    private static void parse(String argument, Map<String, String> results) {
        String value;
        String key;
        if (argument == null || argument.isBlank()) {
            return;
        }
        int optionalEqualsIndex = argument.indexOf(61);
        switch (optionalEqualsIndex) {
            case -1: {
                key = argument;
                value = null;
                break;
            }
            case 0: {
                return;
            }
            default: {
                key = argument.substring(0, optionalEqualsIndex);
                if (GradleUtils.containsWhitespace(key)) {
                    return;
                }
                value = argument.substring(optionalEqualsIndex + 1, argument.length());
            }
        }
        results.put(key, value);
    }

    private static boolean containsWhitespace(String seq) {
        return seq != null && !seq.isBlank() && seq.chars().anyMatch(Character::isWhitespace);
    }

    public static void synchronizeAnnotationProcessingConfiguration(IProgressMonitor monitor) {
        for (IProject project : ProjectUtils.getGradleProjects()) {
            Optional build = GradleCore.getWorkspace().getBuild(project);
            if (!build.isPresent()) continue;
            GradleBuildSupport.syncAnnotationProcessingConfiguration((GradleBuild)build.get(), monitor);
            break;
        }
    }

    public static File getJdkToLaunchDaemon(String highestJavaVersion) {
        if (StringUtils.isBlank((CharSequence)highestJavaVersion)) {
            return null;
        }
        Map<String, File> jdks = GradleUtils.getAllVmInstalls();
        Map.Entry<String, File> selected = null;
        for (Map.Entry<String, File> jdk : jdks.entrySet()) {
            String javaVersion = jdk.getKey();
            if (Runtime.Version.parse(javaVersion).compareTo(Runtime.Version.parse(highestJavaVersion)) > 0 || selected != null && Runtime.Version.parse((String)selected.getKey()).compareTo(Runtime.Version.parse(javaVersion)) >= 0) continue;
            selected = jdk;
        }
        return selected == null ? null : (File)selected.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, File> getAllVmInstalls() {
        String javaVersion;
        List vmList = Stream.of(JavaRuntime.getVMInstallTypes()).map(IVMInstallType::getVMInstalls).flatMap(Arrays::stream).toList();
        HashMap<String, File> vmInstalls = new HashMap<String, File>();
        for (IVMInstall vmInstall : vmList) {
            void vm;
            IVMInstall iVMInstall = vmInstall;
            if (!(iVMInstall instanceof AbstractVMInstall)) continue;
            AbstractVMInstall cfr_ignored_0 = (AbstractVMInstall)iVMInstall;
            AbstractVMInstall cfr_ignored_1 = (AbstractVMInstall)iVMInstall;
            javaVersion = GradleUtils.getMajorJavaVersion(vm.getJavaVersion());
            if (StringUtils.isBlank((CharSequence)javaVersion) || vm.getInstallLocation() == null) continue;
            vmInstalls.putIfAbsent(javaVersion, vm.getInstallLocation());
        }
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        Set<RuntimeEnvironment> runtimes = preferences.getRuntimes();
        for (RuntimeEnvironment runtime : runtimes) {
            File javaHome;
            if (StringUtils.isBlank((CharSequence)runtime.getPath()) || vmInstalls.containsValue(javaHome = new File(runtime.getPath())) || !StringUtils.isNotBlank((CharSequence)(javaVersion = new StandardVMType().readReleaseVersion(javaHome)))) continue;
            vmInstalls.put(GradleUtils.getMajorJavaVersion(javaVersion), javaHome);
        }
        return vmInstalls;
    }

    public static String getMajorJavaVersion(String version) {
        return CompilerOptions.versionFromJdkLevel((long)CompilerOptions.versionToJdkLevel((String)version));
    }
}

