/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.JavaApplicationLaunchConfiguration;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public interface IBuildSupport {
    public boolean applies(IProject var1);

    public boolean isBuildFile(IResource var1);

    default public boolean isBuildLikeFileName(String fileName) {
        return false;
    }

    default public void update(IProject resource, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    default public void update(IProject resource, IProgressMonitor monitor) throws CoreException {
        this.update(resource, false, monitor);
    }

    default public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        this.refresh(resource, changeType, monitor);
        return false;
    }

    default public boolean useDefaultVM(IProject project, IVMInstall defaultVM) {
        return false;
    }

    default public void refresh(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null) {
            return;
        }
        if (changeType == ProjectsManager.CHANGE_TYPE.DELETED) {
            IProject project;
            if (".classpath".equals(resource.getName()) && ProjectUtils.isJavaProject(project = resource.getProject()) && (resource.equals((Object)project.getFile(".classpath")) || resource.getProjectRelativePath().segmentCount() == 1)) {
                ProjectUtils.removeJavaNatureAndBuilder(project, monitor);
                this.update(project, true, monitor);
            }
            resource = resource.getParent();
        }
        if (resource != null) {
            resource.refreshLocal(2, monitor);
        }
    }

    default public void discoverSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
    }

    default public ILaunchConfiguration getLaunchConfiguration(IJavaProject javaProject, String scope) throws CoreException {
        return new JavaApplicationLaunchConfiguration(javaProject.getProject(), scope, null);
    }

    default public List<String> getWatchPatterns() {
        return Collections.emptyList();
    }

    default public void registerPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
    }

    default public void unregisterPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
    }

    default public String buildToolName() {
        return "UnknownBuildTool";
    }

    default public boolean hasSpecificDeleteProjectLogic() {
        return false;
    }

    default public void deleteInvalidProjects(Collection<IPath> rootPaths, ArrayList<IProject> deleteProjectCandates, IProgressMonitor monitor) {
    }

    default public String unsupportedOperationMessage() {
        return "Unsupported operation. Please use your build tool project file to manage the source directories of the project.";
    }

    default public List<String> getExcludedFilePatterns() {
        return Collections.emptyList();
    }
}

