"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = require("inversify");
const chai_1 = require("chai");
const widget_manager_1 = require("./widget-manager");
const signaling_1 = require("@phosphor/signaling");
const logger_1 = require("../common/logger");
const mock_logger_1 = require("../common/test/mock-logger");
const common_1 = require("../common");
class TestWidgetFactory {
    constructor() {
        this.invocations = 0;
        this.id = 'test';
    }
    async createWidget(name) {
        this.invocations++;
        // create a mock Widget, since a real widget has deps to dom api
        const result = {};
        result.id = name;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        result.disposed = new signaling_1.Signal(result);
        return result;
    }
}
let widgetManager;
before(() => {
    const testContainer = new inversify_1.Container();
    const module = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
        bind(logger_1.ILogger).to(mock_logger_1.MockLogger);
        (0, common_1.bindContributionProvider)(bind, widget_manager_1.WidgetFactory);
        bind(widget_manager_1.WidgetFactory).toConstantValue(new TestWidgetFactory());
        bind(widget_manager_1.WidgetManager).toSelf().inSingletonScope();
    });
    testContainer.load(module);
    widgetManager = testContainer.get(widget_manager_1.WidgetManager);
});
describe('widget-manager', () => {
    it('creates and caches widgets', async () => {
        const wA = await widgetManager.getOrCreateWidget('test', 'widgetA');
        const wB = await widgetManager.getOrCreateWidget('test', 'widgetB');
        (0, chai_1.expect)(wA).not.equals(wB);
        (0, chai_1.expect)(wA).equals(await widgetManager.getOrCreateWidget('test', 'widgetA'));
    });
});
//# sourceMappingURL=widget-manager.spec.js.map