"use strict";
// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var PreferenceSelectInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceSelectInputRendererContribution = exports.PreferenceSelectInputRenderer = void 0;
const preference_node_renderer_1 = require("./preference-node-renderer");
const inversify_1 = require("@theia/core/shared/inversify");
const preference_node_renderer_creator_1 = require("./preference-node-renderer-creator");
let PreferenceSelectInputRenderer = class PreferenceSelectInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    get enumValues() {
        return this.preferenceNode.preference.data.enum;
    }
    createInteractable(parent) {
        const { enumValues } = this;
        const interactable = document.createElement('select');
        this.interactable = interactable;
        interactable.classList.add('theia-select');
        interactable.onchange = this.handleUserInteraction.bind(this);
        for (const [index, value] of enumValues.entries()) {
            const option = document.createElement('option');
            option.value = index.toString();
            option.textContent = `${value}`;
            interactable.appendChild(option);
        }
        interactable.value = this.getDataValue();
        parent.appendChild(interactable);
    }
    getFallbackValue() {
        return this.preferenceNode.preference.data.enum[0];
    }
    doHandleValueChange() {
        const currentValue = this.interactable.value || undefined;
        this.updateInspection();
        const newValue = this.getDataValue();
        this.updateModificationStatus(this.getValue());
        if (newValue !== currentValue && document.activeElement !== this.interactable) {
            this.interactable.value = newValue;
        }
    }
    /**
     * Returns the stringified index corresponding to the currently selected value.
     */
    getDataValue() {
        const currentValue = this.getValue();
        const selected = this.enumValues.findIndex(value => value === currentValue);
        return selected > -1 ? selected.toString() : '0';
    }
    handleUserInteraction() {
        const value = this.enumValues[Number(this.interactable.value)];
        this.setPreferenceImmediately(value);
    }
};
PreferenceSelectInputRenderer = __decorate([
    (0, inversify_1.injectable)()
], PreferenceSelectInputRenderer);
exports.PreferenceSelectInputRenderer = PreferenceSelectInputRenderer;
let PreferenceSelectInputRendererContribution = PreferenceSelectInputRendererContribution_1 = class PreferenceSelectInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceSelectInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        return node.preference.data.enum ? 3 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceSelectInputRenderer);
    }
};
PreferenceSelectInputRendererContribution.ID = 'preference-select-input-renderer';
PreferenceSelectInputRendererContribution = PreferenceSelectInputRendererContribution_1 = __decorate([
    (0, inversify_1.injectable)()
], PreferenceSelectInputRendererContribution);
exports.PreferenceSelectInputRendererContribution = PreferenceSelectInputRendererContribution;
//# sourceMappingURL=preference-select-input.js.map