"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphChartCursors = void 0;
var keyboardKey = require("keyboard-key");
var time_graph_cursor_1 = require("../components/time-graph-cursor");
var time_graph_chart_layer_1 = require("./time-graph-chart-layer");
var bigint_utils_1 = require("../bigint-utils");
var TimeGraphChartCursors = /** @class */ (function (_super) {
    __extends(TimeGraphChartCursors, _super);
    function TimeGraphChartCursors(id, chartLayer, rowController, style) {
        var _this = _super.call(this, id, rowController) || this;
        _this.chartLayer = chartLayer;
        _this.rowController = rowController;
        _this.mouseSelecting = false;
        _this.mouseButtons = 0;
        _this.color = 0x0000ff;
        if (style && style.color) {
            _this.color = style.color;
        }
        return _this;
    }
    TimeGraphChartCursors.prototype.afterAddToContainer = function () {
        var _this = this;
        this.mouseSelecting = false;
        this.shiftKeyDown = false;
        this.stage.interactive = true;
        this._updateHandler = function () { return _this.update(); };
        this._keyDownHandler = function (event) {
            if (event.key === 'Shift' && _this.mouseButtons === 0 && !event.ctrlKey && !event.altKey) {
                _this.stage.cursor = 'crosshair';
            }
            else if (_this.stage.cursor === 'crosshair' && !_this.mouseSelecting &&
                (event.key === 'Control' || event.key === 'Alt')) {
                _this.stage.cursor = 'default';
            }
            _this.shiftKeyDown = event.shiftKey;
            // TODO: keyCode is deprecated. We should change these.
            if (event.keyCode === keyboardKey.ArrowLeft) {
                _this.navigateOrSelectLeft();
            }
            else if (event.keyCode === keyboardKey.ArrowRight) {
                _this.navigateOrSelectRight();
            }
            else if (event.keyCode === keyboardKey.ArrowUp) {
                _this.navigateUp();
            }
            else if (event.keyCode === keyboardKey.ArrowDown) {
                _this.navigateDown();
            }
        };
        this._keyUpHandler = function (event) {
            _this.shiftKeyDown = event.shiftKey;
            if (_this.stage.cursor === 'crosshair' && !_this.mouseSelecting && event.key === 'Shift') {
                _this.stage.cursor = 'default';
            }
        };
        this.onCanvasEvent('keydown', this._keyDownHandler);
        this.onCanvasEvent('keyup', this._keyUpHandler);
        this._stageMouseDownHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            // if only left button is pressed with or without Shift key
            if (event.data.button !== 0 || event.data.buttons !== 1 ||
                event.data.originalEvent.ctrlKey || event.data.originalEvent.altKey) {
                return;
            }
            var extendSelection = event.data.originalEvent.shiftKey && _this.stage.cursor === 'crosshair';
            _this.mouseSelecting = true;
            _this.stage.cursor = 'crosshair';
            var mouseX = event.data.global.x;
            var end = _this.unitController.viewRange.start + bigint_utils_1.BIMath.round(mouseX / _this.stateController.zoomFactor);
            _this.chartLayer.selectState(undefined);
            if (extendSelection) {
                var start = _this.unitController.selectionRange ? _this.unitController.selectionRange.start : BigInt(0);
                _this.unitController.selectionRange = {
                    start: start,
                    end: end
                };
            }
            else {
                _this.unitController.selectionRange = {
                    start: end,
                    end: end
                };
            }
        };
        this.stage.on('mousedown', this._stageMouseDownHandler);
        this._stageMouseMoveHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            if (_this.mouseSelecting && _this.unitController.selectionRange) {
                if ((_this.mouseButtons & 1) === 0) {
                    // handle missed button mouseup event
                    _this.mouseSelecting = false;
                    var orig = event.data.originalEvent;
                    if (!orig.shiftKey || orig.ctrlKey || orig.altKey) {
                        _this.stage.cursor = 'default';
                    }
                    return;
                }
                var mouseX = event.data.global.x;
                var start = _this.unitController.selectionRange.start;
                var end = bigint_utils_1.BIMath.clamp(_this.unitController.viewRange.start + bigint_utils_1.BIMath.round(mouseX / _this.stateController.zoomFactor), BigInt(0), _this.unitController.absoluteRange);
                _this.unitController.selectionRange = {
                    start: start,
                    end: end
                };
            }
        };
        this.stage.on('mousemove', this._stageMouseMoveHandler);
        this._stageMouseUpHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            if (_this.mouseSelecting && event.data.button === 0) {
                _this.mouseSelecting = false;
                var orig = event.data.originalEvent;
                if (!orig.shiftKey || orig.ctrlKey || orig.altKey) {
                    _this.stage.cursor = 'default';
                }
            }
        };
        this.stage.on('mouseup', this._stageMouseUpHandler);
        this.stage.on('mouseupoutside', this._stageMouseUpHandler);
        // right mouse button is not detected on stage
        this._mouseDownHandler = function (e) {
            _this.mouseButtons = e.buttons;
            // if right button is pressed
            if (e.button === 2) {
                // this is the only way to detect mouseup outside of right button
                var mouseUpListener_1 = function (e) {
                    _this.mouseButtons = e.buttons;
                    if (e.button === 2) {
                        document.removeEventListener('mouseup', mouseUpListener_1);
                    }
                };
                document.addEventListener('mouseup', mouseUpListener_1);
            }
        };
        this.onCanvasEvent('mousedown', this._mouseDownHandler);
        this.unitController.onViewRangeChanged(this._updateHandler);
        this.unitController.onSelectionRangeChange(this._updateHandler);
        this.update();
    };
    TimeGraphChartCursors.prototype.maybeCenterCursor = function () {
        if (this.unitController.selectionRange) {
            var cursorPosition = this.unitController.selectionRange.end;
            if (cursorPosition < this.unitController.viewRange.start || cursorPosition > this.unitController.viewRange.end) {
                this.centerCursor();
            }
        }
    };
    ;
    TimeGraphChartCursors.prototype.navigateOrSelectLeft = function () {
        var row = this.rowController.selectedRow;
        if (row && this.unitController.selectionRange) {
            var cursorPosition_1 = this.unitController.selectionRange.end;
            var prevState = row.states.slice().reverse().find(function (stateModel) { return cursorPosition_1 > stateModel.range.end ||
                (cursorPosition_1 > stateModel.range.start && cursorPosition_1 <= stateModel.range.end); });
            if (prevState) {
                var newPos = cursorPosition_1 > prevState.range.end ? prevState.range.end : prevState.range.start;
                this.unitController.selectionRange = { start: this.shiftKeyDown ? this.unitController.selectionRange.start : newPos, end: newPos };
                this.chartLayer.selectState(prevState);
            }
            else {
                this.unitController.selectionRange = { start: this.shiftKeyDown ? this.unitController.selectionRange.start : row.prevPossibleState, end: row.prevPossibleState };
                this.chartLayer.setNavigationFlag(true);
            }
            this.maybeCenterCursor();
        }
    };
    TimeGraphChartCursors.prototype.navigateOrSelectRight = function () {
        var row = this.rowController.selectedRow;
        if (row && this.unitController.selectionRange) {
            var cursorPosition_2 = this.unitController.selectionRange.end;
            var nextState = row.states.find(function (stateModel) { return cursorPosition_2 < stateModel.range.start ||
                (cursorPosition_2 >= stateModel.range.start && cursorPosition_2 < stateModel.range.end); });
            if (nextState) {
                var newPos = cursorPosition_2 < nextState.range.start ? nextState.range.start : nextState.range.end;
                this.unitController.selectionRange = { start: this.shiftKeyDown ? this.unitController.selectionRange.start : newPos, end: newPos };
                this.chartLayer.selectState(nextState);
            }
            else {
                this.unitController.selectionRange = { start: this.shiftKeyDown ? this.unitController.selectionRange.start : row.nextPossibleState, end: row.nextPossibleState };
                this.chartLayer.setNavigationFlag(true);
            }
            this.maybeCenterCursor();
        }
    };
    TimeGraphChartCursors.prototype.navigateDown = function () {
        var _this = this;
        var rows = this.chartLayer.getRowModels();
        var selectedRow = this.rowController.selectedRow;
        var idx = rows.findIndex(function (row) { return row === selectedRow; });
        if (idx < rows.length) {
            this.chartLayer.selectRow(rows[idx + 1]);
        }
        selectedRow = this.rowController.selectedRow;
        var state = selectedRow.states.find(function (state) {
            if (_this.unitController.selectionRange) {
                return state.range.start <= _this.unitController.selectionRange.start && state.range.end > _this.unitController.selectionRange.start;
            }
            return false;
        });
        state && this.chartLayer.selectState(state);
    };
    TimeGraphChartCursors.prototype.navigateUp = function () {
        var _this = this;
        var rows = this.chartLayer.getRowModels();
        var selectedRow = this.rowController.selectedRow;
        var idx = rows.findIndex(function (row) { return row === selectedRow; });
        if (idx > 0) {
            this.chartLayer.selectRow(rows[idx - 1]);
        }
        selectedRow = this.rowController.selectedRow;
        var state = selectedRow.states.find(function (state) {
            if (_this.unitController.selectionRange) {
                return state.range.start <= _this.unitController.selectionRange.start && state.range.end > _this.unitController.selectionRange.start;
            }
            return false;
        });
        state && this.chartLayer.selectState(state);
    };
    TimeGraphChartCursors.prototype.centerCursor = function () {
        if (this.unitController.selectionRange) {
            var cursorPosition = this.unitController.selectionRange.end;
            var halfViewRangeLength = this.unitController.viewRangeLength / BigInt(2);
            var start = cursorPosition - halfViewRangeLength;
            var end = cursorPosition + halfViewRangeLength;
            if (start < 0) {
                end -= start;
                start = BigInt(0);
            }
            else if (end > this.unitController.absoluteRange) {
                start -= (end - this.unitController.absoluteRange);
                end = this.unitController.absoluteRange;
            }
            this.unitController.viewRange = {
                start: start,
                end: end
            };
        }
    };
    TimeGraphChartCursors.prototype.removeCursors = function () {
        this.unitController.selectionRange = undefined;
    };
    TimeGraphChartCursors.prototype.update = function () {
        if (this.unitController.selectionRange) {
            var firstCursorPosition = this.getPixel(this.unitController.selectionRange.start - this.unitController.viewRange.start);
            var secondCursorPosition = this.getPixel(this.unitController.selectionRange.end - this.unitController.viewRange.start);
            var firstCursorOptions = {
                color: this.color,
                height: this.stateController.canvasDisplayHeight,
                position: {
                    x: firstCursorPosition,
                    y: 0
                }
            };
            if (!this.firstCursor) {
                this.firstCursor = new time_graph_cursor_1.TimeGraphCursor(firstCursorOptions);
                this.addChild(this.firstCursor);
            }
            else {
                this.firstCursor.update(firstCursorOptions);
            }
            if (secondCursorPosition !== firstCursorPosition) {
                var secondCursorOptions = {
                    color: this.color,
                    height: this.stateController.canvasDisplayHeight,
                    position: {
                        x: secondCursorPosition,
                        y: 0
                    }
                };
                if (!this.secondCursor) {
                    this.secondCursor = new time_graph_cursor_1.TimeGraphCursor(secondCursorOptions);
                    this.addChild(this.secondCursor);
                }
                else {
                    this.secondCursor.update(secondCursorOptions);
                }
            }
            else if (!!this.secondCursor) {
                this.removeChild(this.secondCursor);
                delete this.secondCursor;
            }
        }
        else {
            this.removeChildren();
            delete this.firstCursor;
            delete this.secondCursor;
        }
    };
    TimeGraphChartCursors.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._updateHandler);
            this.unitController.removeSelectionRangeChangedHandler(this._updateHandler);
        }
        if (this._mouseDownHandler) {
            this.removeOnCanvasEvent('mousedown', this._mouseDownHandler);
        }
        if (this._keyDownHandler) {
            this.removeOnCanvasEvent('keydown', this._keyDownHandler);
        }
        if (this._keyUpHandler) {
            this.removeOnCanvasEvent('mousedown', this._keyUpHandler);
        }
        if (this.stage) {
            this.stage.off('mousedown', this._stageMouseDownHandler);
            this.stage.off('mousemove', this._stageMouseMoveHandler);
            this.stage.off('mouseup', this._stageMouseUpHandler);
            this.stage.off('mouseupoutside', this._stageMouseUpHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphChartCursors;
}(time_graph_chart_layer_1.TimeGraphChartLayer));
exports.TimeGraphChartCursors = TimeGraphChartCursors;
//# sourceMappingURL=time-graph-chart-cursors.js.map