"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractOutputComponent = void 0;
const React = __importStar(require("react"));
const react_fontawesome_1 = require("@fortawesome/react-fontawesome");
const free_solid_svg_icons_1 = require("@fortawesome/free-solid-svg-icons");
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
class AbstractOutputComponent extends React.Component {
    constructor(props) {
        super(props);
        this.DEFAULT_HANDLE_WIDTH = 30;
        this.mainOutputContainer = React.createRef();
        this.closeComponent = this.closeComponent.bind(this);
        this.renderTitleBar = this.renderTitleBar.bind(this);
    }
    render() {
        return React.createElement("div", { style: Object.assign(Object.assign({}, this.props.style), { width: this.props.outputWidth }), id: this.props.traceId + this.props.outputDescriptor.id, tabIndex: -1, className: 'output-container ' + this.props.className, onMouseUp: this.props.onMouseUp, onMouseDown: this.props.onMouseDown, onTouchStart: this.props.onTouchStart, onTouchEnd: this.props.onTouchEnd, "data-tip": '', "data-for": "tooltip-component" },
            React.createElement("div", { id: this.props.traceId + this.props.outputDescriptor.id + 'handle', className: 'widget-handle', style: { width: this.getHandleWidth(), height: this.props.style.height } }, this.renderTitleBar()),
            React.createElement("div", { className: 'main-output-container', ref: this.mainOutputContainer, style: { width: this.props.outputWidth - this.getHandleWidth(), height: this.props.style.height } }, this.renderMainOutputContainer()),
            this.props.children);
    }
    renderTitleBar() {
        const outputName = this.props.outputDescriptor.name;
        return React.createElement(React.Fragment, null,
            React.createElement("button", { className: 'remove-component-button', onClick: this.closeComponent },
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faTimes })),
            React.createElement("div", { className: 'title-bar-label', title: outputName, onClick: () => this.setFocus() },
                outputName,
                React.createElement("i", { id: this.props.traceId + this.props.outputDescriptor.id + 'handleSpinner', className: 'fa fa-refresh fa-spin', style: { marginTop: '5px', visibility: 'hidden' } })));
    }
    closeComponent() {
        this.props.onOutputRemove(this.props.outputDescriptor.id);
    }
    getHandleWidth() {
        return this.props.style.handleWidth || this.DEFAULT_HANDLE_WIDTH;
    }
    getMainAreaWidth() {
        return this.props.outputWidth - this.getHandleWidth();
    }
    renderMainOutputContainer() {
        if (this.state.outputStatus === responses_1.ResponseStatus.FAILED) {
            return this.renderAnalysisFailed();
        }
        if (this.state.outputStatus === responses_1.ResponseStatus.COMPLETED && this.resultsAreEmpty()) {
            return this.renderEmptyResults();
        }
        return this.renderMainArea();
    }
    renderAnalysisFailed() {
        return React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'message-main-area' }, "Trace analysis failed."));
    }
    renderEmptyResults() {
        return React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'message-main-area' },
                "Trace analysis complete.",
                React.createElement("br", null),
                "No results: Trace missing required events."));
    }
}
exports.AbstractOutputComponent = AbstractOutputComponent;
//# sourceMappingURL=abstract-output-component.js.map