"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooltipXYComponent = void 0;
const React = __importStar(require("react"));
class TooltipXYComponent extends React.Component {
    constructor(props) {
        super(props);
        this.horizontalSpace = 35; // space to add between mouse cursor and tooltip
        this.state = {
            tooltipData: undefined,
            onDisplay: false,
            inTooltip: false,
        };
        this.divRef = React.createRef();
    }
    render() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        const leftPos = ((_a = this.state.tooltipData) === null || _a === void 0 ? void 0 : _a.left) ? this.state.tooltipData.left + this.horizontalSpace : undefined;
        const rightPos = ((_b = this.state.tooltipData) === null || _b === void 0 ? void 0 : _b.right) ? this.state.tooltipData.right + this.horizontalSpace : undefined;
        let zeros = 0;
        let allZeros = false;
        if (((_c = this.state.tooltipData) === null || _c === void 0 ? void 0 : _c.zeros) && this.state.tooltipData.zeros > 0) {
            zeros = (_d = this.state.tooltipData) === null || _d === void 0 ? void 0 : _d.zeros;
        }
        if (((_f = (_e = this.state.tooltipData) === null || _e === void 0 ? void 0 : _e.dataPoints) === null || _f === void 0 ? void 0 : _f.length) === 0) {
            allZeros = true;
        }
        return (React.createElement("div", { ref: this.divRef, onMouseEnter: () => {
                this.setState({ inTooltip: true });
                if (this.timerId) {
                    clearTimeout(this.timerId);
                    this.timerId = undefined;
                }
            }, onMouseLeave: () => {
                this.setState({ tooltipData: { opacity: 0, transition: '0s' }, inTooltip: false });
            }, style: {
                padding: 10,
                position: 'absolute',
                textAlign: 'left',
                maxHeight: '250px',
                maxWidth: '400px',
                whiteSpace: 'nowrap',
                overflow: 'auto',
                color: 'white',
                border: '1px solid transparent',
                backgroundColor: 'rgba(51, 122, 183, 0.9)',
                borderRadius: 3,
                top: (_g = this.state.tooltipData) === null || _g === void 0 ? void 0 : _g.top,
                bottom: (_h = this.state.tooltipData) === null || _h === void 0 ? void 0 : _h.bottom,
                right: rightPos,
                left: leftPos,
                opacity: ((_j = this.state.tooltipData) === null || _j === void 0 ? void 0 : _j.opacity) ? this.state.tooltipData.opacity : 0,
                transition: ((_k = this.state.tooltipData) === null || _k === void 0 ? void 0 : _k.transition) ? 'opacity ' + this.state.tooltipData.transition : 'opacity 0.3s',
                zIndex: 999
            } },
            React.createElement("p", { style: { margin: '0 0 5px 0' } }, (_l = this.state.tooltipData) === null || _l === void 0 ? void 0 : _l.title),
            React.createElement("ul", { style: { padding: '0' } }, (_o = (_m = this.state.tooltipData) === null || _m === void 0 ? void 0 : _m.dataPoints) === null || _o === void 0 ? void 0 : _o.map((point, i) => React.createElement("li", { key: i, style: { listStyle: 'none', display: 'flex', marginBottom: 5 } },
                React.createElement("div", { style: {
                        height: '10px',
                        width: '10px',
                        margin: 'auto 0',
                        border: 'solid thin',
                        borderColor: point.color,
                        backgroundColor: point.background
                    } }),
                React.createElement("span", { style: { marginLeft: '5px' } },
                    point.label,
                    " ",
                    point.value)))),
            allZeros ?
                React.createElement("p", { style: { marginBottom: 0 } }, "All values: 0")
                :
                    zeros > 0 &&
                        React.createElement("p", { style: { marginBottom: 0 } }, (_p = this.state.tooltipData) === null || _p === void 0 ? void 0 :
                            _p.zeros,
                            " other",
                            zeros > 1 ? 's' : '',
                            ": 0")));
    }
    setElement(tooltipData) {
        if (this.timerId) {
            clearTimeout(this.timerId);
        }
        this.timerId = setTimeout(() => {
            this.setState({ tooltipData, onDisplay: true });
        }, 500);
        if (this.state.onDisplay) {
            this.setState({ onDisplay: false });
            setTimeout(() => {
                if (!this.state.inTooltip) {
                    this.setState({ tooltipData: { opacity: 0, transition: '0s' }, inTooltip: false });
                }
            }, 500);
        }
    }
}
exports.TooltipXYComponent = TooltipXYComponent;
//# sourceMappingURL=tooltip-xy-component.js.map