"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTextModel = exports.StandaloneDiffEditor = exports.StandaloneEditor = exports.StandaloneCodeEditor = void 0;
const aria = require("../../../base/browser/ui/aria/aria");
const lifecycle_1 = require("../../../base/common/lifecycle");
const codeEditorService_1 = require("../../browser/services/codeEditorService");
const codeEditorWidget_1 = require("../../browser/widget/codeEditorWidget");
const diffEditorWidget_1 = require("../../browser/widget/diffEditorWidget");
const editorAction_1 = require("../../common/editorAction");
const editorWorker_1 = require("../../common/services/editorWorker");
const standaloneServices_1 = require("./standaloneServices");
const standaloneTheme_1 = require("../common/standaloneTheme");
const actions_1 = require("../../../platform/actions/common/actions");
const commands_1 = require("../../../platform/commands/common/commands");
const configuration_1 = require("../../../platform/configuration/common/configuration");
const contextkey_1 = require("../../../platform/contextkey/common/contextkey");
const contextView_1 = require("../../../platform/contextview/browser/contextView");
const instantiation_1 = require("../../../platform/instantiation/common/instantiation");
const keybinding_1 = require("../../../platform/keybinding/common/keybinding");
const notification_1 = require("../../../platform/notification/common/notification");
const themeService_1 = require("../../../platform/theme/common/themeService");
const accessibility_1 = require("../../../platform/accessibility/common/accessibility");
const standaloneStrings_1 = require("../../common/standaloneStrings");
const clipboardService_1 = require("../../../platform/clipboard/common/clipboardService");
const progress_1 = require("../../../platform/progress/common/progress");
const model_1 = require("../../common/services/model");
const language_1 = require("../../common/languages/language");
const standaloneCodeEditorService_1 = require("./standaloneCodeEditorService");
const modesRegistry_1 = require("../../common/languages/modesRegistry");
const languageConfigurationRegistry_1 = require("../../common/languages/languageConfigurationRegistry");
const languageFeatures_1 = require("../../common/services/languageFeatures");
let LAST_GENERATED_COMMAND_ID = 0;
let ariaDomNodeCreated = false;
/**
 * Create ARIA dom node inside parent,
 * or only for the first editor instantiation inside document.body.
 * @param parent container element for ARIA dom node
 */
function createAriaDomNode(parent) {
    if (!parent) {
        if (ariaDomNodeCreated) {
            return;
        }
        ariaDomNodeCreated = true;
    }
    aria.setARIAContainer(parent || document.body);
}
/**
 * A code editor to be used both by the standalone editor and the standalone diff editor.
 */
let StandaloneCodeEditor = class StandaloneCodeEditor extends codeEditorWidget_1.CodeEditorWidget {
    constructor(domElement, _options, instantiationService, codeEditorService, commandService, contextKeyService, keybindingService, themeService, notificationService, accessibilityService, languageConfigurationService, languageFeaturesService) {
        const options = Object.assign({}, _options);
        options.ariaLabel = options.ariaLabel || standaloneStrings_1.StandaloneCodeEditorNLS.editorViewAccessibleLabel;
        options.ariaLabel = options.ariaLabel + ';' + (standaloneStrings_1.StandaloneCodeEditorNLS.accessibilityHelpMessage);
        super(domElement, options, {}, instantiationService, codeEditorService, commandService, contextKeyService, themeService, notificationService, accessibilityService, languageConfigurationService, languageFeaturesService);
        if (keybindingService instanceof standaloneServices_1.StandaloneKeybindingService) {
            this._standaloneKeybindingService = keybindingService;
        }
        else {
            this._standaloneKeybindingService = null;
        }
        createAriaDomNode(options.ariaContainerElement);
    }
    addCommand(keybinding, handler, context) {
        if (!this._standaloneKeybindingService) {
            console.warn('Cannot add command because the editor is configured with an unrecognized KeybindingService');
            return null;
        }
        const commandId = 'DYNAMIC_' + (++LAST_GENERATED_COMMAND_ID);
        const whenExpression = contextkey_1.ContextKeyExpr.deserialize(context);
        this._standaloneKeybindingService.addDynamicKeybinding(commandId, keybinding, handler, whenExpression);
        return commandId;
    }
    createContextKey(key, defaultValue) {
        return this._contextKeyService.createKey(key, defaultValue);
    }
    addAction(_descriptor) {
        if ((typeof _descriptor.id !== 'string') || (typeof _descriptor.label !== 'string') || (typeof _descriptor.run !== 'function')) {
            throw new Error('Invalid action descriptor, `id`, `label` and `run` are required properties!');
        }
        if (!this._standaloneKeybindingService) {
            console.warn('Cannot add keybinding because the editor is configured with an unrecognized KeybindingService');
            return lifecycle_1.Disposable.None;
        }
        // Read descriptor options
        const id = _descriptor.id;
        const label = _descriptor.label;
        const precondition = contextkey_1.ContextKeyExpr.and(contextkey_1.ContextKeyExpr.equals('editorId', this.getId()), contextkey_1.ContextKeyExpr.deserialize(_descriptor.precondition));
        const keybindings = _descriptor.keybindings;
        const keybindingsWhen = contextkey_1.ContextKeyExpr.and(precondition, contextkey_1.ContextKeyExpr.deserialize(_descriptor.keybindingContext));
        const contextMenuGroupId = _descriptor.contextMenuGroupId || null;
        const contextMenuOrder = _descriptor.contextMenuOrder || 0;
        const run = (accessor, ...args) => {
            return Promise.resolve(_descriptor.run(this, ...args));
        };
        const toDispose = new lifecycle_1.DisposableStore();
        // Generate a unique id to allow the same descriptor.id across multiple editor instances
        const uniqueId = this.getId() + ':' + id;
        // Register the command
        toDispose.add(commands_1.CommandsRegistry.registerCommand(uniqueId, run));
        // Register the context menu item
        if (contextMenuGroupId) {
            const menuItem = {
                command: {
                    id: uniqueId,
                    title: label
                },
                when: precondition,
                group: contextMenuGroupId,
                order: contextMenuOrder
            };
            toDispose.add(actions_1.MenuRegistry.appendMenuItem(actions_1.MenuId.EditorContext, menuItem));
        }
        // Register the keybindings
        if (Array.isArray(keybindings)) {
            for (const kb of keybindings) {
                toDispose.add(this._standaloneKeybindingService.addDynamicKeybinding(uniqueId, kb, run, keybindingsWhen));
            }
        }
        // Finally, register an internal editor action
        const internalAction = new editorAction_1.InternalEditorAction(uniqueId, label, label, precondition, run, this._contextKeyService);
        // Store it under the original id, such that trigger with the original id will work
        this._actions[id] = internalAction;
        toDispose.add((0, lifecycle_1.toDisposable)(() => {
            delete this._actions[id];
        }));
        return toDispose;
    }
    _triggerCommand(handlerId, payload) {
        if (this._codeEditorService instanceof standaloneCodeEditorService_1.StandaloneCodeEditorService) {
            // Help commands find this editor as the active editor
            try {
                this._codeEditorService.setActiveCodeEditor(this);
                super._triggerCommand(handlerId, payload);
            }
            finally {
                this._codeEditorService.setActiveCodeEditor(null);
            }
        }
        else {
            super._triggerCommand(handlerId, payload);
        }
    }
};
StandaloneCodeEditor = __decorate([
    __param(2, instantiation_1.IInstantiationService),
    __param(3, codeEditorService_1.ICodeEditorService),
    __param(4, commands_1.ICommandService),
    __param(5, contextkey_1.IContextKeyService),
    __param(6, keybinding_1.IKeybindingService),
    __param(7, themeService_1.IThemeService),
    __param(8, notification_1.INotificationService),
    __param(9, accessibility_1.IAccessibilityService),
    __param(10, languageConfigurationRegistry_1.ILanguageConfigurationService),
    __param(11, languageFeatures_1.ILanguageFeaturesService)
], StandaloneCodeEditor);
exports.StandaloneCodeEditor = StandaloneCodeEditor;
let StandaloneEditor = class StandaloneEditor extends StandaloneCodeEditor {
    constructor(domElement, _options, instantiationService, codeEditorService, commandService, contextKeyService, keybindingService, themeService, notificationService, configurationService, accessibilityService, modelService, languageService, languageConfigurationService, languageFeaturesService) {
        const options = Object.assign({}, _options);
        (0, standaloneServices_1.updateConfigurationService)(configurationService, options, false);
        const themeDomRegistration = themeService.registerEditorContainer(domElement);
        if (typeof options.theme === 'string') {
            themeService.setTheme(options.theme);
        }
        if (typeof options.autoDetectHighContrast !== 'undefined') {
            themeService.setAutoDetectHighContrast(Boolean(options.autoDetectHighContrast));
        }
        const _model = options.model;
        delete options.model;
        super(domElement, options, instantiationService, codeEditorService, commandService, contextKeyService, keybindingService, themeService, notificationService, accessibilityService, languageConfigurationService, languageFeaturesService);
        this._configurationService = configurationService;
        this._standaloneThemeService = themeService;
        this._register(themeDomRegistration);
        let model;
        if (typeof _model === 'undefined') {
            const languageId = languageService.getLanguageIdByMimeType(options.language) || options.language || modesRegistry_1.PLAINTEXT_LANGUAGE_ID;
            model = createTextModel(modelService, languageService, options.value || '', languageId, undefined);
            this._ownsModel = true;
        }
        else {
            model = _model;
            this._ownsModel = false;
        }
        this._attachModel(model);
        if (model) {
            const e = {
                oldModelUrl: null,
                newModelUrl: model.uri
            };
            this._onDidChangeModel.fire(e);
        }
    }
    dispose() {
        super.dispose();
    }
    updateOptions(newOptions) {
        (0, standaloneServices_1.updateConfigurationService)(this._configurationService, newOptions, false);
        if (typeof newOptions.theme === 'string') {
            this._standaloneThemeService.setTheme(newOptions.theme);
        }
        if (typeof newOptions.autoDetectHighContrast !== 'undefined') {
            this._standaloneThemeService.setAutoDetectHighContrast(Boolean(newOptions.autoDetectHighContrast));
        }
        super.updateOptions(newOptions);
    }
    _postDetachModelCleanup(detachedModel) {
        super._postDetachModelCleanup(detachedModel);
        if (detachedModel && this._ownsModel) {
            detachedModel.dispose();
            this._ownsModel = false;
        }
    }
};
StandaloneEditor = __decorate([
    __param(2, instantiation_1.IInstantiationService),
    __param(3, codeEditorService_1.ICodeEditorService),
    __param(4, commands_1.ICommandService),
    __param(5, contextkey_1.IContextKeyService),
    __param(6, keybinding_1.IKeybindingService),
    __param(7, standaloneTheme_1.IStandaloneThemeService),
    __param(8, notification_1.INotificationService),
    __param(9, configuration_1.IConfigurationService),
    __param(10, accessibility_1.IAccessibilityService),
    __param(11, model_1.IModelService),
    __param(12, language_1.ILanguageService),
    __param(13, languageConfigurationRegistry_1.ILanguageConfigurationService),
    __param(14, languageFeatures_1.ILanguageFeaturesService)
], StandaloneEditor);
exports.StandaloneEditor = StandaloneEditor;
let StandaloneDiffEditor = class StandaloneDiffEditor extends diffEditorWidget_1.DiffEditorWidget {
    constructor(domElement, _options, instantiationService, contextKeyService, editorWorkerService, codeEditorService, themeService, notificationService, configurationService, contextMenuService, editorProgressService, clipboardService) {
        const options = Object.assign({}, _options);
        (0, standaloneServices_1.updateConfigurationService)(configurationService, options, true);
        const themeDomRegistration = themeService.registerEditorContainer(domElement);
        if (typeof options.theme === 'string') {
            themeService.setTheme(options.theme);
        }
        if (typeof options.autoDetectHighContrast !== 'undefined') {
            themeService.setAutoDetectHighContrast(Boolean(options.autoDetectHighContrast));
        }
        super(domElement, options, {}, clipboardService, editorWorkerService, contextKeyService, instantiationService, codeEditorService, themeService, notificationService, contextMenuService, editorProgressService);
        this._configurationService = configurationService;
        this._standaloneThemeService = themeService;
        this._register(themeDomRegistration);
    }
    dispose() {
        super.dispose();
    }
    updateOptions(newOptions) {
        (0, standaloneServices_1.updateConfigurationService)(this._configurationService, newOptions, true);
        if (typeof newOptions.theme === 'string') {
            this._standaloneThemeService.setTheme(newOptions.theme);
        }
        if (typeof newOptions.autoDetectHighContrast !== 'undefined') {
            this._standaloneThemeService.setAutoDetectHighContrast(Boolean(newOptions.autoDetectHighContrast));
        }
        super.updateOptions(newOptions);
    }
    _createInnerEditor(instantiationService, container, options) {
        return instantiationService.createInstance(StandaloneCodeEditor, container, options);
    }
    getOriginalEditor() {
        return super.getOriginalEditor();
    }
    getModifiedEditor() {
        return super.getModifiedEditor();
    }
    addCommand(keybinding, handler, context) {
        return this.getModifiedEditor().addCommand(keybinding, handler, context);
    }
    createContextKey(key, defaultValue) {
        return this.getModifiedEditor().createContextKey(key, defaultValue);
    }
    addAction(descriptor) {
        return this.getModifiedEditor().addAction(descriptor);
    }
};
StandaloneDiffEditor = __decorate([
    __param(2, instantiation_1.IInstantiationService),
    __param(3, contextkey_1.IContextKeyService),
    __param(4, editorWorker_1.IEditorWorkerService),
    __param(5, codeEditorService_1.ICodeEditorService),
    __param(6, standaloneTheme_1.IStandaloneThemeService),
    __param(7, notification_1.INotificationService),
    __param(8, configuration_1.IConfigurationService),
    __param(9, contextView_1.IContextMenuService),
    __param(10, progress_1.IEditorProgressService),
    __param(11, clipboardService_1.IClipboardService)
], StandaloneDiffEditor);
exports.StandaloneDiffEditor = StandaloneDiffEditor;
/**
 * @internal
 */
function createTextModel(modelService, languageService, value, languageId, uri) {
    value = value || '';
    if (!languageId) {
        const firstLF = value.indexOf('\n');
        let firstLine = value;
        if (firstLF !== -1) {
            firstLine = value.substring(0, firstLF);
        }
        return doCreateModel(modelService, value, languageService.createByFilepathOrFirstLine(uri || null, firstLine), uri);
    }
    return doCreateModel(modelService, value, languageService.createById(languageId), uri);
}
exports.createTextModel = createTextModel;
/**
 * @internal
 */
function doCreateModel(modelService, value, languageSelection, uri) {
    return modelService.createModel(value, languageSelection, uri);
}
//# sourceMappingURL=standaloneCodeEditor.js.map