"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphAxisScale = void 0;
var PIXI = require("pixi.js-legacy");
var time_graph_component_1 = require("./time-graph-component");
var _ = require("lodash");
var bigint_utils_1 = require("../bigint-utils");
var TimeGraphAxisScale = /** @class */ (function (_super) {
    __extends(TimeGraphAxisScale, _super);
    function TimeGraphAxisScale(id, _options, unitController, stateController) {
        var _this = _super.call(this, id) || this;
        _this._options = _options;
        _this.unitController = unitController;
        _this.stateController = stateController;
        _this.mouseIsDown = false;
        _this.addEvents();
        _this.labels = [];
        return _this;
    }
    TimeGraphAxisScale.prototype.addEvents = function () {
        var _this = this;
        var mouseMove = _.throttle(function (event) {
            if (_this.mouseIsDown) {
                _this.zoomAroundLeftViewBorder(event.data.global.x);
            }
        }, 40);
        this.addEvent('mousedown', function (event) {
            _this.mouseStartY = event.data.global.y;
            _this.mouseStartX = event.data.global.x;
            _this.oldViewRange = _this.unitController.viewRange;
            _this.mouseIsDown = true;
        }, this._displayObject);
        this.addEvent('mousemove', mouseMove, this._displayObject);
        var moveEnd = function (event) {
            _this.mouseIsDown = false;
        };
        this.addEvent('mouseup', moveEnd, this._displayObject);
        this.addEvent('mouseupoutside', moveEnd, this._displayObject);
    };
    TimeGraphAxisScale.prototype.getStepLength = function (labelWidth) {
        var canvasDisplayWidth = this.stateController.canvasDisplayWidth;
        var minCanvasStepWidth = Math.max(labelWidth, 80);
        var viewRangeLength = this.unitController.viewRangeLength;
        var maxSteps = canvasDisplayWidth / minCanvasStepWidth;
        var realStepLength = Number(viewRangeLength) / maxSteps;
        var log = Math.log10(realStepLength);
        var logRounded = Math.round(log);
        var normalizedStepLength = Math.pow(10, logRounded);
        var residual = realStepLength / normalizedStepLength;
        var steps = this.unitController.scaleSteps || [1, 2, 5, 10];
        var normStepLength = steps.find(function (s) { return s > residual; });
        var stepLength = Math.max(normalizedStepLength * (normStepLength || 1), 1);
        return stepLength;
    };
    TimeGraphAxisScale.prototype.renderVerticalLines = function (drawLabels, lineColor, lineStyle) {
        if (this.unitController.viewRangeLength > 0 && this.stateController.canvasDisplayWidth > 0) {
            var labelWidth = 0;
            if (this.unitController.numberTranslator) {
                var label = this.unitController.numberTranslator(this.unitController.viewRange.end);
                if (label) {
                    var style = new PIXI.TextStyle({ fontSize: 10 });
                    var textMetrics = PIXI.TextMetrics.measureText(label, style);
                    labelWidth = textMetrics.width;
                }
            }
            var stepLength = BigInt(this.getStepLength(labelWidth));
            var canvasDisplayWidth = this.stateController.canvasDisplayWidth;
            var zoomFactor = this.stateController.zoomFactor;
            var viewRangeStart = this.unitController.viewRange.start + this.unitController.offset;
            var viewRangeEnd = this.unitController.viewRange.end + this.unitController.offset;
            var startTime = (viewRangeStart / stepLength) * stepLength;
            for (var time = startTime; time <= viewRangeEnd; time += stepLength) {
                var xpos = Number(time - viewRangeStart) * zoomFactor;
                if (xpos >= 0 && xpos < canvasDisplayWidth) {
                    var labelCenter = {
                        x: xpos,
                        y: this._options.position.y
                    };
                    var label = void 0;
                    if (drawLabels && this.unitController.numberTranslator) {
                        label = this.unitController.numberTranslator(time - this.unitController.offset);
                        if (label) {
                            var text = new PIXI.Text(label, {
                                fontSize: 10,
                                fill: lineColor
                            });
                            var textPosition = this.getTextPosition(labelCenter, text, lineStyle);
                            text.x = textPosition.x;
                            text.y = textPosition.y;
                            this.labels.push(text);
                            this._displayObject.addChild(text);
                        }
                    }
                    var verticalLinePosition = {
                        x: xpos,
                        y: this.getVerticalLineYPosition(lineStyle(label).lineHeight)
                    };
                    this.vline({
                        position: verticalLinePosition,
                        height: lineStyle(label).lineHeight,
                        color: lineColor
                    });
                }
            }
        }
    };
    TimeGraphAxisScale.prototype.update = function (opts) {
        this.labels.forEach(function (label) { return label.destroy(); });
        this.labels = [];
        _super.prototype.update.call(this, opts);
    };
    TimeGraphAxisScale.prototype.render = function () {
        this.renderVerticalLines(true, this._options.lineColor || 0x000000, function (l) { return ({ lineHeight: l === '' || l === undefined ? 5 : 10 }); });
    };
    TimeGraphAxisScale.prototype.zoomAroundLeftViewBorder = function (mouseX) {
        if (mouseX <= 0) {
            return;
        }
        var start = this.oldViewRange.start;
        var end = bigint_utils_1.BIMath.min(this.oldViewRange.start + bigint_utils_1.BIMath.round(Number(this.oldViewRange.end - this.oldViewRange.start) * (this.mouseStartX / mouseX)), this.unitController.absoluteRange);
        if (bigint_utils_1.BIMath.abs(end - start) > 1) {
            this.unitController.viewRange = {
                start: start,
                end: end
            };
        }
    };
    TimeGraphAxisScale.prototype.getVerticalLineYPosition = function (lineHeight) {
        if (this._options.verticalAlign === 'bottom') {
            return this._options.height - lineHeight;
        }
        // By default the tick will be at the top
        return 0;
    };
    TimeGraphAxisScale.prototype.getTextPosition = function (labelCenter, textElement, lineStyle) {
        var xPosition = labelCenter.x - (textElement.width / 2);
        var yPosition = labelCenter.y + lineStyle(textElement.text).lineHeight;
        // If the vertical line is at the bottom, we add some space between the line and the textElement
        if (this._options.verticalAlign === 'bottom') {
            yPosition = yPosition - 3;
        }
        return {
            x: xPosition,
            y: yPosition
        };
    };
    return TimeGraphAxisScale;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphAxisScale = TimeGraphAxisScale;
//# sourceMappingURL=time-graph-axis-scale.js.map