"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphStateController = void 0;
var TimeGraphStateController = /** @class */ (function () {
    function TimeGraphStateController(canvas, unitController) {
        this.canvas = canvas;
        this.unitController = unitController;
        this.ratio = window.devicePixelRatio;
        this._canvasDisplayWidth = this.canvas.width / this.ratio;
        this._canvasDisplayHeight = this.canvas.height / this.ratio;
        this._initialZoomFactor = this.zoomFactor;
        this._positionOffset = { x: 0, y: 0 };
        this.oldPositionOffset = { x: 0, y: 0 };
        this.zoomChangedHandlers = [];
        this.positionChangedHandlers = [];
        this.canvasDisplayWidthChangedHandlers = [];
        this.snapped = false;
    }
    TimeGraphStateController.prototype.handleZoomChange = function () {
        this.zoomChangedHandlers.forEach(function (handler) { return handler(); });
    };
    TimeGraphStateController.prototype.handlePositionChange = function () {
        this.positionChangedHandlers.forEach(function (handler) { return handler(); });
    };
    TimeGraphStateController.prototype.handleCanvasDisplayWidthChange = function () {
        this.canvasDisplayWidthChangedHandlers.forEach(function (handler) { return handler(); });
    };
    TimeGraphStateController.prototype.onZoomChanged = function (handler) {
        this.zoomChangedHandlers.push(handler);
    };
    TimeGraphStateController.prototype.onPositionChanged = function (handler) {
        this.positionChangedHandlers.push(handler);
    };
    TimeGraphStateController.prototype.onCanvasDisplayWidthChanged = function (handler) {
        this.canvasDisplayWidthChangedHandlers.push(handler);
    };
    Object.defineProperty(TimeGraphStateController.prototype, "canvasDisplayWidth", {
        /**
            It is not the width of the canvas display buffer but of the canvas element in browser. Can be different depending on the display pixel ratio.
        */
        get: function () {
            return this._canvasDisplayWidth;
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphStateController.prototype.updateDisplayWidth = function () {
        this._canvasDisplayWidth = this.canvas.width / this.ratio;
    };
    Object.defineProperty(TimeGraphStateController.prototype, "canvasDisplayHeight", {
        /**
            It is not the heigth of the canvas display buffer but of the canvas element in browser. Can be different depending on the display pixel ratio.
        */
        get: function () {
            return this._canvasDisplayHeight;
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphStateController.prototype.updateDisplayHeight = function () {
        this._canvasDisplayHeight = this.canvas.height / this.ratio;
    };
    Object.defineProperty(TimeGraphStateController.prototype, "initialZoomFactor", {
        get: function () {
            return this._initialZoomFactor;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateController.prototype, "zoomFactor", {
        get: function () {
            this._zoomFactor = this.canvasDisplayWidth / Number(this.unitController.viewRangeLength);
            return this._zoomFactor;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateController.prototype, "absoluteResolution", {
        get: function () {
            return this.canvasDisplayWidth / Number(this.unitController.absoluteRange);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateController.prototype, "positionOffset", {
        get: function () {
            return this._positionOffset;
        },
        set: function (value) {
            this._positionOffset = value;
            this.handlePositionChange();
        },
        enumerable: false,
        configurable: true
    });
    return TimeGraphStateController;
}());
exports.TimeGraphStateController = TimeGraphStateController;
//# sourceMappingURL=time-graph-state-controller.js.map