/*********************************************************************
 * Copyright (c) 2018 QNX Software Systems and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { IGDBBackend } from '../types/gdb';
import { MIResponse } from './base';
export declare enum MIVarPrintValues {
    no = "0",
    all = "1",
    simple = "2"
}
export interface MIVarCreateResponse extends MIResponse {
    name: string;
    numchild: string;
    value: string;
    type: string;
    'thread-id'?: string;
    has_more?: string;
    dynamic?: string;
    displayhint?: string;
}
export interface MIVarListChildrenResponse {
    numchild: string;
    children: MIVarChild[];
}
export interface MIVarChild {
    name: string;
    exp: string;
    numchild: string;
    type: string;
    value?: string;
    'thread-id'?: string;
    frozen?: string;
    displayhint?: string;
    dynamic?: string;
}
export interface MIVarUpdateResponse {
    changelist: Array<{
        name: string;
        value: string;
        in_scope: string;
        type_changed: string;
        has_more: string;
    }>;
}
export interface MIVarEvalResponse {
    value: string;
}
export interface MIVarAssignResponse {
    value: string;
}
export interface MIVarPathInfoResponse {
    path_expr: string;
}
export declare function sendVarCreate(gdb: IGDBBackend, params: {
    name?: string;
    frameAddr?: string;
    frame?: 'current' | 'floating';
    expression: string;
    threadId?: number;
    frameId?: number;
}): Promise<MIVarCreateResponse>;
export declare function sendVarListChildren(gdb: IGDBBackend, params: {
    printValues?: MIVarPrintValues.no | MIVarPrintValues.all | MIVarPrintValues.simple;
    name: string;
    from?: number;
    to?: number;
}): Promise<MIVarListChildrenResponse>;
export declare function sendVarUpdate(gdb: IGDBBackend, params: {
    name?: string;
    printValues?: MIVarPrintValues.no | MIVarPrintValues.all | MIVarPrintValues.simple;
}): Promise<MIVarUpdateResponse>;
export declare function sendVarDelete(gdb: IGDBBackend, params: {
    varname: string;
}): Promise<void>;
export declare function sendVarAssign(gdb: IGDBBackend, params: {
    varname: string;
    expression: string;
}): Promise<MIVarAssignResponse>;
export declare function sendVarEvaluateExpression(gdb: IGDBBackend, params: {
    varname: string;
}): Promise<MIVarEvalResponse>;
export declare function sendVarInfoPathExpression(gdb: IGDBBackend, name: string): Promise<MIVarPathInfoResponse>;
export declare function sendVarSetFormatToHex(gdb: IGDBBackend, name: string): Promise<void>;
