/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectMainTypeNameProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectPackageDeclarationProposalCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;

public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        IJavaProject javaProject = cu.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        CompilationUnit root = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(root);
        if (!(coveredNode instanceof SimpleName)) {
            return;
        }
        ASTNode parentType = coveredNode.getParent();
        if (!(parentType instanceof AbstractTypeDeclaration)) {
            return;
        }
        String currTypeName = ((SimpleName)coveredNode).getIdentifier();
        String newTypeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        boolean hasOtherPublicTypeBefore = false;
        boolean found = false;
        List types = root.types();
        int i = 0;
        while (i < types.size()) {
            AbstractTypeDeclaration curr = (AbstractTypeDeclaration)types.get(i);
            if (parentType != curr) {
                if (newTypeName.equals(curr.getName().getIdentifier())) {
                    return;
                }
                if (!found && Modifier.isPublic((int)curr.getModifiers())) {
                    hasOtherPublicTypeBefore = true;
                }
            } else {
                found = true;
            }
            ++i;
        }
        if (!JavaConventions.validateJavaTypeName((String)newTypeName, (String)sourceLevel, (String)compliance).matches(4)) {
            String title = Messages.format((String)CorrectionMessages.ReorgCorrectionsSubProcessor_renametype_description, (Object)BasicElementLabels.getJavaElementName((String)newTypeName));
            CorrectMainTypeNameProposalCore p = new CorrectMainTypeNameProposalCore(title, cu, null, context, currTypeName, newTypeName, 5);
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, "quickfix"));
        }
        if (!hasOtherPublicTypeBefore && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isResourceOperationSupported()) {
            String newCUName = JavaModelUtil.getRenamedCUName((ICompilationUnit)cu, (String)currTypeName);
            ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
            if (!(newCU.exists() || isLinked || JavaConventions.validateCompilationUnitName((String)newCUName, (String)sourceLevel, (String)compliance).matches(4))) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = Messages.format((String)CorrectionMessages.ReorgCorrectionsSubProcessor_renamecu_description, (Object)BasicElementLabels.getResourceName((String)newCUName));
                ChangeCorrectionProposalCore proposal = new ChangeCorrectionProposalCore(label, (Change)change, 6);
                proposals.add(CodeActionHandler.wrap(proposal, "quickfix"));
            }
        }
    }

    public static void getWrongPackageDeclNameProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        int relevance = cu.getPackageDeclarations().length == 0 ? 7 : 5;
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)new CorrectPackageDeclarationProposalCore(cu, problem, relevance), "quickfix"));
        IPackageDeclaration[] packDecls = cu.getPackageDeclarations();
        String newPackName = packDecls.length > 0 ? packDecls[0].getElementName() : "";
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
        IPackageFragment newPack = root.getPackageFragment(newPackName);
        ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
        boolean isLinked = cu.getResource().isLinked();
        if (!newCU.exists() && !isLinked) {
            String label;
            if (newPack.isDefaultPackage()) {
                label = Messages.format((String)CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_default_description, (Object)BasicElementLabels.getFileName((ITypeRoot)cu));
            } else {
                String packageLabel = JavaElementLabelsCore.getElementLabel((IJavaElement)newPack, (long)0x200009L);
                label = Messages.format((String)CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_description, (Object[])new Object[]{BasicElementLabels.getFileName((ITypeRoot)cu), packageLabel});
            }
            ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(label, (Change)new MoveCompilationUnitChange(cu, newPack), 6);
            proposals.add(CodeActionHandler.wrap(p, "quickfix"));
        }
    }

    public static void removeImportStatementProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) throws CoreException {
        ICleanUpFixCore removeAllUnusedImportsFix;
        UnusedCodeFixCore fix = UnusedCodeFixCore.createRemoveUnusedImportFix((CompilationUnit)context.getASTRoot(), (IProblemLocationCore)problem);
        if (fix != null) {
            try {
                CompilationUnitChange change = fix.createChange(null);
                CUCorrectionProposalCore proposal = new CUCorrectionProposalCore(change.getName(), change.getCompilationUnit(), (TextChange)change, 6);
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
            }
        }
        if ((removeAllUnusedImportsFix = UnusedCodeFixCore.createCleanUp((CompilationUnit)context.getASTRoot(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false)) != null) {
            CompilationUnitChange change = removeAllUnusedImportsFix.createChange(null);
            CUCorrectionProposalCore proposal = new CUCorrectionProposalCore(CorrectionMessages.ReorgCorrectionsSubProcessor_remove_all_unused_imports, change.getCompilationUnit(), (TextChange)change, 6);
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        }
    }
}

