/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.help.IContextProvider;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.RealCallers;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyFiltersActionGroup;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyTransferDropAdapter;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.jdt.internal.ui.callhierarchy.CancelSearchAction;
import org.eclipse.jdt.internal.ui.callhierarchy.CopyCallHierarchyAction;
import org.eclipse.jdt.internal.ui.callhierarchy.ExpandWithConstructorsAction;
import org.eclipse.jdt.internal.ui.callhierarchy.FocusOnSelectionAction;
import org.eclipse.jdt.internal.ui.callhierarchy.HistoryDropDownAction;
import org.eclipse.jdt.internal.ui.callhierarchy.ICallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.LocationCopyAction;
import org.eclipse.jdt.internal.ui.callhierarchy.LocationViewer;
import org.eclipse.jdt.internal.ui.callhierarchy.OpenLocationAction;
import org.eclipse.jdt.internal.ui.callhierarchy.PinCallHierarchyViewAction;
import org.eclipse.jdt.internal.ui.callhierarchy.RefreshElementAction;
import org.eclipse.jdt.internal.ui.callhierarchy.RefreshViewAction;
import org.eclipse.jdt.internal.ui.callhierarchy.RemoveFromViewAction;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.jdt.internal.ui.callhierarchy.SelectFieldModeAction;
import org.eclipse.jdt.internal.ui.callhierarchy.ShowSearchInDialogAction;
import org.eclipse.jdt.internal.ui.callhierarchy.ToggleCallModeAction;
import org.eclipse.jdt.internal.ui.callhierarchy.ToggleOrientationAction;
import org.eclipse.jdt.internal.ui.callhierarchy.TreeRoot;
import org.eclipse.jdt.internal.ui.dnd.EditorInputTransferDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.PluginTransferDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jdt.ui.actions.OpenViewActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class CallHierarchyViewPart
extends ViewPart
implements ICallHierarchyViewPart,
ISelectionChangedListener {
    private static final String DIALOGSTORE_VIEWORIENTATION = "CallHierarchyViewPart.orientation";
    private static final String DIALOGSTORE_CALL_MODE = "CallHierarchyViewPart.call_mode";
    private static final String DIALOGSTORE_FIELD_MODE = "CallHierarchyViewPart.field_mode";
    private static final String DIALOGSTORE_RATIO = "CallHierarchyViewPart.ratio";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_SINGLE = 2;
    static final int VIEW_ORIENTATION_AUTOMATIC = 3;
    static final int CALL_MODE_CALLERS = 0;
    static final int CALL_MODE_CALLEES = 1;
    static final String GROUP_SEARCH_SCOPE = "MENU_SEARCH_SCOPE";
    static final String ID_CALL_HIERARCHY = "org.eclipse.jdt.callhierarchy.view";
    private static final String GROUP_FOCUS = "group.focus";
    private static final int PAGE_EMPTY = 0;
    private static final int PAGE_VIEWER = 1;
    private Label fNoHierarchyShownLabel;
    private PageBook fPagebook;
    private final IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    private int fCurrentOrientation;
    int fOrientation = 3;
    private int fCurrentCallMode;
    private int fCurrentFieldMode;
    private MethodWrapper[] fCalleeRoots;
    private MethodWrapper[] fCallerRoots;
    private IMemento fMemento;
    private IMember[] fInputElements;
    private CallHierarchySelectionProvider fSelectionProviderMediator;
    private LocationViewer fLocationViewer;
    private SashForm fHierarchyLocationSplitter;
    private Clipboard fClipboard;
    private SearchScopeActionGroup fSearchScopeActions;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private ToggleCallModeAction[] fToggleCallModeActions;
    private SelectFieldModeAction[] fToggleFieldModeActions;
    private CallHierarchyFiltersActionGroup fFiltersActionGroup;
    private HistoryDropDownAction fHistoryDropDownAction;
    private RefreshElementAction fRefreshSingleElementAction;
    private RefreshViewAction fRefreshViewAction;
    private OpenLocationAction fOpenLocationAction;
    private LocationCopyAction fLocationCopyAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private CopyCallHierarchyAction fCopyAction;
    private CancelSearchAction fCancelSearchAction;
    private ExpandWithConstructorsAction fExpandWithConstructorsAction;
    private RemoveFromViewAction fRemoveFromViewAction;
    private ShowSearchInDialogAction fShowSearchInDialogAction;
    private CompositeActionGroup fActionGroups;
    private CallHierarchyViewer fCallHierarchyViewer;
    private boolean fShowCallDetails;
    protected Composite fParent;
    private IPartListener2 fPartListener;
    private boolean fIsPinned = false;
    private PinCallHierarchyViewAction fPinViewAction;

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void setHistoryEntries(IMember[][] entries) {
        this.getMethodHistory().clear();
        int i = 0;
        while (i < entries.length) {
            this.getMethodHistory().add(entries[i]);
            ++i;
        }
        this.updateHistoryEntries();
    }

    public IMember[][] getHistoryEntries() {
        if (this.getMethodHistory().size() > 0) {
            this.updateHistoryEntries();
        }
        return (IMember[][])this.getMethodHistory().toArray((T[])new IMember[this.getMethodHistory().size()][]);
    }

    public void setInputElements(IMember[] members) {
        Object[] oldMembers = this.fInputElements;
        this.fInputElements = members;
        if (members == null || members.length == 0) {
            this.showPage(0);
            return;
        }
        if (!Arrays.equals(members, oldMembers)) {
            this.addHistoryEntry(members);
        }
        this.refresh();
    }

    public IMember[] getInputElements() {
        return this.fInputElements;
    }

    public MethodWrapper[] getCurrentMethodWrappers() {
        if (this.fCurrentCallMode == 0) {
            return this.fCallerRoots;
        }
        return this.fCalleeRoots;
    }

    void setOrientation(int orientation) {
        if (this.fCurrentOrientation != orientation) {
            if (this.fLocationViewer != null && !this.fLocationViewer.getControl().isDisposed() && this.fHierarchyLocationSplitter != null && !this.fHierarchyLocationSplitter.isDisposed()) {
                if (orientation == 2) {
                    this.setShowCallDetails(false);
                } else {
                    if (this.fCurrentOrientation == 2) {
                        this.setShowCallDetails(true);
                    }
                    boolean horizontal = orientation == 1;
                    this.fHierarchyLocationSplitter.setOrientation(horizontal ? 256 : 512);
                }
                this.fHierarchyLocationSplitter.layout();
            }
            this.updateCheckedState();
            this.fCurrentOrientation = orientation;
            this.restoreSplitterRatio();
        }
    }

    private void updateCheckedState() {
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
    }

    void setCallMode(int mode) {
        if (this.fCurrentCallMode != mode) {
            int i = 0;
            while (i < this.fToggleCallModeActions.length) {
                this.fToggleCallModeActions[i].setChecked(mode == this.fToggleCallModeActions[i].getMode());
                ++i;
            }
            this.fCurrentCallMode = mode;
            this.fDialogSettings.put(DIALOGSTORE_CALL_MODE, mode);
            this.updateView();
        }
    }

    int getCallMode() {
        return this.fCurrentCallMode;
    }

    void setFieldMode(int mode) {
        if (this.fCurrentFieldMode != mode) {
            int i = 0;
            while (i < this.fToggleFieldModeActions.length) {
                this.fToggleFieldModeActions[i].setChecked(mode == this.fToggleFieldModeActions[i].getMode());
                ++i;
            }
            this.fCurrentFieldMode = mode;
            this.fDialogSettings.put(DIALOGSTORE_FIELD_MODE, mode);
            this.updateView();
        }
    }

    public IJavaSearchScope getSearchScope(int includeMask) {
        return this.fSearchScopeActions.getSearchScope(includeMask);
    }

    public void setShowCallDetails(boolean show) {
        this.fShowCallDetails = show;
        this.showOrHideCallDetailsView();
    }

    private void initDragAndDrop() {
        this.addDragAdapters((StructuredViewer)this.fCallHierarchyViewer);
        this.addDropAdapters((StructuredViewer)this.fCallHierarchyViewer);
        this.addDropAdapters((StructuredViewer)this.fLocationViewer);
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new CallHierarchyTransferDropAdapter(this, (StructuredViewer)this.fCallHierarchyViewer));
    }

    private void addDropAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), PluginTransfer.getInstance()};
        int ops = 23;
        DelegatingDropAdapter delegatingDropAdapter = new DelegatingDropAdapter();
        delegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)new CallHierarchyTransferDropAdapter(this, viewer));
        delegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)new PluginTransferDropAdapter(viewer));
        viewer.addDropSupport(ops, transfers, (DropTargetListener)delegatingDropAdapter);
    }

    private void addDragAdapters(StructuredViewer viewer) {
        int ops = 5;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        DelegatingDragAdapter dragAdapter = new DelegatingDragAdapter(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CallHierarchyViewPart.this.fSelectionProviderMediator.getSelection();
                if (selection.isEmpty()) {
                    event.doit = false;
                    return;
                }
                super.dragStart(event);
            }
        };
        dragAdapter.addDragSourceListener((TransferDragSourceListener)new SelectionTransferDragAdapter((ISelectionProvider)this.fSelectionProviderMediator));
        dragAdapter.addDragSourceListener((TransferDragSourceListener)new EditorInputTransferDragAdapter((ISelectionProvider)this.fSelectionProviderMediator));
        dragAdapter.addDragSourceListener((TransferDragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)this.fSelectionProviderMediator));
        dragAdapter.addDragSourceListener((TransferDragSourceListener)new FileTransferDragAdapter((ISelectionProvider)this.fSelectionProviderMediator));
        viewer.addDragSupport(ops, transfers, (DragSourceListener)dragAdapter);
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fPagebook = new PageBook(parent, 0);
        this.createHierarchyLocationSplitter((Composite)this.fPagebook);
        this.createCallHierarchyViewer((Composite)this.fHierarchyLocationSplitter);
        this.createLocationViewer((Composite)this.fHierarchyLocationSplitter);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(CallHierarchyMessages.CallHierarchyViewPart_empty);
        this.showPage(0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPagebook, "org.eclipse.jdt.ui.call_hierarchy_view_context");
        this.fSelectionProviderMediator = new CallHierarchySelectionProvider(new StructuredViewer[]{this.fCallHierarchyViewer, this.fLocationViewer});
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fSelectionProviderMediator.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProviderMediator);
        this.fCallHierarchyViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                CallHierarchyViewPart.this.fillCallHierarchyViewerContextMenu(menu);
            }
        }, this.getSite(), (ISelectionProvider)this.fSelectionProviderMediator);
        this.fClipboard = new Clipboard(parent.getDisplay());
        this.makeActions();
        this.fillViewMenu();
        this.fillActionBars();
        this.initDragAndDrop();
        this.initOrientation();
        this.initCallMode();
        this.initFieldMode();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.restoreSplitterRatio();
        this.addPartListener();
    }

    private void restoreSplitterRatio() {
        String ratio = this.fDialogSettings.get(DIALOGSTORE_RATIO + this.fCurrentOrientation);
        if (ratio == null) {
            return;
        }
        int intRatio = Integer.parseInt(ratio);
        this.fHierarchyLocationSplitter.setWeights(new int[]{intRatio, 1000 - intRatio});
    }

    private void saveSplitterRatio() {
        if (this.fHierarchyLocationSplitter != null && !this.fHierarchyLocationSplitter.isDisposed()) {
            int[] weigths = this.fHierarchyLocationSplitter.getWeights();
            int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
            String key = DIALOGSTORE_RATIO + this.fCurrentOrientation;
            this.fDialogSettings.put(key, ratio);
        }
    }

    private boolean isThisView(IWorkbenchPartReference partRef) {
        if (!ID_CALL_HIERARCHY.equals(partRef.getId())) {
            return false;
        }
        String partRefSecondaryId = ((IViewReference)partRef).getSecondaryId();
        String thisSecondaryId = this.getViewSite().getSecondaryId();
        return thisSecondaryId == null && partRefSecondaryId == null || thisSecondaryId != null && thisSecondaryId.equals(partRefSecondaryId);
    }

    private void addPartListener() {
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (CallHierarchyViewPart.this.isThisView(partRef)) {
                    CallHierarchyUI.getDefault().callHierarchyViewActivated(CallHierarchyViewPart.this);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (CallHierarchyViewPart.this.isThisView(partRef)) {
                    CallHierarchyUI.getDefault().callHierarchyViewClosed(CallHierarchyViewPart.this);
                    CallHierarchyViewPart.this.saveViewSettings();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (CallHierarchyViewPart.this.isThisView(partRef)) {
                    CallHierarchyViewPart.this.saveViewSettings();
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.fPartListener);
    }

    protected void saveViewSettings() {
        this.saveSplitterRatio();
        this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, this.fOrientation);
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                CallHierarchyViewPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        this.saveSplitterRatio();
        this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, this.fOrientation);
        if (this.fOrientation != 3) {
            this.setOrientation(this.fOrientation);
        } else {
            if (this.fOrientation == 2) {
                return;
            }
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void showPage(int page) {
        Label control;
        boolean isEmpty = page == 0;
        Object object = control = isEmpty ? this.fNoHierarchyShownLabel : this.fHierarchyLocationSplitter;
        if (isEmpty) {
            this.setContentDescription("");
            this.setTitleToolTip(this.getPartName());
            this.getViewSite().getActionBars().getStatusLineManager().setMessage("");
            this.getViewer().clearViewer();
        }
        this.fPagebook.showPage((Control)control);
        if (this.fRefreshViewAction != null) {
            this.fRefreshViewAction.setEnabled(!isEmpty);
        }
        if (this.fRefreshSingleElementAction != null) {
            this.fRefreshSingleElementAction.setEnabled(!isEmpty);
        }
    }

    private void restoreState(IMemento memento) {
        this.fSearchScopeActions.restoreState(memento);
    }

    private void initCallMode() {
        int mode;
        try {
            mode = this.fDialogSettings.getInt(DIALOGSTORE_CALL_MODE);
            if (mode < 0 || mode > 1) {
                mode = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            mode = 0;
        }
        this.fCurrentCallMode = -1;
        this.setCallMode(mode);
    }

    private void initFieldMode() {
        int mode;
        try {
            mode = this.fDialogSettings.getInt(DIALOGSTORE_FIELD_MODE);
            switch (mode) {
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    mode = 2;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            mode = 2;
        }
        this.fCurrentFieldMode = -1;
        this.setFieldMode(mode);
    }

    private void initOrientation() {
        try {
            this.fOrientation = this.fDialogSettings.getInt(DIALOGSTORE_VIEWORIENTATION);
            if (this.fOrientation < 0 || this.fOrientation > 3) {
                this.fOrientation = 3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fOrientation = 3;
        }
        this.fCurrentOrientation = -1;
        this.setOrientation(this.fOrientation);
    }

    private void fillViewMenu() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IContributionItem)new Separator());
        int i = 0;
        while (i < this.fToggleCallModeActions.length) {
            viewMenu.add((IAction)this.fToggleCallModeActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(CallHierarchyMessages.CallHierarchyViewPart_layout_menu);
        int i2 = 0;
        while (i2 < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i2]);
            ++i2;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("group.search"));
        MenuManager fieldSubMenu = new MenuManager(CallHierarchyMessages.CallHierarchyViewPart_field_menu);
        int i3 = 0;
        while (i3 < this.fToggleFieldModeActions.length) {
            fieldSubMenu.add((IAction)this.fToggleFieldModeActions[i3]);
            ++i3;
        }
        viewMenu.add((IContributionItem)fieldSubMenu);
        viewMenu.add((IAction)this.fShowSearchInDialogAction);
    }

    public void dispose() {
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        if (this.fPartListener != null) {
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fPartListener = null;
        }
        super.dispose();
    }

    public void gotoHistoryEntry(IMember[] entry) {
        Iterator<IMember[]> iter = this.getMethodHistory().iterator();
        while (iter.hasNext()) {
            if (!Arrays.equals(entry, iter.next())) continue;
            this.setInputElements(entry);
            return;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void refresh() {
        this.setCalleeRoots(null);
        this.setCallerRoots(null);
        this.updateView();
    }

    public void saveState(IMemento memento) {
        if (this.fPagebook == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        this.fSearchScopeActions.saveState(memento);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelectionProvider() == this.fCallHierarchyViewer) {
            this.methodSelectionChanged(e.getSelection());
        }
    }

    private void methodSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof MethodWrapper) {
                MethodWrapper methodWrapper = (MethodWrapper)((Object)selectedElement);
                this.revealElementInEditor((Object)methodWrapper, (Viewer)this.fCallHierarchyViewer);
                this.updateLocationsView(methodWrapper);
            } else {
                this.updateLocationsView(null);
            }
        } else {
            this.updateLocationsView(null);
        }
    }

    private void revealElementInEditor(Object elem, Viewer originViewer) {
        IEditorPart editorPart;
        if (this.getSite().getPage().getActivePart() != this) {
            return;
        }
        if (this.fSelectionProviderMediator.getViewerInFocus() != originViewer) {
            return;
        }
        if (elem instanceof MethodWrapper) {
            CallLocation callLocation = CallHierarchy.getCallLocation(elem);
            if (callLocation != null) {
                IEditorPart editorPart2 = CallHierarchyUI.isOpenInEditor(callLocation);
                if (editorPart2 != null) {
                    this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart2);
                    if (editorPart2 instanceof ITextEditor) {
                        ITextEditor editor = (ITextEditor)editorPart2;
                        editor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
                    }
                }
            } else {
                IEditorPart editorPart3 = CallHierarchyUI.isOpenInEditor(elem);
                this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart3);
                EditorUtility.revealInEditor(editorPart3, (IJavaElement)((MethodWrapper)((Object)elem)).getMember());
            }
        } else if (elem instanceof IJavaElement && (editorPart = EditorUtility.isOpenInEditor(elem)) != null) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart);
            EditorUtility.revealInEditor(editorPart, (IJavaElement)elem);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IShowInSource.class) {
            return (T)this.getShowInSource();
        }
        if (adapter == IContextProvider.class) {
            return (T)JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.jdt.ui.call_hierarchy_view_context");
        }
        if (adapter == IShowInTargetList.class) {
            return (T)new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return (T)super.getAdapter(adapter);
    }

    private IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, CallHierarchyViewPart.this.fSelectionProviderMediator.getSelection());
            }
        };
    }

    protected ISelection getSelection() {
        StructuredViewer viewerInFocus = this.fSelectionProviderMediator.getViewerInFocus();
        if (viewerInFocus != null) {
            return viewerInFocus.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    protected void fillLocationViewerContextMenu(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        menu.appendToGroup("group.show", (IAction)this.fOpenLocationAction);
        menu.appendToGroup("group.show", (IAction)this.fRefreshSingleElementAction);
        menu.appendToGroup("group.reorganize", (IAction)this.fLocationCopyAction);
    }

    private IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    private void setCalleeRoots(MethodWrapper[] calleeRoots) {
        this.fCalleeRoots = calleeRoots;
    }

    private MethodWrapper[] getCalleeRoots() {
        if (this.fCalleeRoots == null) {
            this.fCalleeRoots = CallHierarchy.getDefault().getCalleeRoots(this.fInputElements);
        }
        return this.fCalleeRoots;
    }

    private void setCallerRoots(MethodWrapper[] callerRoots) {
        this.fCallerRoots = callerRoots;
    }

    private MethodWrapper[] getCallerRoots() {
        if (this.fCallerRoots != null && this.fCallerRoots.length > 0 && this.fCallerRoots[0].getFieldSearchMode() != this.fCurrentFieldMode) {
            this.fCallerRoots = null;
        }
        if (this.fCallerRoots == null) {
            this.fCallerRoots = CallHierarchy.getDefault().getCallerRoots(this.fInputElements);
            int i = 0;
            while (i < this.fCallerRoots.length) {
                this.fCallerRoots[i].setFieldSearchMode(this.fCurrentFieldMode);
                ++i;
            }
        }
        return this.fCallerRoots;
    }

    private void addHistoryEntry(IMember[] entry) {
        this.updateHistoryEntries(entry, entry);
    }

    void updateInputHistoryAndDescription(IMember[] currentInput, IMember[] entry) {
        this.updateHistoryEntries(currentInput, entry);
        this.fInputElements = entry;
        this.setContentDescription(this.getIncludeMask());
    }

    private void updateHistoryEntries(IMember[] currentInput, IMember[] entry) {
        Iterator<IMember[]> iter = this.getMethodHistory().iterator();
        while (iter.hasNext()) {
            if (!Arrays.equals(currentInput, iter.next())) continue;
            iter.remove();
        }
        this.getMethodHistory().add(0, entry);
        this.fHistoryDropDownAction.setEnabled(true);
    }

    private void createLocationViewer(Composite parent) {
        this.fLocationViewer = new LocationViewer(parent);
        this.fLocationViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                CallHierarchyViewPart.this.fillLocationViewerContextMenu(menu);
            }
        }, ID_CALL_HIERARCHY, this.getSite());
    }

    private void createHierarchyLocationSplitter(Composite parent) {
        this.fHierarchyLocationSplitter = new SashForm(parent, 0);
    }

    private void createCallHierarchyViewer(Composite parent) {
        this.fCallHierarchyViewer = new CallHierarchyViewer(parent, this);
        this.fCallHierarchyViewer.addSelectionChangedListener(this);
    }

    protected void fillCallHierarchyViewerContextMenu(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        menu.appendToGroup("group.show", (IAction)this.fRefreshSingleElementAction);
        menu.appendToGroup("group.show", (IContributionItem)new Separator(GROUP_FOCUS));
        if (this.fFocusOnSelectionAction.canActionBeAdded()) {
            menu.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnSelectionAction);
        }
        if (this.fExpandWithConstructorsAction.canActionBeAdded()) {
            menu.appendToGroup(GROUP_FOCUS, (IAction)this.fExpandWithConstructorsAction);
        }
        if (this.fRemoveFromViewAction.canActionBeAdded()) {
            menu.appendToGroup(GROUP_FOCUS, (IAction)this.fRemoveFromViewAction);
        }
        this.fActionGroups.setContext(new ActionContext(this.getSelection()));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
        if (this.fCopyAction.canActionBeAdded()) {
            menu.appendToGroup("group.edit", (IAction)this.fCopyAction);
        }
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshSingleElementAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fRemoveFromViewAction);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fActionGroups.fillActionBars(actionBars);
        toolBar.add((IAction)this.fRefreshViewAction);
        toolBar.add((IAction)this.fCancelSearchAction);
        int i = 0;
        while (i < this.fToggleCallModeActions.length) {
            toolBar.add((IAction)this.fToggleCallModeActions[i]);
            ++i;
        }
        toolBar.add((IAction)this.fHistoryDropDownAction);
        toolBar.add((IAction)this.fPinViewAction);
    }

    private void makeActions() {
        this.fRefreshViewAction = new RefreshViewAction(this);
        this.fRefreshSingleElementAction = new RefreshElementAction(this.fCallHierarchyViewer);
        new CallHierarchyOpenEditorHelper((StructuredViewer)this.fLocationViewer);
        new CallHierarchyOpenEditorHelper((StructuredViewer)this.fCallHierarchyViewer);
        this.fOpenLocationAction = new OpenLocationAction(this, (IWorkbenchSite)this.getSite());
        this.fLocationCopyAction = this.fLocationViewer.initCopyAction(this.getViewSite(), this.fClipboard);
        this.fFocusOnSelectionAction = new FocusOnSelectionAction(this);
        this.fCopyAction = new CopyCallHierarchyAction(this, this.fClipboard, this.fCallHierarchyViewer);
        this.fSearchScopeActions = new SearchScopeActionGroup(this, this.fDialogSettings);
        this.fShowSearchInDialogAction = new ShowSearchInDialogAction(this, this.fCallHierarchyViewer);
        this.fFiltersActionGroup = new CallHierarchyFiltersActionGroup((IViewPart)this, (StructuredViewer)this.fCallHierarchyViewer);
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(false);
        this.fCancelSearchAction = new CancelSearchAction(this);
        this.setCancelEnabled(false);
        this.fExpandWithConstructorsAction = new ExpandWithConstructorsAction(this, this.fCallHierarchyViewer);
        this.fRemoveFromViewAction = new RemoveFromViewAction(this, this.fCallHierarchyViewer);
        this.fPinViewAction = new PinCallHierarchyViewAction(this);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 3), new ToggleOrientationAction(this, 2)};
        this.fRemoveFromViewAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fToggleCallModeActions = new ToggleCallModeAction[]{new ToggleCallModeAction(this, 0), new ToggleCallModeAction(this, 1)};
        this.fToggleFieldModeActions = new SelectFieldModeAction[]{new SelectFieldModeAction(this, 2), new SelectFieldModeAction(this, 4), new SelectFieldModeAction(this, 5)};
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenEditorActionGroup((IViewPart)this), new OpenViewActionGroup((IViewPart)this), new CCPActionGroup((IViewPart)this, true), new GenerateActionGroup((IViewPart)this), new RefactorActionGroup((IViewPart)this), new JavaSearchActionGroup((IViewPart)this), this.fSearchScopeActions, this.fFiltersActionGroup});
    }

    private void showOrHideCallDetailsView() {
        if (this.fShowCallDetails) {
            this.fHierarchyLocationSplitter.setMaximizedControl(null);
        } else {
            this.fHierarchyLocationSplitter.setMaximizedControl(this.fCallHierarchyViewer.getControl());
        }
    }

    private void updateLocationsView(MethodWrapper methodWrapper) {
        if (methodWrapper != null && methodWrapper.getMethodCall().hasCallLocations()) {
            this.fLocationViewer.setInput(methodWrapper.getMethodCall().getCallLocations());
        } else {
            this.fLocationViewer.clearViewer();
        }
    }

    private void updateHistoryEntries() {
        int i = this.getMethodHistory().size() - 1;
        while (i >= 0) {
            IMember[] members = this.getMethodHistory().get(i);
            int j = 0;
            while (j < members.length) {
                IMember member = members[j];
                if (!member.exists()) {
                    this.getMethodHistory().remove(i);
                    break;
                }
                ++j;
            }
            --i;
        }
        this.fHistoryDropDownAction.setEnabled(!this.getMethodHistory().isEmpty());
    }

    private void updateView() {
        if (this.fInputElements != null) {
            this.showPage(1);
            int includeMask = this.getIncludeMask();
            CallHierarchy.getDefault().setSearchScope(this.getSearchScope(includeMask));
            this.fCallHierarchyViewer.setInput(null);
            if (this.fCurrentCallMode == 0) {
                this.fCallHierarchyViewer.setComparator(new ViewerComparator(){

                    public int category(Object element) {
                        return element instanceof RealCallers ? 1 : 0;
                    }
                });
                this.fCallHierarchyViewer.setMethodWrappers(this.getCallerRoots());
            } else {
                this.fCallHierarchyViewer.setComparator(null);
                this.fCallHierarchyViewer.setMethodWrappers(this.getCalleeRoots());
            }
            this.setContentDescription(includeMask);
        }
    }

    private void setContentDescription(int includeMask) {
        this.setContentDescription(this.computeContentDescription(includeMask));
    }

    private int getIncludeMask() {
        return this.fShowSearchInDialogAction.getSearchInDialog().getIncludeMask();
    }

    private String computeContentDescription(int includeMask) {
        String scopeDescription = this.fSearchScopeActions.getFullDescription(includeMask);
        if (this.fInputElements.length == 1) {
            IMember element = this.fInputElements[0];
            String elementName = JavaElementLabels.getElementLabel((IJavaElement)element, JavaElementLabels.ALL_DEFAULT);
            Object[] args = new String[]{elementName, scopeDescription};
            if (this.fCurrentCallMode == 0) {
                switch (element.getElementType()) {
                    case 7: {
                        return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToConstructors, args);
                    }
                    case 8: {
                        switch (this.fCurrentFieldMode) {
                            case 4: {
                                return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToFieldRead, args);
                            }
                            case 5: {
                                return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToFieldWrite, args);
                            }
                        }
                        return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToField, args);
                    }
                }
                return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToMethod, args);
            }
            switch (element.getElementType()) {
                case 7: {
                    return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsFromConstructors, args);
                }
            }
            return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsFromMethod, args);
        }
        if (this.fCurrentCallMode == 0) {
            switch (this.fInputElements.length) {
                case 0: {
                    Assert.isTrue((boolean)false);
                    return null;
                }
                case 2: {
                    return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToMembers_2, new String[]{CallHierarchyViewPart.getShortLabel(this.fInputElements[0]), CallHierarchyViewPart.getShortLabel(this.fInputElements[1]), scopeDescription});
                }
            }
            return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToMembers_more, new String[]{CallHierarchyViewPart.getShortLabel(this.fInputElements[0]), CallHierarchyViewPart.getShortLabel(this.fInputElements[1]), scopeDescription});
        }
        switch (this.fInputElements.length) {
            case 0: {
                Assert.isTrue((boolean)false);
                return null;
            }
            case 2: {
                return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsFromMembers_2, new String[]{CallHierarchyViewPart.getShortLabel(this.fInputElements[0]), CallHierarchyViewPart.getShortLabel(this.fInputElements[1]), scopeDescription});
            }
        }
        return Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsFromMembers_more, new String[]{CallHierarchyViewPart.getShortLabel(this.fInputElements[0]), CallHierarchyViewPart.getShortLabel(this.fInputElements[1]), scopeDescription});
    }

    private static String getShortLabel(IMember member) {
        return JavaElementLabels.getElementLabel((IJavaElement)member, 0L);
    }

    static CallHierarchyViewPart findAndShowCallersView(IWorkbenchPartSite site) {
        IWorkbenchPage workbenchPage = site.getPage();
        CallHierarchyViewPart callersView = null;
        try {
            callersView = (CallHierarchyViewPart)workbenchPage.showView(ID_CALL_HIERARCHY);
        }
        catch (PartInitException e) {
            JavaPlugin.log(e);
        }
        return callersView;
    }

    void cancelJobs() {
        this.fCallHierarchyViewer.cancelJobs();
    }

    void setCancelEnabled(boolean enabled) {
        this.fCancelSearchAction.setEnabled(enabled);
    }

    public CallHierarchyViewer getViewer() {
        return this.fCallHierarchyViewer;
    }

    protected LocationViewer getLocationViewer() {
        return this.fLocationViewer;
    }

    void setPinned(boolean pinned) {
        this.fIsPinned = pinned;
    }

    boolean isPinned() {
        return this.fIsPinned;
    }

    private List<IMember[]> getMethodHistory() {
        return CallHierarchyUI.getDefault().getMethodHistory();
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        if (!busy) {
            this.getProgressService().warnOfContentChange();
        }
    }

    private IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchSiteProgressService service = null;
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    void addInputElements(IMember[] newElements) {
        List<IMember> inputElements = Arrays.asList(this.fInputElements);
        ArrayList<IMember> treeElements = new ArrayList<IMember>();
        TreeItem[] treeItems = this.fCallHierarchyViewer.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            Object data = treeItems[i].getData();
            if (data instanceof MethodWrapper) {
                treeElements.add(((MethodWrapper)((Object)data)).getMember());
            }
            ++i;
        }
        ArrayList<IMember> newInput = new ArrayList<IMember>();
        newInput.addAll(inputElements);
        ArrayList<IMember> addedElements = new ArrayList<IMember>();
        int i2 = 0;
        while (i2 < newElements.length) {
            IMember newElement = newElements[i2];
            if (!inputElements.contains(newElement)) {
                newInput.add(newElement);
            }
            if (!treeElements.contains(newElement)) {
                addedElements.add(newElement);
            }
            ++i2;
        }
        if (treeElements.size() == 0) {
            this.updateInputHistoryAndDescription(this.fInputElements, newElements);
        } else if (newInput.size() > this.fInputElements.length) {
            this.updateInputHistoryAndDescription(this.fInputElements, newInput.toArray(new IMember[newInput.size()]));
        }
        if (addedElements.size() > 0) {
            this.updateViewWithAddedElements(addedElements.toArray(new IMember[addedElements.size()]));
        }
    }

    private void updateViewWithAddedElements(IMember[] newElements) {
        this.setCalleeRoots(null);
        this.setCallerRoots(null);
        MethodWrapper[] roots = this.getCallMode() == 0 ? CallHierarchy.getDefault().getCallerRoots(newElements) : CallHierarchy.getDefault().getCalleeRoots(newElements);
        CallHierarchyViewer hierarchyViewer = this.getViewer();
        TreeRoot treeRoot = hierarchyViewer.getTreeRoot(roots, true);
        hierarchyViewer.add(treeRoot, (Object[])roots);
        int i = 0;
        while (i < roots.length) {
            hierarchyViewer.setExpandedState((Object)roots[i], true);
            ++i;
        }
        hierarchyViewer.setSelection((ISelection)new StructuredSelection((Object[])roots), true);
    }

    private final class CallHierarchyOpenEditorHelper
    extends OpenAndLinkWithEditorHelper {
        public CallHierarchyOpenEditorHelper(StructuredViewer viewer) {
            super(viewer);
        }

        protected void activate(ISelection selection) {
            Object selectedElement = SelectionUtil.getSingleElement(selection);
            if (selectedElement != null) {
                CallHierarchyUI.openInEditor(selectedElement, CallHierarchyViewPart.this.getSite().getShell(), true);
            }
        }

        protected void linkToEditor(ISelection selection) {
        }

        protected void open(ISelection selection, boolean activate) {
            if (selection instanceof IStructuredSelection) {
                Iterator iter = ((IStructuredSelection)selection).iterator();
                while (iter.hasNext()) {
                    boolean noError = CallHierarchyUI.openInEditor(iter.next(), CallHierarchyViewPart.this.getSite().getShell(), OpenStrategy.activateOnOpen());
                    if (noError) continue;
                    return;
                }
            }
        }
    }

    private class CallHierarchySelectionProvider
    extends SelectionProviderMediator {
        public CallHierarchySelectionProvider(StructuredViewer[] viewers) {
            super(viewers, null);
        }

        @Override
        public ISelection getSelection() {
            ISelection selection = super.getSelection();
            if (!selection.isEmpty()) {
                return CallHierarchyUI.convertSelection(selection);
            }
            return selection;
        }
    }
}

