/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal;

import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class ActivityExplorerEditorInputFactory
implements IElementFactory {
    public static final String ID = ActivityExplorerEditorInputFactory.class.getName();
    private static final String ACTIVITY_EXPLORER_FILE = "activityExplorerFile";

    public IAdaptable createElement(IMemento memento_p) {
        String path = memento_p.getString(ACTIVITY_EXPLORER_FILE);
        if (path == null || path.isEmpty()) {
            Status status = new Status(4, ActivityExplorerActivator.ID, "Activity Explorer cannot find the path of file to restaure");
            ActivityExplorerLoggerService.getInstance().log((IStatus)status);
            return null;
        }
        IResource file = this.getPlatformResource((IPath)new Path(path));
        if (file != null && file instanceof IFile) {
            ActivityExplorerEditorInput input = new ActivityExplorerEditorInput((IFile)file);
            return input;
        }
        Status status = new Status(4, ActivityExplorerActivator.ID, "Cannot load state of Activity Explorer for " + path);
        ActivityExplorerLoggerService.getInstance().log((IStatus)status);
        return null;
    }

    private IResource getPlatformResource(IPath path) {
        if (path == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().findMember(path);
    }
}

