/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.activities;

import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.FormHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.predicates.IPredicate;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IOrdered;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IVisibility;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ExplorerActivity
implements IVisibility,
IOrdered {
    private String id;
    private String name;
    private IHyperlinkListener listener;
    private int index;
    private Image image;
    private String description;
    private IPredicate predicate;
    ImageHyperlink widget;

    public ExplorerActivity(IConfigurationElement element_p) {
        this.name = ActivityExplorerExtensionManager.getName(element_p);
        this.description = ActivityExplorerExtensionManager.getDescription(element_p);
        this.index = Integer.parseInt(ActivityExplorerExtensionManager.getIndex(element_p));
        this.listener = ActivityExplorerExtensionManager.getActivityAdapter(element_p);
        this.image = ActivityExplorerExtensionManager.getImage(element_p);
        this.id = ActivityExplorerExtensionManager.getId(element_p);
        this.predicate = ActivityExplorerExtensionManager.getPredicate(element_p);
    }

    public ExplorerActivity(String id, String name, IHyperlinkListener listener, IPredicate predicate, int index) {
        this.id = id;
        this.name = name;
        this.listener = listener;
        this.predicate = predicate;
        this.setPosition(index);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IHyperlinkListener getListener() {
        return this.listener;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isVisible() {
        boolean result = ActivityExplorerActivator.getDefault().getPreferenceStore().getBoolean(this.getId());
        if (this.predicate != null) {
            result &= this.predicate.isOk();
        }
        return result;
    }

    public IPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public int getPosition() {
        return this.index;
    }

    @Override
    public void setPosition(int index_p) {
        this.index = index_p;
    }

    public Control init(Composite activityContainer_p, FormToolkit toolkit_p) {
        this.widget = FormHelper.createLinkWithDescription(toolkit_p, activityContainer_p, this.image, this.name, null, this.description, this.listener);
        return this.widget;
    }

    public ImageHyperlink getWidget() {
        return this.widget;
    }

    public void dispose() {
        if (this.widget != null && !this.widget.isDisposed()) {
            this.widget.dispose();
        }
    }

    @Override
    public int compareTo(IOrdered arg0) {
        return new Integer(this.getPosition()).compareTo(new Integer(arg0.getPosition()));
    }
}

