/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design.arinc653;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.time4sys.builder.design.Annotations;
import org.polarsys.time4sys.builder.design.ProcessorBuilder;
import org.polarsys.time4sys.builder.design.TableDrivenSchedPolicyBuilder;
import org.polarsys.time4sys.builder.design.arinc653.Arinc653DesignBuilder;
import org.polarsys.time4sys.builder.design.arinc653.Arinc653MIFBuilder;
import org.polarsys.time4sys.marte.hrm.HardwareProcessor;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SoftwareConcurrentResource;

public class Arinc653PlatformBuilder {
    private static final String PLATFORM_ATTR = "platform";
    private ProcessorBuilder processorBuilder;
    private TableDrivenSchedPolicyBuilder schedBuilder;
    private Arinc653DesignBuilder designBuilder;
    private Arinc653MIFBuilder[] mifsArray;
    private Duration mifDuration;

    public static Arinc653PlatformBuilder as(HardwareProcessor value) {
        Arinc653DesignBuilder db = Arinc653DesignBuilder.containing((EObject)value);
        return new Arinc653PlatformBuilder(db, value);
    }

    public static boolean isInstance(HardwareProcessor proc) {
        String platAttr = Annotations.getAttr((EModelElement)proc, "http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653", PLATFORM_ATTR);
        if (platAttr != null) {
            try {
                return Boolean.parseBoolean(platAttr);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public Arinc653PlatformBuilder(Arinc653DesignBuilder designBuilder) {
        this(designBuilder, designBuilder.hasAProcessor());
    }

    public Arinc653PlatformBuilder(Arinc653DesignBuilder builder, ProcessorBuilder procBuilder) {
        this.designBuilder = builder;
        this.processorBuilder = procBuilder;
        EAnnotation annot = this.processorBuilder.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653");
        if (!Boolean.TRUE.toString().equals(annot.getDetails().get((Object)PLATFORM_ATTR))) {
            annot.getDetails().put((Object)PLATFORM_ATTR, (Object)Boolean.TRUE.toString());
        }
        this.schedBuilder = this.processorBuilder.underTableDrivenSchedPolicy();
    }

    public TableDrivenSchedPolicyBuilder getSchedBuilder() {
        return this.schedBuilder;
    }

    public Arinc653PlatformBuilder(Arinc653DesignBuilder db, HardwareProcessor proc) {
        this(db, new ProcessorBuilder(db, proc));
    }

    public Arinc653PlatformBuilder called(String name) {
        this.processorBuilder.called(name);
        this.schedBuilder.called(String.valueOf(name) + " Main Scheduler");
        return this;
    }

    public Arinc653PlatformBuilder thatRuns(Arinc653MIFBuilder ... mifs) {
        assert (mifs != null);
        assert (this.processorBuilder != null);
        this.mifsArray = mifs;
        Arinc653MIFBuilder[] arinc653MIFBuilderArray = mifs;
        int n = mifs.length;
        int n2 = 0;
        while (n2 < n) {
            Arinc653MIFBuilder aMIF = arinc653MIFBuilderArray[n2];
            this.addPartition(aMIF);
            ++n2;
        }
        if (this.mifDuration != null) {
            this.schedBuilder.withMIFDuration(this.mifDuration);
        }
        return this;
    }

    public Arinc653PlatformBuilder runs(Arinc653MIFBuilder ... mifs) {
        return this.thatRuns(mifs);
    }

    public Arinc653PlatformBuilder withMIFDuration(String value) {
        this.mifDuration = NfpFactory.eINSTANCE.createDurationFromString(value);
        this.schedBuilder.withMIFDuration(this.mifDuration);
        return this;
    }

    public Collection<Arinc653MIFBuilder> getMIF() {
        return Collections.emptyList();
    }

    public long countMIF() {
        return this.processorBuilder.countTasks();
    }

    public Arinc653MIFBuilder getMIF(int i) {
        return this.mifsArray[i];
    }

    public Duration getMAFDuration() {
        return this.schedBuilder.getMAFDuration();
    }

    public Duration getMIFDuration() {
        return this.schedBuilder.getMIFDuration();
    }

    public HardwareProcessor build() {
        HardwareProcessor result = this.processorBuilder.build();
        if (this.mifsArray != null) {
            Arinc653MIFBuilder[] arinc653MIFBuilderArray = this.mifsArray;
            int n = this.mifsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Arinc653MIFBuilder mifB = arinc653MIFBuilderArray[n2];
                mifB.build(this.designBuilder);
                ++n2;
            }
        }
        this.schedBuilder.build();
        return result;
    }

    public Arinc653PlatformBuilder addPartition(Arinc653MIFBuilder aMIF) {
        Duration mif = null;
        try {
            mif = this.schedBuilder.getMIFDuration();
        }
        catch (Exception exception) {}
        this.processorBuilder.addOwnedResource((SoftwareConcurrentResource)aMIF.build(this.designBuilder));
        this.processorBuilder.addSchedulable(aMIF.build(this.designBuilder));
        this.schedBuilder.addEntry(aMIF.getOrCreateTableEntry());
        aMIF.build(this.designBuilder);
        if (mif != null) {
            this.schedBuilder.updateScheduleEntries(mif);
        }
        return this;
    }

    public void setNotAPlatform() {
        Annotations.setAttr((EModelElement)this.processorBuilder.build(), "http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653", PLATFORM_ATTR, Boolean.FALSE.toString());
    }
}

