/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.simulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.time4sys.builder.design.EndToEndFlowConstraintBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.builder.mapping.MappingBuilder;
import org.polarsys.time4sys.builder.simulation.EventBuilder;
import org.polarsys.time4sys.builder.simulation.SimulationBuilder;
import org.polarsys.time4sys.builder.simulation.SliceBuilder;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.Mapping;
import org.polarsys.time4sys.mapping.MappingFactory;
import org.polarsys.time4sys.marte.gqam.BehaviorScenario;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.gqam.WorkloadBehavior;
import org.polarsys.time4sys.marte.grm.ProcessingResource;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.ResourcePackage;
import org.polarsys.time4sys.marte.grm.SchedulableResource;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.nfp.TimeInterval;
import org.polarsys.time4sys.marte.sam.EndToEndFlow;
import org.polarsys.time4sys.model.time4sys.Simulation;
import org.polarsys.time4sys.trace.DurationValueChangeEvent;
import org.polarsys.time4sys.trace.Event;
import org.polarsys.time4sys.trace.SchedulingEvent;
import org.polarsys.time4sys.trace.SchedulingEventKind;
import org.polarsys.time4sys.trace.Slice;
import org.polarsys.time4sys.trace.SliceKind;
import org.polarsys.time4sys.trace.Trace;
import org.polarsys.time4sys.trace.TraceFactory;
import org.polarsys.time4sys.trace.TracePackage;

public class TraceBuilder {
    public static final String SIMUCTX = "simulation";
    protected Map<Object, Slice> slices = new HashMap<Object, Slice>();
    protected final Trace trace;
    protected final Mapping mapping;
    protected final Context ctx;
    protected MappingBuilder mapBuilder;
    protected SimulationBuilder simuBuilder;
    private Slice allEndToEndFlows;

    public static Trace getOrCreateTrace(Simulation simu) {
        if (simu.getTrace() == null) {
            simu.setTrace(TraceFactory.eINSTANCE.createTrace());
        }
        return simu.getTrace();
    }

    public static Trace getOrSetTrace(Simulation simu, Trace tr) {
        if (tr == null) {
            throw new IllegalArgumentException("trace must not be null");
        }
        if (simu.getTrace() != null && simu.getTrace() != tr) {
            throw new IllegalArgumentException("trace of simulation trace must not be already set");
        }
        simu.setTrace(tr);
        return simu.getTrace();
    }

    public static Mapping getOrCreateMapping(Simulation simu) {
        if (simu.getMapping() == null) {
            simu.setMapping(MappingFactory.eINSTANCE.createMapping());
        }
        return simu.getMapping();
    }

    public static Context getOrCreateContext(Simulation simu) {
        Mapping mp = TraceBuilder.getOrCreateMapping(simu);
        for (Context c : mp.getRules()) {
            if (!SIMUCTX.equals(c.getName())) continue;
            return c;
        }
        Context ctx = MappingFactory.eINSTANCE.createContext(SIMUCTX);
        mp.getRules().add((Object)ctx);
        return ctx;
    }

    public TraceBuilder(Trace tr, Mapping map, Context context) {
        this.trace = tr;
        if (tr == null) {
            throw new IllegalArgumentException("argument tr must not be null");
        }
        this.mapping = map;
        if (map == null) {
            throw new IllegalArgumentException("argument map must not be null");
        }
        this.ctx = context;
        if (context == null) {
            throw new IllegalArgumentException("argument context must not be null");
        }
        if (map.getRationale() == null) {
            map.setRationale(this.ctx);
        }
        this.mapBuilder = new MappingBuilder(map);
        this.mapBuilder.tracing(this);
    }

    public TraceBuilder(Simulation simu) {
        this(TraceBuilder.getOrCreateTrace(simu), TraceBuilder.getOrCreateMapping(simu), TraceBuilder.getOrCreateContext(simu));
    }

    public TraceBuilder(Simulation simu, Trace theTrace) {
        this(TraceBuilder.getOrSetTrace(simu, theTrace), TraceBuilder.getOrCreateMapping(simu), TraceBuilder.getOrCreateContext(simu));
    }

    public TraceBuilder(SimulationBuilder simulationBuilder, Trace theTrace) {
        this(simulationBuilder.build(), theTrace);
        this.simuBuilder = simulationBuilder;
    }

    private void map(EObject res, Slice resSlice) {
        this.slices.put(res, resSlice);
        Link l = MappingFactory.eINSTANCE.createLink(this.ctx, "source", res, "slice", (EObject)resSlice);
        this.mapping.getSubLinks().add((Object)l);
    }

    private void attachToParent(Slice resSlice, EObject obj) {
        EObject parent = obj.eContainer();
        if (parent == null) {
            this.trace.getSlices().add((Object)resSlice);
        } else if (parent instanceof ResourcePackage) {
            this.getSliceFor((ResourcePackage)parent).getOwnedSubSlices().add((Object)resSlice);
        } else if (parent instanceof Resource) {
            this.getSliceFor((Resource)parent).getOwnedSubSlices().add((Object)resSlice);
        } else if (parent instanceof WorkloadBehavior) {
            this.getSliceFor((WorkloadBehavior)parent).getOwnedSubSlices().add((Object)resSlice);
        } else {
            this.trace.getSlices().add((Object)resSlice);
        }
    }

    public synchronized Slice getSliceFor(BehaviorScenario scenario) {
        if (scenario == null) {
            return null;
        }
        Slice resSlice = this.slices.get(scenario);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            this.map((EObject)scenario, resSlice);
            resSlice.setName(scenario.getName());
            resSlice.setKindLabel("Package");
            this.attachToParent(resSlice, (EObject)scenario);
        }
        return resSlice;
    }

    public synchronized Slice getSliceFor(Resource res) {
        Slice resSlice = this.slices.get(res);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            resSlice.setName(res.getName());
            this.map((EObject)res, resSlice);
            resSlice.setKind(SliceKind.RESOURCE);
            this.attachToParent(resSlice, (EObject)res);
        }
        return resSlice;
    }

    public synchronized Slice getSliceFor(ResourcePackage res) {
        Slice resSlice = this.slices.get(res);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            String label = res.getName();
            if (label == null || label.trim().isEmpty()) {
                label = "Resource Package";
            }
            resSlice.setName(label);
            this.map((EObject)res, resSlice);
            resSlice.setKindLabel("Package");
            this.trace.getSlices().add((Object)resSlice);
        }
        return resSlice;
    }

    public synchronized Slice getSliceFor(SchedulableResource task) {
        Slice resSlice = this.slices.get(task);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            this.map((EObject)task, resSlice);
            resSlice.setName(task.getName());
            resSlice.setKind(SliceKind.TASK);
            this.attachToParent(resSlice, (EObject)task);
        }
        return resSlice;
    }

    public synchronized Slice getSliceFor(Step step) {
        Slice resSlice = this.slices.get(step);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            this.map((EObject)step, resSlice);
            resSlice.setName(step.getName());
            resSlice.setKind(SliceKind.FUNCTION);
            if (step.getScenario() != null) {
                this.getSliceFor(step.getConcurRes()).getSubSlices().add((Object)resSlice);
                this.getSliceFor(step.getScenario()).getOwnedSubSlices().add((Object)resSlice);
            } else if (step.eContainer() instanceof WorkloadBehavior) {
                this.getSliceFor((WorkloadBehavior)step.eContainer()).getOwnedSubSlices().add((Object)resSlice);
            } else {
                this.getSliceFor(step.getConcurRes()).getOwnedSubSlices().add((Object)resSlice);
            }
        }
        return resSlice;
    }

    public Slice getSliceFor(EndToEndFlow flow) {
        Slice resSlice = this.slices.get(flow);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            this.slices.put(flow, resSlice);
            resSlice.setName("Constraint " + Integer.toString(flow.hashCode()));
            resSlice.setKind(SliceKind.TEMPORAL_CHAIN);
            this.getAllEndToEndFlows().getOwnedSubSlices().add((Object)resSlice);
            this.map((EObject)flow, resSlice);
        }
        return resSlice;
    }

    public synchronized Slice getAllEndToEndFlows() {
        if (this.allEndToEndFlows == null) {
            this.allEndToEndFlows = this.hasASlice().called("end-to-end-flows").ofKindPackage().build();
        }
        return this.allEndToEndFlows;
    }

    public Trace build() {
        return this.trace;
    }

    public TraceBuilder startAt(String value) {
        Duration pit = NfpFactory.eINSTANCE.createDurationFromString(value);
        TimeInterval timeInt = this.getRange();
        timeInt.setMin(pit);
        this.trace.setRange(timeInt);
        return this;
    }

    public TraceBuilder endAt(String value) {
        Duration pit = NfpFactory.eINSTANCE.createDurationFromString(value);
        TimeInterval timeInt = this.getRange();
        timeInt.setMax(pit);
        this.trace.setRange(timeInt);
        return this;
    }

    protected TimeInterval getRange() {
        TimeInterval timeInt = this.trace.eIsSet((EStructuralFeature)TracePackage.eINSTANCE.getTrace_Range()) ? this.trace.getRange() : NfpFactory.eINSTANCE.createTimeInterval();
        return timeInt;
    }

    public EventBuilder logActivationOf(StepBuilder step) {
        SliceBuilder aSlice = this.getSliceFor(step);
        return aSlice.logEvent(SchedulingEventKind.ACTIVATED);
    }

    public SliceBuilder getSliceFor(StepBuilder step) {
        Slice aSlice = TraceFactory.eINSTANCE.createSlice();
        aSlice.setKind(SliceKind.TASK);
        aSlice.setName(step.name());
        this.trace.getSlices().add((Object)aSlice);
        SliceBuilder slice = new SliceBuilder(this, aSlice);
        this.mapBuilder.linking(step, slice);
        return slice;
    }

    public SliceBuilder getSliceFor(EndToEndFlowConstraintBuilder endToEndFlow) {
        Slice aSlice = TraceFactory.eINSTANCE.createSlice();
        aSlice.setKind(SliceKind.TEMPORAL_CHAIN);
        aSlice.setName(endToEndFlow.toString());
        this.trace.getSlices().add((Object)aSlice);
        SliceBuilder slice = new SliceBuilder(this, aSlice);
        this.mapBuilder.linking(endToEndFlow, slice);
        return slice;
    }

    public synchronized Slice getSliceFor(WorkloadBehavior res) {
        Slice resSlice = this.slices.get(res);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            String label = res.getName();
            if (label == null || label.trim().isEmpty()) {
                label = "Workload Behavior";
            }
            resSlice.setName(label);
            this.map((EObject)res, resSlice);
            resSlice.setKindLabel("Package");
            this.trace.getSlices().add((Object)resSlice);
        }
        return resSlice;
    }

    public synchronized SliceBuilder getSliceForInstanceOfEndToEndFlow(Object cst, EndToEndFlow parent) {
        Slice resSlice = this.slices.get(cst);
        if (resSlice == null) {
            resSlice = TraceFactory.eINSTANCE.createSlice();
            this.slices.put(cst, resSlice);
            resSlice.setKind(SliceKind.TEMPORAL_CHAIN);
            this.getSliceFor(parent).getOwnedSubSlices().add((Object)resSlice);
        }
        return new SliceBuilder(this, resSlice);
    }

    public Slice getSliceFor(List<Object> keys, String name, SliceKind kind, Slice parent) {
        if (keys == null) {
            throw new IllegalArgumentException("keys must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        Slice resSlice = null;
        for (Object aKey : keys) {
            resSlice = this.slices.get(aKey);
            if (resSlice == null) continue;
            return resSlice;
        }
        assert (resSlice == null);
        resSlice = TraceFactory.eINSTANCE.createSlice();
        for (Object aKey : keys) {
            this.slices.put(aKey, resSlice);
        }
        resSlice.setName(name);
        resSlice.setKind(kind);
        parent.getOwnedSubSlices().add((Object)resSlice);
        return resSlice;
    }

    public Slice getSliceForTaskOnResource(SchedulableResource task, ProcessingResource resource) {
        Integer key = task.hashCode() + 11 * resource.hashCode();
        String name = String.valueOf(task.getName()) + "_x_" + resource.getName();
        Slice resSlice = this.getSliceFor(Arrays.asList(key), name, SliceKind.OTHER, this.getSliceFor(task));
        resSlice.setKindLabel("Task_x_Resource");
        if (resource != task.eContainer()) {
            this.getSliceFor((Resource)resource).getSubSlices().add((Object)resSlice);
        }
        return resSlice;
    }

    public Slice getSliceForJob(Step step, int activationId, SchedulableResource task, ProcessingResource resource, Object key) {
        String name = String.valueOf(step.getName()) + "_" + Integer.toString(activationId);
        Slice resSlice = this.getSliceFor(Arrays.asList(activationId, key), name, SliceKind.JOB, this.getSliceFor(step));
        if (resource != null) {
            Slice upperSlice = this.getSliceForTaskOnResource(task, resource);
            upperSlice.getSubSlices().add((Object)resSlice);
        }
        return resSlice;
    }

    public Event log(Duration currentTime, Slice parent, SchedulingEventKind kind) {
        SchedulingEvent evt = TraceFactory.eINSTANCE.createSchedulingEvent();
        evt.setTimestamp(currentTime);
        evt.setKind(kind);
        this.trace.getEvents().add((Object)evt);
        parent.getEvents().add((Object)evt);
        return evt;
    }

    public DurationValueChangeEvent logWorkloadDemand(Duration currentTime, Slice parent, ProcessingResource procResource, Duration workload) {
        DurationValueChangeEvent evt = TraceFactory.eINSTANCE.createDurationValueChangeEvent();
        evt.setTimestamp(currentTime);
        evt.setTrace(this.trace);
        evt.setObject((EObject)procResource);
        evt.setValue(workload);
        parent.getEvents().add((Object)evt);
        return evt;
    }

    public EventBuilder logStartOf(StepBuilder step) {
        SliceBuilder aSlice = this.getSliceFor(step);
        return aSlice.logEvent(SchedulingEventKind.RUNNING);
    }

    public EventBuilder logEndOf(StepBuilder step) {
        SliceBuilder aSlice = this.getSliceFor(step);
        return aSlice.logEvent(SchedulingEventKind.TERMINATED);
    }

    public SliceBuilder logAJobOf(StepBuilder step) {
        SliceBuilder aStepSlice = this.getSliceFor(step);
        SliceBuilder aJobSlice = aStepSlice.hasJobSlice();
        return aJobSlice;
    }

    public void hasEvent(EventBuilder evt) {
        this.trace.getEvents().add((Object)evt.build());
    }

    public SliceBuilder hasASlice() {
        Slice sl = TraceFactory.eINSTANCE.createSlice();
        this.build().getSlices().add((Object)sl);
        return new SliceBuilder(this, sl);
    }

    public MappingBuilder mapBuilder() {
        return this.mapBuilder;
    }

    public SchedulingEvent removeLastSchedulingEventFromTrace(Slice slc) {
        ArrayList events = new ArrayList(slc.getEvents());
        Collections.reverse(events);
        for (Event evt : events) {
            if (evt == null || !(evt instanceof SchedulingEvent)) continue;
            SchedulingEvent latest = (SchedulingEvent)evt;
            slc.getEvents().remove((Object)latest);
            return latest;
        }
        return null;
    }
}

