/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.MappableArtefact;
import org.polarsys.time4sys.mapping.Mapping;
import org.polarsys.time4sys.mapping.MappingFactory;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.sam.EndToEndFlow;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Simulation;
import org.polarsys.time4sys.model.time4sys.Transformation;
import org.polarsys.time4sys.trace.Event;
import org.polarsys.time4sys.trace.SchedulingEvent;
import org.polarsys.time4sys.trace.Slice;
import org.polarsys.time4sys.transformations.IdentityDerivation;

public class SimulationAnalyser {
    private final Project project;
    private final Simulation simu;
    private Transformation transfo;
    private DesignModel sourceModel;
    private Mapping simuMapping;
    private Mapping transfoMapping;
    private Context slice2duration;
    private MappingFactory mappingFactory;

    public static Transformation analyse(Simulation simu) {
        if (simu == null) {
            return null;
        }
        Project project = null;
        EObject container = simu.eContainer();
        if (container instanceof Project) {
            project = (Project)container;
        }
        Transformation transfo = SimulationAnalyser.analyse(project, simu);
        if (project != null && transfo != null) {
            project.getTransformations().add((Object)transfo);
        }
        return transfo;
    }

    public static Transformation analyse(Project project, Simulation simu) {
        return new SimulationAnalyser(project, simu).transform();
    }

    public SimulationAnalyser(Project project, Simulation simu) {
        this.project = project;
        this.simu = simu;
        assert (simu != null);
    }

    private Transformation transform() {
        this.sourceModel = this.simu.getDesignModel();
        if (this.sourceModel == null) {
            return null;
        }
        this.simuMapping = this.simu.getMapping();
        this.transfo = IdentityDerivation.duplicate(this.project, this.sourceModel);
        this.transfo.setName("Analysis of " + this.simu.getName());
        this.transfoMapping = this.transfo.getMapping();
        this.createRules();
        this.updateConstraints();
        return this.transfo;
    }

    public void createRules() {
        this.mappingFactory = MappingFactory.eINSTANCE;
        this.slice2duration = this.mappingFactory.createContext("Slice to Duration");
        this.transfoMapping.getRules().add((Object)this.slice2duration);
    }

    private void updateConstraints() {
        for (EndToEndFlow flow : this.sourceModel.getEndToEndFlows()) {
            this.updateConstraint(flow);
        }
    }

    private void updateConstraint(EndToEndFlow sourceFlow) {
        LinkedList<Slice> lengthiestSlices = new LinkedList<Slice>();
        Duration lengthiestTime = NfpFactory.eINSTANCE.createDurationFromString("0ps");
        for (Link lnk : this.simuMapping.getLinksForSource((EObject)sourceFlow)) {
            Slice slice = (Slice)lnk.getUniqueTargetValue("slice");
            for (Slice instanceSlice : slice.getOwnedSubSlices()) {
                EList events = instanceSlice.getAggregatedEvents();
                SchedulingEvent activationEvt = this.searchActivationEvent((EList<Event>)events);
                SchedulingEvent terminatedEvt = this.searchTerminationEvent((EList<Event>)events);
                Duration duration = terminatedEvt.getTimestamp().sub(activationEvt.getTimestamp());
                int comparison = duration.compareTo(lengthiestTime);
                if (comparison < 0) continue;
                lengthiestTime = duration;
                if (comparison > 0) {
                    lengthiestSlices = new LinkedList();
                    lengthiestSlices.add(instanceSlice);
                    continue;
                }
                if (comparison != 0) continue;
                lengthiestSlices.add(instanceSlice);
            }
        }
        for (Link lnk : this.transfoMapping.getLinksForSource((EObject)sourceFlow)) {
            EndToEndFlow targetFlow = (EndToEndFlow)lnk.getUniqueTargetValue("copy");
            assert (targetFlow != null);
            targetFlow.setEndToEndTime(lengthiestTime);
            targetFlow.setIsSchedulable(lengthiestTime.compareTo(sourceFlow.getEndToEndDeadline()) <= 0);
            for (Slice lengthiestSlice : lengthiestSlices) {
                MappableArtefact src = this.mappingFactory.createMappableArtefact("slice", (EObject)lengthiestSlice);
                lnk.getSources().add((Object)src);
                lnk.setRationale(this.slice2duration);
            }
        }
    }

    private SchedulingEvent searchTerminationEvent(EList<Event> events) {
        ArrayList<Event> reversedEvents = new ArrayList<Event>((Collection<Event>)events);
        Collections.reverse(reversedEvents);
        for (Event evt : reversedEvents) {
            if (!(evt instanceof SchedulingEvent)) continue;
            SchedulingEvent schedEvt = (SchedulingEvent)evt;
            switch (schedEvt.getKind()) {
                case TERMINATED: {
                    return schedEvt;
                }
            }
        }
        return null;
    }

    private SchedulingEvent searchActivationEvent(EList<Event> events) {
        for (Event evt : events) {
            if (!(evt instanceof SchedulingEvent)) continue;
            SchedulingEvent schedEvt = (SchedulingEvent)evt;
            switch (schedEvt.getKind()) {
                case ACTIVATED: 
                case RUNNING: {
                    return schedEvt;
                }
            }
        }
        return null;
    }
}

