/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.maven.indexer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.Directory;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.cbi.p2repo.p2.maven.MavenActivator;
import org.eclipse.cbi.p2repo.p2.maven.indexer.Activator;
import org.eclipse.cbi.p2repo.p2.maven.indexer.IMaven2Indexer;
import org.eclipse.cbi.p2repo.p2.maven.indexer.IndexNotFoundException;
import org.eclipse.cbi.p2repo.p2.maven.loader.VersionEntry;
import org.eclipse.cbi.p2repo.p2.maven.util.VersionUtil;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;

public class MavenNexusIndexer
implements IMaven2Indexer {
    private IndexingContext context;
    private Set<VersionEntryIterator> openIterators = new HashSet<VersionEntryIterator>();

    public synchronized void closeRemoteIndex() throws CoreException {
        try {
            for (VersionEntryIterator itor : this.openIterators) {
                itor.close();
            }
            if (this.context != null) {
                this.context.close(false);
                this.context = null;
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.fromMessage((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    public synchronized Iterator<VersionEntry> getArtifacts() throws CoreException {
        try {
            IndexReader indexReader = IndexReader.open((Directory)this.context.getIndexDirectory());
            VersionEntryIterator itor = new VersionEntryIterator(indexReader);
            this.openIterators.add(itor);
            return itor;
        }
        catch (IOException e) {
            throw ExceptionUtils.fromMessage((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    public synchronized int getNumberOfEntries() throws CoreException {
        Iterator<VersionEntry> artifacts = this.getArtifacts();
        int counter = 0;
        while (artifacts.hasNext()) {
            artifacts.next();
            ++counter;
        }
        return counter;
    }

    public void openRemoteIndex(URI location, boolean clearLocalCache) throws IndexNotFoundException, CoreException {
        this.closeRemoteIndex();
        this.openIterators.clear();
        File cacheDirectory = null;
        try {
            cacheDirectory = MavenActivator.getPlugin().getCacheDirectory(location);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.wrap((Throwable)e);
        }
        File indexDirectory = new File(cacheDirectory, "index");
        try {
            PlexusContainer plexus = Activator.getPlugin().getPlexusContainer();
            NexusIndexer indexer = (NexusIndexer)plexus.lookup(NexusIndexer.class);
            IndexUpdater updater = (IndexUpdater)plexus.lookup(IndexUpdater.class);
            IndexCreator creator = (IndexCreator)plexus.lookup(IndexCreator.class, "min");
            String repoId = "mavenRepo";
            this.context = !clearLocalCache ? indexer.addIndexingContext(repoId, repoId, null, indexDirectory, location.toString(), null, Collections.singletonList(creator)) : indexer.addIndexingContextForced(repoId, repoId, null, indexDirectory, location.toString(), null, Collections.singletonList(creator));
            WagonHelper wh = new WagonHelper(plexus);
            IndexUpdateRequest request = new IndexUpdateRequest(this.context, (ResourceFetcher)wh.getWagonResourceFetcher(null));
            updater.fetchAndUpdateIndex(request);
        }
        catch (Exception e) {
            throw new IndexNotFoundException((Throwable)e);
        }
    }

    public void updateLocalIndex(URI location, boolean createNew) throws CoreException {
        try {
            PlexusContainer plexus = Activator.getPlugin().getPlexusContainer();
            NexusIndexer indexer = (NexusIndexer)plexus.lookup(NexusIndexer.class);
            IndexPacker packer = (IndexPacker)plexus.lookup(IndexPacker.class);
            String repoId = "mavenRepo";
            File repository = new File(location);
            File index = new File(repository, ".index");
            File internalIndex = new File(new File(repository.getParentFile().getParentFile(), "interim"), "maven-index");
            ArrayList<IndexCreator> creators = new ArrayList<IndexCreator>(2);
            creators.add((IndexCreator)plexus.lookup(IndexCreator.class, "min"));
            creators.add((IndexCreator)plexus.lookup(IndexCreator.class, "jarContent"));
            IndexingContext context = indexer.addIndexingContext(repoId, repoId, repository, internalIndex, null, null, creators);
            try {
                indexer.scan(context, !createNew);
                IndexPackingRequest request = new IndexPackingRequest(context, index);
                ArrayList<IndexPackingRequest.IndexFormat> formats = new ArrayList<IndexPackingRequest.IndexFormat>(2);
                formats.add(IndexPackingRequest.IndexFormat.FORMAT_V1);
                formats.add(IndexPackingRequest.IndexFormat.FORMAT_LEGACY);
                request.setFormats(formats);
                request.setCreateChecksumFiles(true);
                request.setCreateIncrementalChunks(!createNew);
                packer.packIndex(request);
            }
            finally {
                if (context != null) {
                    context.close(false);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.fromMessage((Throwable)e, (String)"Unable to create an index for %s", (Object[])new Object[]{location.toString()});
        }
    }

    private class VersionEntryIterator
    implements Iterator<VersionEntry> {
        private IndexReader indexReader;
        private TermEnum termEnum;
        private VersionEntry nextEntry;

        public VersionEntryIterator(IndexReader indexReader) throws IOException {
            this.indexReader = indexReader;
            this.termEnum = indexReader.terms(new Term(ArtifactInfo.UINFO, ""));
            this.nextEntry = this.getNextEntry(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            MavenNexusIndexer mavenNexusIndexer = MavenNexusIndexer.this;
            synchronized (mavenNexusIndexer) {
                MavenNexusIndexer.this.openIterators.remove(this);
                if (this.termEnum != null) {
                    this.termEnum.close();
                }
                if (this.indexReader != null) {
                    this.indexReader.close();
                }
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.nextEntry != null;
            if (!hasNext) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Unable to close index reader");
                }
            }
            return hasNext;
        }

        @Override
        public VersionEntry next() {
            if (this.nextEntry != null) {
                VersionEntry entry = this.nextEntry;
                try {
                    this.nextEntry = this.getNextEntry(true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Unable to fully structure code
         */
        private VersionEntry getNextEntry(boolean moveToNext) throws IOException {
            if (!moveToNext || this.termEnum.next()) ** GOTO lbl14
            return null;
lbl-1000:
            // 1 sources

            {
                record = this.termEnum.term().toString();
                tokens = record.split("[:|]");
                if (tokens.length == 5) {
                    try {
                        return new VersionEntry(tokens[1], tokens[2], VersionUtil.createVersion((String)tokens[3]));
                    }
                    catch (CoreException e) {
                        ioe = new IOException(e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                if (!this.termEnum.next()) break;
lbl14:
                // 2 sources

                ** while (this.termEnum.term() != null && ArtifactInfo.UINFO.equals((Object)this.termEnum.term().field()))
            }
lbl15:
            // 2 sources

            return null;
        }
    }
}

