/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VersionFormat implements Enumerator
{
    NORMAL(0, "Normal", "Normal"),
    STRICT_MAVEN(1, "StrictMaven", "StrictMaven"),
    MAVEN_RELEASE(2, "MavenRelease", "MavenRelease");

    public static final int NORMAL_VALUE = 0;
    public static final int STRICT_MAVEN_VALUE = 1;
    public static final int MAVEN_RELEASE_VALUE = 2;
    private static final VersionFormat[] VALUES_ARRAY;
    public static final List<VersionFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VersionFormat[]{NORMAL, STRICT_MAVEN, MAVEN_RELEASE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VersionFormat get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VersionFormat result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VersionFormat getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VersionFormat result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VersionFormat get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return STRICT_MAVEN;
            }
            case 2: {
                return MAVEN_RELEASE;
            }
        }
        return null;
    }

    private VersionFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

