/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public class SortCommand<T>
extends AbstractCommand {
    private EList<T> containment;
    private List<T> originalList;
    private Set<T> sortedSet;
    private T itemTemplate;
    private IItemLabelProvider labelProvider;

    public SortCommand(EditingDomain editingDomain, EList<T> containment, T itemTemplate, String label) {
        super("Sort " + label);
        this.containment = containment;
        this.itemTemplate = itemTemplate;
        this.labelProvider = (IItemLabelProvider)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory().adapt(itemTemplate, IItemLabelProvider.class);
        if (this.labelProvider == null) {
            throw new IllegalArgumentException(itemTemplate.getClass() + " does not provide label");
        }
    }

    public void execute() {
        this.sortedSet = new TreeSet<T>(new LabelHashComparator(this.labelProvider));
        this.sortedSet.addAll((Collection<T>)this.containment);
        this.originalList = new ArrayList<T>();
        this.originalList.addAll((Collection<T>)this.containment);
        this.containment.clear();
        this.containment.addAll(this.sortedSet);
    }

    public Object getImage() {
        return this.labelProvider.getImage(this.itemTemplate);
    }

    protected boolean prepare() {
        return this.containment.size() > 1;
    }

    public void redo() {
        this.containment.clear();
        this.containment.addAll(this.sortedSet);
    }

    public void undo() {
        this.containment.clear();
        this.containment.addAll(this.originalList);
    }

    class LabelHashComparator
    implements Comparator<T> {
        private IItemLabelProvider labelProvider;

        public LabelHashComparator(IItemLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int result = this.labelProvider.getText(o1).compareTo(this.labelProvider.getText(o2));
            if (result == 0) {
                result = System.identityHashCode(o1) - System.identityHashCode(o2);
            }
            return result;
        }
    }
}

