/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.processes.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.processes.ui.ProcessesPlugin;
import org.eclipse.rse.internal.processes.ui.actions.SystemKillProcessAction;
import org.eclipse.rse.internal.processes.ui.view.SystemProcessStatesContentProvider;
import org.eclipse.rse.internal.processes.ui.view.SystemProcessesViewResources;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewRemoteProcessAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter,
ISystemRemoteElementAdapter {
    private SystemCopyToClipboardAction copyClipboardAction;
    private static final Object[] EMPTY_LIST = new Object[0];
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    private SystemKillProcessAction killProcessAction;

    public boolean canDrag(Object element) {
        return true;
    }

    public boolean canDrag(SystemRemoteResourceSet elements) {
        return true;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        return this.getText(element);
    }

    public ISystemResourceSet doDrag(SystemRemoteResourceSet set, IProgressMonitor monitor) {
        return set;
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell parent, String menuGroup) {
        if (this.killProcessAction == null) {
            this.killProcessAction = new SystemKillProcessAction(this.shell);
        }
        menu.add("group.change", (IAction)this.killProcessAction);
        if (this.copyClipboardAction == null) {
            Clipboard clipboard = RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard();
            this.copyClipboardAction = new SystemCopyToClipboardAction(this.shell, clipboard);
        }
        menu.add(menuGroup, (IAction)this.copyClipboardAction);
    }

    public ISubSystem getSubSystem(Object element) {
        if (element instanceof IRemoteProcess) {
            IRemoteProcess process = (IRemoteProcess)element;
            return process.getParentRemoteProcessSubSystem();
        }
        return super.getSubSystem(element);
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        return ProcessesPlugin.getDefault().getImageDescriptorFromPath("icons/full/obj16/activeprocess_obj.gif");
    }

    public String getText(Object element) {
        String text = ((IRemoteProcess)element).getLabel();
        return text == null ? "" : text;
    }

    public String getAlternateText(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        String allProperties = process.getAllProperties();
        return allProperties.replace('|', '\t');
    }

    public String getAbsoluteName(Object object) {
        IRemoteProcess process = (IRemoteProcess)object;
        return "" + process.getPid();
    }

    public String getType(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        if (process.isRoot()) {
            return SystemProcessesViewResources.RESID_PROPERTY_PROCESS_TYPE_ROOT;
        }
        return SystemProcessesViewResources.RESID_PROPERTY_PROCESS_TYPE;
    }

    public Object getParent(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        IRemoteProcess parent = process.getParentRemoteProcess();
        if (parent != null && parent.getAbsolutePath().equals(process.getAbsolutePath())) {
            parent = null;
        }
        return parent;
    }

    public boolean hasChildren(IAdaptable element) {
        return false;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        IRemoteProcess process = (IRemoteProcess)element;
        IRemoteProcessSubSystem ss = process.getParentRemoteProcessSubSystem();
        IHostProcessFilter orgRpfs = process.getFilterString();
        Object[] children = null;
        try {
            children = ss.listAllProcesses(orgRpfs, process.getContext(), null);
            if (children == null || children.length == 0) {
                children = EMPTY_LIST;
            }
        }
        catch (Exception exc) {
            children = new SystemMessageObject[1];
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.processes.ui", "RSEG1098", 4, CommonMessages.MSG_EXPAND_FAILED);
            children[0] = new SystemMessageObject((SystemMessage)msg, 0, (Object)element);
            SystemBasePlugin.logError((String)"Exception resolving file filter strings", (Throwable)exc);
        }
        return children;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            int nbrOfProperties = 11;
            propertyDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            int idx = -1;
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.pid", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_PID_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_PID_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.name", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_NAME_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_NAME_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.state", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_STATE_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_STATE_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.uid", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_UID_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_UID_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.username", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_USERNAME_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_USERNAME_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.ppid", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_PPID_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_PPID_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.gid", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_GID_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_GID_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.tgid", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_TGID_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_TGID_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.tracerpid", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_TRACERPID_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_TRACERPID_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.vmsize", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_VMSIZE_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_VMSIZE_TOOLTIP);
            SystemViewRemoteProcessAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.process.vmrss", (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_VMRSS_LABEL, (String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_VMRSS_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        return this.getPropertyValue(key, true);
    }

    public Object getPropertyValue(Object property, boolean formatted) {
        String name = (String)property;
        IRemoteProcess process = (IRemoteProcess)this.propertySourceInput;
        if (name.equals("org.eclipse.rse.ui.process.gid")) {
            if (formatted) {
                return "" + process.getGid();
            }
            return new Long(process.getGid());
        }
        if (name.equals("org.eclipse.rse.ui.process.name")) {
            return process.getName();
        }
        if (name.equals("org.eclipse.rse.ui.process.pid")) {
            if (formatted) {
                return "" + process.getPid();
            }
            return new Long(process.getPid());
        }
        if (name.equals("org.eclipse.rse.ui.process.ppid")) {
            if (formatted) {
                return "" + process.getPPid();
            }
            return new Long(process.getPPid());
        }
        if (name.equals("org.eclipse.rse.ui.process.state")) {
            if (formatted) {
                return this.formatState(process.getState());
            }
            return process.getState();
        }
        if (name.equals("org.eclipse.rse.ui.process.tgid")) {
            if (formatted) {
                return "" + process.getTgid();
            }
            return new Long(process.getTgid());
        }
        if (name.equals("org.eclipse.rse.ui.process.tracerpid")) {
            if (formatted) {
                return "" + process.getTracerPid();
            }
            return new Long(process.getTracerPid());
        }
        if (name.equals("org.eclipse.rse.ui.process.uid")) {
            if (formatted) {
                return "" + process.getUid();
            }
            return new Long(process.getUid());
        }
        if (name.equals("org.eclipse.rse.ui.process.username")) {
            return process.getUsername();
        }
        if (name.equals("org.eclipse.rse.ui.process.vmsize")) {
            if (formatted) {
                return SystemViewRemoteProcessAdapter.sub((String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_VMSIZE_VALUE, (String)"&1", (String)Long.toString(process.getVmSizeInKB()));
            }
            return new Long(process.getVmSizeInKB());
        }
        if (name.equals("org.eclipse.rse.ui.process.vmrss")) {
            if (formatted) {
                return SystemViewRemoteProcessAdapter.sub((String)SystemProcessesViewResources.RESID_PROPERTY_PROCESS_VMRSS_VALUE, (String)"&1", (String)Long.toString(process.getVmRSSInKB()));
            }
            return new Long(process.getVmRSSInKB());
        }
        return null;
    }

    protected String formatState(String state) {
        if (state == null) {
            return "";
        }
        state = state.trim();
        String longState = "";
        String[] allStates = state.split(",");
        if (allStates == null) {
            return longState;
        }
        SystemProcessStatesContentProvider zstates = new SystemProcessStatesContentProvider();
        int i = 0;
        while (i < allStates.length) {
            longState = String.valueOf(longState) + allStates[i].charAt(0) + "-" + zstates.getStateString(allStates[i]);
            if (i < allStates.length - 1) {
                longState = String.valueOf(longState) + ", ";
            }
            ++i;
        }
        return longState;
    }

    public String getAbsoluteParentName(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        IRemoteProcess parent = process.getParentRemoteProcess();
        if (parent != null) {
            return parent.getAbsolutePath();
        }
        return "/proc/0";
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        return ((IRemoteProcess)element).getParentRemoteProcess();
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        String[] pids = EMPTY_STRING_LIST;
        IRemoteProcess process = (IRemoteProcess)element;
        String parentName = "" + process.getPPid();
        if (parentName.equals("-1")) {
            return pids;
        }
        Object[] children = this.getChildren(process.getParentRemoteProcess());
        if (children == null || children.length == 0) {
            return pids;
        }
        pids = new String[children.length];
        int idx = 0;
        while (idx < pids.length) {
            pids[idx] = "" + ((IRemoteProcess)children[idx]).getPid();
            ++idx;
        }
        return pids;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        if (process.isRoot()) {
            return "rootprocess";
        }
        return "process";
    }

    public String getRemoteTypeCategory(Object element) {
        return "processes";
    }

    public String getSubSystemConfigurationId(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        return process.getParentRemoteProcessSubSystem().getSubSystemConfiguration().getId();
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public boolean supportsDeferredQueries(ISubSystem subSys) {
        return true;
    }
}

