/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemPropertySheetForm;
import org.eclipse.rse.internal.ui.view.SystemViewForm;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemActionViewerFilter;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemResourceSelectionInputProvider;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.rse.ui.widgets.SystemHostCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemResourceSelectionForm
implements ISelectionChangedListener {
    private Shell _shell;
    private boolean _multipleSelection = true;
    protected static final int PROMPT_WIDTH = 400;
    private ISystemResourceSelectionInputProvider _inputProvider;
    private SystemHostCombo _connectionCombo;
    private SystemViewForm _systemViewForm;
    private Composite _propertySheetContainer;
    private SystemPropertySheetForm _ps;
    private Text _pathText;
    private boolean _isValid;
    private ISystemMessageLine _msgLine;
    protected Object previousSelection = null;
    private IValidatorRemoteSelection _selectionValidator = null;
    private boolean showPropertySheet = false;
    protected Object caller;
    protected boolean callerInstanceOfWizardPage;
    protected boolean callerInstanceOfSystemPromptDialog;
    protected String _verbiage = null;
    protected Label verbiageLabel;
    private Composite _container;
    private HashMap _history;
    protected IHost outputConnection = null;
    protected Object[] outputObjects = null;
    static /* synthetic */ Class class$0;

    public SystemResourceSelectionForm(Shell shell, Composite parent, Object caller, ISystemResourceSelectionInputProvider inputProvider, String verbiage, boolean multipleSelection, ISystemMessageLine msgLine) {
        this._msgLine = msgLine;
        this._history = new HashMap();
        this._inputProvider = inputProvider;
        this._multipleSelection = multipleSelection;
        this._shell = shell;
        this._verbiage = verbiage;
        this.caller = caller;
        this.callerInstanceOfWizardPage = caller instanceof WizardPage;
        this.callerInstanceOfSystemPromptDialog = caller instanceof SystemPromptDialog;
        this.createControls(parent);
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this._msgLine = msgLine;
    }

    public Object getSelectedObject() {
        if (this.outputObjects != null && this.outputObjects.length >= 1) {
            return this.outputObjects[0];
        }
        return null;
    }

    public Object[] getSelectedObjects() {
        return this.outputObjects;
    }

    public ISystemTree getSystemTree() {
        return this._systemViewForm.getSystemTree();
    }

    public void createControls(Composite parent) {
        this._container = SystemWidgetHelpers.createComposite(parent, this.showPropertySheet ? 2 : 1);
        int gridColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createFlushComposite(this._container, gridColumns);
        if (this.showPropertySheet) {
            this.createPropertySheet(this._container, this._shell);
        }
        this.verbiageLabel = SystemWidgetHelpers.createVerbiage(composite_prompts, this._verbiage, gridColumns, false, 400);
        boolean allowMultipleConnnections = this._inputProvider.allowMultipleConnections();
        if (allowMultipleConnnections) {
            IRSESystemType[] systemTypes = this._inputProvider.getSystemTypes();
            String category = this._inputProvider.getCategory();
            this._connectionCombo = systemTypes != null ? new SystemHostCombo(composite_prompts, 0, systemTypes, this._inputProvider.getSystemConnection(), this._inputProvider.allowNewConnection()) : (category != null ? new SystemHostCombo(composite_prompts, 0, this._inputProvider.getSystemConnection(), this._inputProvider.allowNewConnection(), category) : new SystemHostCombo(composite_prompts, 0, SystemWidgetHelpers.getValidSystemTypes(null), this._inputProvider.getSystemConnection(), this._inputProvider.allowNewConnection()));
            this._connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    IHost connection = SystemResourceSelectionForm.this._connectionCombo.getHost();
                    SystemResourceSelectionForm.this.connectionChanged(connection);
                }
            });
            this._connectionCombo.listenToConnectionEvents(true);
        }
        this._pathText = SystemWidgetHelpers.createReadonlyTextField(composite_prompts);
        this._systemViewForm = new SystemViewForm(this._shell, composite_prompts, 0, this._inputProvider, !this._multipleSelection, this._msgLine);
        this._systemViewForm.addSelectionChangedListener(this);
        GridLayout layout = new GridLayout();
        GridData gdata = new GridData(1808);
        composite_prompts.setLayout((Layout)layout);
        composite_prompts.setLayoutData((Object)gdata);
        this.doInitializeFields();
    }

    private void doInitializeFields() {
        this.setPageComplete();
    }

    private void createPropertySheet(Composite outerParent, Shell shell) {
        this._propertySheetContainer = SystemWidgetHelpers.createFlushComposite(outerParent, 1);
        ((GridData)this._propertySheetContainer.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this._propertySheetContainer.getLayoutData()).verticalAlignment = 4;
        this._ps = new SystemPropertySheetForm(shell, this._propertySheetContainer, 2048, this._msgLine);
    }

    public Control getInitialFocusControl() {
        return this._systemViewForm.getTreeControl();
    }

    public void applyViewerFilter(SystemActionViewerFilter filter) {
        if (filter != null) {
            this._systemViewForm.getSystemTree().addFilter(filter);
        }
    }

    public boolean verify() {
        if (this._isValid) {
            if (this._msgLine != null) {
                this._msgLine.clearErrorMessage();
            }
            return true;
        }
        return false;
    }

    protected ISystemViewElementAdapter getViewAdapter(Object selection) {
        if (selection != null && selection instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)selection;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object selection) {
        if (selection != null && selection instanceof IAdaptable) {
            return SystemAdapterHelpers.getRemoteAdapter(selection);
        }
        return null;
    }

    protected ISystemRemoteElementAdapter[] getRemoteAdapters(ISelection selection) {
        Object[] selectedObjects = this.getSelections(selection);
        ISystemRemoteElementAdapter[] adapters = new ISystemRemoteElementAdapter[selectedObjects.length];
        int idx = 0;
        while (idx < adapters.length) {
            adapters[idx] = this.getRemoteAdapter(selectedObjects[idx]);
            ++idx;
        }
        return adapters;
    }

    public void connectionChanged(IHost connection) {
        IHost previousConnection = this._inputProvider.getSystemConnection();
        if (previousConnection != connection) {
            this._inputProvider.setSystemConnection(connection, false);
            this._systemViewForm.refresh();
            Object oldSelection = this._history.get(connection);
            if (oldSelection != null) {
                this.setPreSelection(oldSelection);
            }
        }
    }

    public void setVerbiage(String verbiage) {
        this._verbiage = verbiage;
    }

    public boolean setPreSelection(Object selection) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(selection);
        if (adapter != null) {
            Object parent = adapter.getParent(selection);
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            ISubSystem ss = adapter.getSubSystem(selection);
            IHost connection = ss.getHost();
            if (this._inputProvider.allowMultipleConnections() && (this._connectionCombo.getHost() != connection || this._inputProvider.getSystemConnection() != connection)) {
                this._connectionCombo.select(connection);
            }
            List filterRefs = registry.findFilterReferencesFor(selection, ss, false);
            ISystemTree systemTree = this._systemViewForm.getSystemTree();
            if (filterRefs.size() > 0) {
                ISystemFilterReference ref = (ISystemFilterReference)filterRefs.get(0);
                systemTree.expandTo(ref, selection);
                return true;
            }
            if (this.setPreSelection(parent)) {
                systemTree.expandTo(parent, selection);
                return true;
            }
        }
        return false;
    }

    protected void setPathText(String text) {
        this._pathText.setText(text);
    }

    public Object[] getOutputObjects() {
        return this.outputObjects;
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    protected Object getFirstSelection(ISelection selection) {
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection != null) {
            Iterator selectionIterator = sSelection.iterator();
            if (selectionIterator.hasNext()) {
                return selectionIterator.next();
            }
            return null;
        }
        return null;
    }

    protected Object[] getSelections(ISelection selection) {
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection != null) {
            Object[] selectedObjects = new Object[sSelection.size()];
            Iterator selectionIterator = sSelection.iterator();
            int idx = 0;
            while (selectionIterator.hasNext()) {
                selectedObjects[idx++] = selectionIterator.next();
            }
            return selectedObjects;
        }
        return null;
    }

    private void setPathTextFromSelection(Object selection) {
        String text = "";
        ISystemViewElementAdapter adapter = this.getViewAdapter(selection);
        text = selection instanceof ISystemFilterReference ? adapter.getText(selection) : adapter.getAbsoluteName(selection);
        this.setPathText(text);
    }

    public boolean toggleShowPropertySheet(Shell shell, Control contents) {
        ISelection s;
        Point windowSize = shell.getSize();
        Point oldSize = contents.computeSize(-1, -1);
        if (this.showPropertySheet) {
            this._ps.dispose();
            this._propertySheetContainer.dispose();
            this._ps = null;
            this._propertySheetContainer = null;
            ((GridLayout)this._container.getLayout()).numColumns = 1;
        } else {
            ((GridLayout)this._container.getLayout()).numColumns = 2;
            this.createPropertySheet(this._container, shell);
        }
        Point newSize = contents.computeSize(-1, -1);
        shell.setSize(new Point(windowSize.x + (newSize.x - oldSize.x), windowSize.y));
        if (this._ps != null && (s = this._systemViewForm.getSelection()) != null) {
            this._ps.selectionChanged(s);
        }
        this.showPropertySheet = !this.showPropertySheet;
        return this.showPropertySheet;
    }

    public void selectionChanged(SelectionChangedEvent e) {
        Object selectedObject;
        this._isValid = true;
        ISelection selection = e.getSelection();
        this.outputObjects = null;
        int selectionSize = ((IStructuredSelection)selection).size();
        if (selectionSize > 1 && !this._systemViewForm.sameParent()) {
            this.clearErrorMessage();
            this.setPathText("");
            this.setPageComplete();
            return;
        }
        if (this._ps != null) {
            this._ps.selectionChanged(selection);
        }
        if ((selectedObject = this.getFirstSelection(selection)) == this.previousSelection && selectionSize == 1) {
            this.outputObjects = this.getSelections(selection);
            return;
        }
        this.clearErrorMessage();
        this.setPathText("");
        this.setPageComplete();
        this.previousSelection = selectedObject;
        if (selectedObject != null) {
            SystemMessage selectionMsg;
            ISystemRemoteElementAdapter remoteAdapter = this.getRemoteAdapter(selectedObject);
            if (remoteAdapter != null) {
                this.setPathTextFromSelection(selectedObject);
                this.outputObjects = this.getSelections(selection);
                this.outputConnection = remoteAdapter.getSubSystem(selectedObject).getHost();
                this._history.put(this.outputConnection, this.previousSelection);
            } else {
                ISystemViewElementAdapter elementAdapter;
                IAdaptable iAdaptable = (IAdaptable)selectedObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((elementAdapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.setPathTextFromSelection(selectedObject);
                    this.outputObjects = this.getSelections(selection);
                    this.outputConnection = elementAdapter.getSubSystem(selectedObject).getHost();
                    this._history.put(this.outputConnection, this.previousSelection);
                }
            }
            if (this._selectionValidator != null && (selectionMsg = this._selectionValidator.isValid(this.outputConnection, this.getSelections(selection), this.getRemoteAdapters(selection))) != null) {
                this._isValid = false;
                this.setErrorMessage(selectionMsg);
            }
            this.setPageComplete();
        }
    }

    public boolean isPageComplete() {
        return this._pathText.getText().length() > 0 && this._isValid;
    }

    public void setPageComplete() {
        if (this.callerInstanceOfWizardPage) {
            ((WizardPage)this.caller).setPageComplete(this.isPageComplete());
        } else if (this.callerInstanceOfSystemPromptDialog) {
            ((SystemPromptDialog)this.caller).setPageComplete(this.isPageComplete());
        }
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setSelectionValidator(IValidatorRemoteSelection selectionValidator) {
        this._selectionValidator = selectionValidator;
    }

    protected void clearErrorMessage() {
        if (this._msgLine != null) {
            this._msgLine.clearErrorMessage();
        }
    }

    protected void setErrorMessage(String msg) {
        if (this._msgLine != null) {
            if (msg != null) {
                this._msgLine.setErrorMessage(msg);
            } else {
                this._msgLine.clearErrorMessage();
            }
        }
    }

    protected void setErrorMessage(SystemMessage msg) {
        if (this._msgLine != null) {
            if (msg != null) {
                this._msgLine.setErrorMessage(msg);
            } else {
                this._msgLine.clearErrorMessage();
            }
        }
    }

    public void setMessage(String message) {
        this._verbiage = message;
        if (this.verbiageLabel != null) {
            this.verbiageLabel.setText(message);
        }
    }

    public void setSelectionTreeToolTipText(String tip) {
        this._systemViewForm.setToolTipText(tip);
    }
}

