/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.ui.SystemBasePlugin;

public class RemoteFileImportData {
    private IPath containerPath;
    private Object source;
    private boolean overWriteExistingFiles;
    private boolean createDirectoryStructure;
    private boolean createSelectionOnly;
    private boolean saveSettings;
    private String descriptionFilePath;
    private HashMap map;
    private List elements;

    public RemoteFileImportData() {
        this.setContainerPath(null);
        this.setSource(null);
        this.setOverWriteExistingFiles(false);
        this.setCreateDirectoryStructure(false);
        this.setCreateSelectionOnly(true);
        this.setSaveSettings(false);
        this.setDescriptionFilePath(null);
    }

    public String getDescriptionFilePath() {
        return this.descriptionFilePath;
    }

    public IFile getDescriptionFile() {
        Path path = new Path(this.getDescriptionFilePath());
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return SystemBasePlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public void setDescriptionFilePath(String descriptionFilePath) {
        this.descriptionFilePath = descriptionFilePath;
    }

    public IPath getContainerPath() {
        return this.containerPath;
    }

    public void setContainerPath(IPath containerPath) {
        this.containerPath = containerPath;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public List getElements() {
        return this.elements;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public void addToList(UniFilePlus object) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(object.getAbsolutePath(), object);
    }

    public boolean doesExist(UniFilePlus object) {
        return this.map.get(object.getAbsolutePath()) != null;
    }

    public boolean isOverWriteExistingFiles() {
        return this.overWriteExistingFiles;
    }

    public void setOverWriteExistingFiles(boolean overWriteExistingFiles) {
        this.overWriteExistingFiles = overWriteExistingFiles;
    }

    public boolean isSaveSettings() {
        return this.saveSettings;
    }

    public void setSaveSettings(boolean saveSettings) {
        this.saveSettings = saveSettings;
    }

    public boolean isCreateDirectoryStructure() {
        return this.createDirectoryStructure;
    }

    public void setCreateDirectoryStructure(boolean createDirectoryStructure) {
        this.createDirectoryStructure = createDirectoryStructure;
    }

    public boolean isCreateSelectionOnly() {
        return this.createSelectionOnly;
    }

    public void setCreateSelectionOnly(boolean createSelectionOnly) {
        this.createSelectionOnly = createSelectionOnly;
    }

    public IRemoteFileImportDescriptionWriter createImportDescriptionWriter(OutputStream outputStream) {
        return new RemoteFileImportDescriptionWriter(outputStream);
    }

    public IRemoteFileImportDescriptionReader createImportDescriptionReader(InputStream inputStream) {
        return new RemoteFileImportDescriptionReader(inputStream);
    }
}

