/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.dstore.core.server.IServerLogger;

public class ServerLogger
implements IServerLogger {
    private static final String DEBUG_LEVEL = "debug_level";
    private static final String LOG_LOCATION = "log_location";
    private static final int LOG_WARNING = 1;
    private static final int LOG_INFO = 2;
    private static final int LOG_DEBUG = 3;
    private static final String LOG_TO_STDOUT = "Log_To_StdOut";
    private Object writeLock = new Object();
    private PrintWriter _logFileStream = null;
    public static boolean DEBUG = false;
    private int log_level = 0;
    private boolean initialized = false;
    private String logPathName = null;
    private boolean logToFile = true;

    public ServerLogger(String logPathName) {
        this.logPathName = logPathName;
        try {
            ResourceBundle properties = ResourceBundle.getBundle("rsecomm");
            String debug_level = properties.getString(DEBUG_LEVEL).trim();
            this.log_level = Integer.parseInt(debug_level);
            String log_location = properties.getString(LOG_LOCATION).trim();
            if (log_location.equalsIgnoreCase(LOG_TO_STDOUT)) {
                this.logToFile = false;
                this._logFileStream = new PrintWriter(System.out);
            }
        }
        catch (Exception exception) {}
    }

    private void initialize() {
        this.initialized = true;
        if (this._logFileStream == null && this.logToFile) {
            try {
                File _logFile = new File(this.logPathName, "rsecomm.log");
                if (!_logFile.exists()) {
                    _logFile.createNewFile();
                }
                this._logFileStream = new PrintWriter(new FileOutputStream(_logFile));
            }
            catch (IOException iOException) {
                System.out.println("Error opening log file " + this.logPathName + "rsecomm.log");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInfo(String minerName, String message) {
        String loggerLogLevel;
        if (!this.initialized) {
            this.initialize();
        }
        if ((loggerLogLevel = System.getProperty("DSTORE_LOGGER_LOG_LEVEL")) != null) {
            try {
                this.log_level = Integer.parseInt(loggerLogLevel);
            }
            catch (NumberFormatException e) {
                System.err.println("ServerLogger: " + e.toString());
            }
        }
        if (this.log_level >= 2 && this._logFileStream != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this._logFileStream.println(new Date());
                    this._logFileStream.println("INFO " + minerName + ": " + message);
                    this._logFileStream.println("---------------------------------------------------------------");
                    this._logFileStream.flush();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logWarning(String minerName, String message) {
        String loggerLogLevel;
        if (!this.initialized) {
            this.initialize();
        }
        if ((loggerLogLevel = System.getProperty("DSTORE_LOGGER_LOG_LEVEL")) != null) {
            try {
                this.log_level = Integer.parseInt(loggerLogLevel);
            }
            catch (NumberFormatException e) {
                System.err.println("ServerLogger: " + e.toString());
            }
        }
        if (this.log_level >= 1 && this._logFileStream != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this._logFileStream.println(new Date());
                    this._logFileStream.println("WARNING " + minerName + ": " + message);
                    this._logFileStream.println("---------------------------------------------------------------");
                    this._logFileStream.flush();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logError(String minerName, String message, Throwable exception) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this._logFileStream != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this._logFileStream.println(new Date());
                    this._logFileStream.println("ERROR " + minerName + ": " + message);
                    if (exception != null) {
                        exception.printStackTrace(this._logFileStream);
                    }
                    this._logFileStream.println("---------------------------------------------------------------");
                    this._logFileStream.flush();
                }
                catch (Exception exception2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logDebugMessage(String minerName, String message) {
        if (!this.initialized) {
            this.initialize();
        }
        if (DEBUG && this.log_level == 3 && this._logFileStream != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this._logFileStream.println(new Date());
                    this._logFileStream.println("DEBUG " + minerName + ": " + message);
                    this._logFileStream.println("---------------------------------------------------------------");
                    this._logFileStream.flush();
                }
                catch (Exception exception) {}
            }
        }
    }
}

