/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.core.model.RSEPersistableObject;

public abstract class PropertySetContainer
extends RSEPersistableObject
implements IPropertySetContainer {
    private Map _propertySets = new HashMap();

    public IPropertySet[] getPropertySets() {
        ArrayList sets = new ArrayList();
        Iterator iter = this._propertySets.values().iterator();
        while (iter.hasNext()) {
            sets.add(iter.next());
        }
        return sets.toArray(new IPropertySet[sets.size()]);
    }

    public IPropertySet getPropertySet(String name) {
        return (IPropertySet)this._propertySets.get(name);
    }

    public IPropertySet createPropertySet(String name, String description) {
        PropertySet newSet = new PropertySet(name);
        newSet.setDescription(description);
        newSet.setContainer(this);
        this._propertySets.put(name, newSet);
        return newSet;
    }

    public IPropertySet createPropertySet(String name) {
        PropertySet newSet = new PropertySet(name);
        newSet.setContainer(this);
        this._propertySets.put(name, newSet);
        return newSet;
    }

    public boolean addPropertySet(IPropertySet set) {
        IPropertySetContainer old = set.getContainer();
        if (old != null) {
            old.removePropertySet(set.getName());
        }
        set.setContainer(this);
        this._propertySets.put(set.getName(), set);
        return true;
    }

    public boolean addPropertySets(IPropertySet[] sets) {
        int i = 0;
        while (i < sets.length) {
            this.addPropertySet(sets[i]);
            ++i;
        }
        return true;
    }

    public boolean removePropertySet(String name) {
        return this._propertySets.remove(name) != null;
    }
}

