/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class SystemIFileProperties {
    private static final String STRING_EMPTY = "";
    private static final String EXPORT_KEY = "export";
    private static QualifiedName _nameDirty = new QualifiedName("", "temp_file_dirty");
    private static QualifiedName _nameReadOnly = new QualifiedName("", "temp_file_readonly");
    private static QualifiedName _nameEditorProfileType = new QualifiedName("", "editorProfileType");
    private static QualifiedName _nameEncoding = new QualifiedName("", "source_encoding_key");
    private static QualifiedName _nameHasSequenceNumbers = new QualifiedName("", "sequence_numbers_key");
    private static QualifiedName _nameRecordLength = new QualifiedName("", "record_length_key");
    private static QualifiedName _nameRemoteCCSID = new QualifiedName("", "ccsid_key");
    private static QualifiedName _nameRemoteFileObject = new QualifiedName("", "remote_file_object_key");
    private static QualifiedName _nameRemoteFilePath = new QualifiedName("", "remote_file_path_key");
    private static QualifiedName _nameRemoteFileSubSystem = new QualifiedName("", "remote_file_subsystem_key");
    private static QualifiedName _nameRemoteFileTimeStamp = new QualifiedName("", "remote_file_modified_stamp");
    private static QualifiedName _nameDownloadFileTimeStamp = new QualifiedName("", "download_file_modified_stamp");
    private static QualifiedName _nameUsedBinaryTransfer = new QualifiedName("", "remote_file_binary_transfer");
    private static QualifiedName _nameTempCCSID = new QualifiedName("", "temp_ccsid_key");
    private static QualifiedName _nameRemoteBIDILogical = new QualifiedName("", "bidi_logical_key");
    private static QualifiedName _nameRemoteFileMounted = new QualifiedName("", "remote_file_mounted");
    private static QualifiedName _nameResolvedMountedRemoteFileHost = new QualifiedName("", "resolved_mounted_remote_file_host_key");
    private static QualifiedName _nameResolvedMountedRemoteFilePath = new QualifiedName("", "resolved_mounted_remote_file_path_key");
    private static QualifiedName _nameLocalEncoding = new QualifiedName("org.eclipse.rse.ui", "encoding");
    protected IResource _resource = null;

    public SystemIFileProperties(IResource file) {
        this._resource = file;
        if (file == null) {
            throw new NullPointerException();
        }
    }

    public boolean getDirty() {
        return this.getPropertyBoolean(_nameDirty);
    }

    public boolean getReadOnly() {
        return this.getPropertyBoolean(_nameReadOnly);
    }

    public boolean getRemoteFileMounted() {
        return this.getPropertyBoolean(_nameRemoteFileMounted);
    }

    public String getEditorProfileType() {
        return this.getPropertyString(_nameEditorProfileType);
    }

    public String getEncoding() {
        return this.getPropertyString(_nameEncoding);
    }

    public String getLocalEncoding() {
        return this.getPropertyString(_nameLocalEncoding);
    }

    public IResource getFile() {
        return this._resource;
    }

    public boolean getHasSequenceNumbers() {
        return this.getPropertyBoolean(_nameHasSequenceNumbers);
    }

    protected Object getParentSessionObject(QualifiedName name) {
        try {
            return this._resource.getParent().getSessionProperty(name);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected boolean getPropertyBoolean(QualifiedName name) {
        String strValue;
        block3: {
            try {
                strValue = this._resource.getPersistentProperty(name);
                if (strValue != null) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return strValue.equals("true");
    }

    protected int getPropertyInteger(QualifiedName name) {
        String strValue;
        block4: {
            strValue = this._resource.getPersistentProperty(name);
            if (strValue != null) break block4;
            return 0;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (CoreException coreException) {
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected long getPropertyLong(QualifiedName name) {
        String strValue;
        block5: {
            strValue = this._resource.getPersistentProperty(name);
            if (strValue != null) break block5;
            return 0L;
        }
        try {
            return Long.parseLong(strValue);
        }
        catch (CoreException coreException) {
            return 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    protected String getPropertyString(QualifiedName name) {
        try {
            return this._resource.getPersistentProperty(name);
        }
        catch (CoreException coreException) {
            return STRING_EMPTY;
        }
    }

    public int getRecordLength() {
        return this.getPropertyInteger(_nameRecordLength);
    }

    public int getRemoteCCSID() {
        return this.getPropertyInteger(_nameRemoteCCSID);
    }

    public Object getRemoteFileObject() {
        return this.getSessionObject(_nameRemoteFileObject);
    }

    public Object getTempCCSID() {
        return this.getParentSessionObject(_nameTempCCSID);
    }

    public String getResolvedMountedRemoteFilePath() {
        return this.getPropertyString(_nameResolvedMountedRemoteFilePath);
    }

    public String getResolvedMountedRemoteFileHost() {
        return this.getPropertyString(_nameResolvedMountedRemoteFileHost);
    }

    public String getRemoteFilePath() {
        return this.getPropertyString(_nameRemoteFilePath);
    }

    public String getRemoteFileSubSystem() {
        return this.getPropertyString(_nameRemoteFileSubSystem);
    }

    public long getRemoteFileTimeStamp() {
        return this.getPropertyLong(_nameRemoteFileTimeStamp);
    }

    public long getDownloadFileTimeStamp() {
        return this.getPropertyLong(_nameDownloadFileTimeStamp);
    }

    protected Object getSessionObject(QualifiedName name) {
        try {
            return this._resource.getSessionProperty(name);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public boolean getUsedBinaryTransfer() {
        return this.getPropertyBoolean(_nameUsedBinaryTransfer);
    }

    public void setDirty(boolean bDirty) {
        this.setPropertyBoolean(_nameDirty, bDirty);
    }

    public void setReadOnly(boolean bReadOnly) {
        this.setPropertyBoolean(_nameReadOnly, bReadOnly);
    }

    public void setRemoteFileMounted(boolean bMounted) {
        this.setPropertyBoolean(_nameRemoteFileMounted, bMounted);
    }

    public void setEditorProfileType(String strType) {
        this.setPropertyString(_nameEditorProfileType, strType);
    }

    public void setEncoding(String strEncoding) {
        this.setPropertyString(_nameEncoding, strEncoding);
    }

    public void setLocalEncoding(String strLocalEncoding) {
        this.setPropertyString(_nameLocalEncoding, strLocalEncoding);
    }

    public boolean getBIDILogical() {
        return this.getPropertyBoolean(_nameRemoteBIDILogical);
    }

    public void setBIDILogical(boolean logical) {
        this.setPropertyBoolean(_nameRemoteBIDILogical, logical);
    }

    public void setHasSequenceNumbers(boolean bSequenceNumbers) {
        this.setPropertyBoolean(_nameHasSequenceNumbers, bSequenceNumbers);
    }

    protected void setParentSessionObject(QualifiedName name, Object objValue) {
        try {
            this._resource.getParent().setSessionProperty(name, objValue);
        }
        catch (CoreException coreException) {}
    }

    protected void setPropertyBoolean(QualifiedName name, boolean bValue) {
        this.setPropertyString(name, bValue ? "true" : "false");
    }

    protected void setPropertyInteger(QualifiedName name, int iValue) {
        this.setPropertyString(name, String.valueOf(iValue));
    }

    protected void setPropertyLong(QualifiedName name, long lValue) {
        this.setPropertyString(name, String.valueOf(lValue));
    }

    protected void setPropertyString(QualifiedName name, String strValue) {
        String strValueCurrent = null;
        try {
            strValueCurrent = this._resource.getPersistentProperty(name);
        }
        catch (CoreException coreException) {
            strValueCurrent = STRING_EMPTY;
        }
        if (strValue != null && strValue.equals(strValueCurrent)) {
            return;
        }
        try {
            this._resource.setPersistentProperty(name, strValue);
        }
        catch (CoreException coreException) {}
    }

    public void setRecordLength(int iRecordLength) {
        this.setPropertyInteger(_nameRecordLength, iRecordLength);
    }

    public void setRemoteCCSID(int iCCSID) {
        this.setPropertyInteger(_nameRemoteCCSID, iCCSID);
    }

    public void setRemoteFileObject(Object object) {
        this.setSessionObject(_nameRemoteFileObject, object);
    }

    public void setResolvedMountedRemoteFilePath(String strPath) {
        this.setPropertyString(_nameResolvedMountedRemoteFilePath, strPath);
    }

    public void setResolvedMountedRemoteFileHost(String strHost) {
        this.setPropertyString(_nameResolvedMountedRemoteFileHost, strHost);
    }

    public void setRemoteFilePath(String strPath) {
        this.setPropertyString(_nameRemoteFilePath, strPath);
    }

    public void setRemoteFileSubSystem(String strSubSystem) {
        this.setPropertyString(_nameRemoteFileSubSystem, strSubSystem);
    }

    public void setRemoteFileTimeStamp(long lTimeStamp) {
        this.setPropertyLong(_nameRemoteFileTimeStamp, lTimeStamp);
    }

    public void setDownloadFileTimeStamp(long lTimeStamp) {
        this.setPropertyLong(_nameDownloadFileTimeStamp, lTimeStamp);
    }

    protected void setSessionObject(QualifiedName name, Object objValue) {
        try {
            this._resource.setSessionProperty(name, objValue);
        }
        catch (CoreException coreException) {}
    }

    public void setTempCCSID(Object object) {
        this.setParentSessionObject(_nameTempCCSID, object);
    }

    public void setUsedBinaryTransfer(boolean bBinaryTransfer) {
        this.setPropertyBoolean(_nameUsedBinaryTransfer, bBinaryTransfer);
    }

    public void setModificationStampAtExport(String hostName, String destination, long modificationStamp) {
        QualifiedName key = new QualifiedName(STRING_EMPTY, "export:" + hostName + ":" + destination);
        this.setPropertyLong(key, modificationStamp);
    }

    public long getModificationStampAtExport(String hostName, String destination) {
        QualifiedName key = new QualifiedName(STRING_EMPTY, "export:" + hostName + ":" + destination);
        return this.getPropertyLong(key);
    }

    public boolean hasModificationStampAtExport(String hostName, String destination) {
        QualifiedName key = new QualifiedName(STRING_EMPTY, "export:" + hostName + ":" + destination);
        String val = this.getPropertyString(key);
        return val != null;
    }
}

