/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileClassifier;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileDescriptors;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.QueryThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.UniversalFileSystemFilter;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;

public class FileQueryThread
extends QueryThread {
    private File _fileobj;
    private String _queryType;
    private String _filter;
    private boolean _caseSensitive;
    private int _inclusion;
    private boolean _showHidden;
    private boolean _isWindows;

    public FileQueryThread(DataElement subject, File fileobj, String queryType, String filter, boolean caseSensitive, int inclusion, boolean showHidden, boolean isWindows, DataElement status) {
        super(subject, status);
        this._fileobj = fileobj;
        this._queryType = queryType;
        this._filter = filter;
        this._caseSensitive = caseSensitive;
        this._inclusion = inclusion;
        this._showHidden = showHidden;
        this._isWindows = isWindows;
    }

    public void run() {
        super.run();
        this.doQueryAll();
        if (!this.isCancelled()) {
            this._isDone = true;
            this._dataStore.refresh(this._subject);
            this.statusDone(this._status);
        }
    }

    protected void doQueryAll() {
        if (this._fileobj.exists()) {
            boolean filterFiles = this._inclusion == 8 || this._inclusion == 2;
            boolean filterFolders = this._inclusion == 8 || this._inclusion == 4;
            UniversalFileSystemFilter filefilter = new UniversalFileSystemFilter(this._filter, filterFiles, filterFolders, this._caseSensitive);
            String theOS = System.getProperty("os.name");
            File[] list = null;
            if (theOS.equals("z/OS")) {
                File[] tempList = this._fileobj.listFiles();
                ArrayList<File> acceptedList = new ArrayList<File>(tempList.length);
                int i = 0;
                while (i < tempList.length) {
                    File afile = tempList[i];
                    if (filefilter.accept(this._fileobj, afile.getName())) {
                        acceptedList.add(afile);
                    }
                    ++i;
                }
                list = new File[acceptedList.size()];
                int l = 0;
                while (l < acceptedList.size()) {
                    list[l] = (File)acceptedList.get(l);
                    ++l;
                }
            } else {
                list = this._fileobj.listFiles(filefilter);
            }
            if (!this._isCancelled && list != null) {
                this.createDataElement(this._dataStore, this._subject, list, this._queryType, this._filter, this._inclusion);
                if (this._subject.getSource() == null || this._subject.getSource().equals("")) {
                    String folderProperties = this.setProperties(this._fileobj);
                    this._subject.setAttribute(4, folderProperties);
                }
                if (!this._isCancelled) {
                    FileClassifier clsfy = this.getFileClassifier(this._subject);
                    clsfy.start();
                }
            }
        }
    }

    protected FileClassifier getFileClassifier(DataElement subject) {
        return new FileClassifier(subject);
    }

    protected void createDataElement(DataStore ds, DataElement subject, File[] list, String queryType, String filter, int include) {
        this.createDataElement(ds, subject, list, queryType, filter, include, null);
    }

    protected void createDataElement(DataStore ds, DataElement subject, File[] list, String queryType, String filter, int include, String[] types) {
        HashMap<String, DataElement> filteredChildren = new HashMap<String, DataElement>();
        List children = subject.getNestedData();
        if (children != null) {
            int f = 0;
            while (f < children.size()) {
                if (this._isCancelled) {
                    return;
                }
                DataElement child = (DataElement)children.get(f);
                if (!child.isDeleted()) {
                    filteredChildren.put(child.getName(), child);
                }
                ++f;
            }
        }
        boolean found = false;
        try {
            int j = 0;
            while (j < list.length) {
                if (this._isCancelled) {
                    return;
                }
                found = false;
                File file = list[j];
                String fileName = file.getName();
                boolean isHidden = file.isHidden() || fileName.charAt(0) == '.';
                DataElement previousElement = (DataElement)filteredChildren.get(fileName);
                if (previousElement != null && !previousElement.isDeleted()) {
                    boolean isfile;
                    String type = previousElement.getType();
                    boolean bl = isfile = !list[j].isDirectory();
                    if ((type.equals("universal.FileObject") || type.equals("universal.ArchiveFileObject")) && isfile || type.equals("universal.FolderObject") && !isfile) {
                        if (types != null) {
                            String thisType;
                            String attributes = previousElement.getAttribute(4);
                            if (attributes.indexOf(thisType = types[j]) != -1) {
                                filteredChildren.remove(list[j].getName());
                                found = true;
                            }
                        } else {
                            filteredChildren.remove(list[j].getName());
                            found = true;
                        }
                    }
                }
                DataElement deObj = null;
                if (!isHidden || this._showHidden) {
                    if (found) {
                        deObj = previousElement;
                    } else {
                        if (include == 8) {
                            deObj = file.isDirectory() ? ds.createObject(subject, FileDescriptors._deUniversalFolderObject, fileName) : (ArchiveHandlerManager.getInstance().isArchive(file) ? ds.createObject(subject, FileDescriptors._deUniversalArchiveFileObject, fileName) : ds.createObject(subject, FileDescriptors._deUniversalFileObject, fileName));
                        } else if (include == 4) {
                            deObj = ArchiveHandlerManager.getInstance().isArchive(file) ? ds.createObject(subject, FileDescriptors._deUniversalArchiveFileObject, fileName) : ds.createObject(subject, FileDescriptors._deUniversalFolderObject, fileName);
                        } else if (include == 2) {
                            deObj = ArchiveHandlerManager.getInstance().isArchive(file) ? ds.createObject(subject, FileDescriptors._deUniversalArchiveFileObject, fileName) : ds.createObject(subject, FileDescriptors._deUniversalFileObject, fileName);
                        }
                        if (deObj != null) {
                            if (queryType.equals("universal.FilterObject")) {
                                deObj.setAttribute(3, subject.getAttribute(3));
                            } else if (subject.getName().length() > 0) {
                                String valueStr = subject.getAttribute(3);
                                StringBuffer valueBuffer = new StringBuffer(valueStr);
                                if (this._isWindows && valueStr.endsWith("\\") || valueStr.endsWith("/") || subject.getName().startsWith("/")) {
                                    valueBuffer.append(subject.getName());
                                    deObj.setAttribute(3, valueBuffer.toString());
                                } else {
                                    valueBuffer.append(File.separatorChar);
                                    valueBuffer.append(subject.getName());
                                    deObj.setAttribute(3, valueBuffer.toString());
                                }
                            } else {
                                String valueStr = list[j].getParentFile().getAbsolutePath();
                                deObj.setAttribute(3, valueStr);
                            }
                        }
                    }
                    String properties = this.setProperties(file);
                    if (deObj != null) {
                        String newSource;
                        String oldSource;
                        if (types != null) {
                            oldSource = deObj.getAttribute(4);
                            if (!oldSource.startsWith(newSource = String.valueOf(properties) + "|" + types[j])) {
                                deObj.setAttribute(4, newSource);
                            }
                        } else {
                            oldSource = deObj.getAttribute(4);
                            if (!oldSource.startsWith(newSource = properties)) {
                                deObj.setAttribute(4, properties);
                            }
                        }
                    }
                }
                ++j;
            }
            if (!filteredChildren.isEmpty()) {
                String[] completeList = this._fileobj.list();
                Iterator myIterator = filteredChildren.keySet().iterator();
                while (myIterator.hasNext()) {
                    DataElement oldChild = (DataElement)filteredChildren.get(myIterator.next());
                    String oldName = oldChild.getName();
                    boolean foundOnSystem = false;
                    int c = 0;
                    while (c < completeList.length && !foundOnSystem) {
                        if (completeList[c].equals(oldName)) {
                            foundOnSystem = true;
                        }
                        ++c;
                    }
                    if (foundOnSystem) continue;
                    ds.deleteObject(subject, oldChild);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UniversalServerUtilities.logError("UniversalFileSystemMiner", "createDataElement failed with exception - isFile ", e, this._dataStore);
        }
    }
}

