/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem.subscriber;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.rse.internal.synchronize.RSEResourceVariantComparator;
import org.eclipse.rse.internal.synchronize.RSESyncUtils;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemProvider;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemRemoteTree;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSyncInfo;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ThreeWayRemoteTree;
import org.eclipse.team.core.variants.ThreeWaySubscriber;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.eclipse.team.internal.core.mapping.LocalResourceVariant;

public class FileSystemSubscriber
extends ThreeWaySubscriber {
    private static FileSystemSubscriber instance;

    public static synchronized FileSystemSubscriber getInstance() {
        if (instance == null) {
            instance = new FileSystemSubscriber();
        }
        return instance;
    }

    private FileSystemSubscriber() {
        super(new ThreeWaySynchronizer(new QualifiedName("org.eclipse.rse.internal.synchronize", "workpsace-sync")));
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) throws TeamException {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)RSESyncUtils.PROVIDER_ID);
        if (provider != null) {
            return ((FileSystemProvider)provider).getResourceVariant(resource, bytes);
        }
        return null;
    }

    protected ThreeWayRemoteTree createRemoteTree() {
        return new FileSystemRemoteTree(this);
    }

    public String getName() {
        return "Synchronize";
    }

    public IResource[] roots() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider;
            IProject project = projects[i];
            if (project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project, (String)RSESyncUtils.PROVIDER_ID)) != null) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void handleRootChanged(IResource resource, boolean added) {
        super.handleRootChanged(resource, added);
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        FileSystemResourceVariant rv = null;
        if (remote instanceof FileSystemResourceVariant) {
            rv = (FileSystemResourceVariant)remote;
            rv.synchRemoteFile();
        }
        if (base == null && local.exists()) {
            base = remote;
        }
        if (base != null) {
            boolean exists = rv.getFile().remoteFile.exists();
            if (!exists) {
                base = null;
            } else {
                SystemIFileProperties properties;
                long storedModificationTime;
                long remoteModificationTime = rv.lastModified();
                if (remoteModificationTime > (storedModificationTime = (properties = new SystemIFileProperties(local)).getRemoteFileTimeStamp())) {
                    properties.getDownloadFileTimeStamp();
                    local.getLocalTimeStamp();
                    base = new LocalResourceVariant(local);
                }
            }
        }
        FileSystemSyncInfo info = new FileSystemSyncInfo(local, base, remote, (IResourceVariantComparator)new RSEResourceVariantComparator(this.getSynchronizer()));
        info.init();
        return info;
    }

    public void makeInSync(IResource resource) throws TeamException {
        ThreeWaySynchronizer synchronizer = this.getSynchronizer();
        byte[] remoteBytes = synchronizer.getRemoteBytes(resource);
        if (remoteBytes == null) {
            if (!resource.exists()) {
                synchronizer.flush(resource, 0);
            }
        } else {
            synchronizer.setBaseBytes(resource, remoteBytes);
        }
    }

    public void markAsMerged(IResource resource, IProgressMonitor monitor) throws TeamException {
        this.makeInSync(resource);
        try {
            resource.touch(monitor);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }
}

