/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core;

import java.util.Properties;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;

public class HostMoveTest
extends RSEBaseConnectionTestCase {
    static final int NUMBER_OF_HOSTS = 6;
    private IHost[] hostArray = null;
    private ISystemRegistry registry = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.registry = RSECorePlugin.getTheSystemRegistry();
        this.createHosts();
    }

    protected void tearDown() throws Exception {
        this.deleteHosts();
        super.tearDown();
    }

    public void testMoveOneUp() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.checkPrecondition();
        IHost host = this.hostArray[5];
        IHost[] hosts = new IHost[]{host};
        this.registry.moveHosts("TestProfile", hosts, -1);
        HostMoveTest.assertEquals((int)4, (int)this.registry.getHostPosition(host));
        this.flushEventQueue();
        HostMoveTest.assertEquals((int)4, (int)this.registry.getHostPosition(host));
        this.registry.moveHosts("TestProfile", hosts, 1);
        HostMoveTest.assertEquals((int)5, (int)this.registry.getHostPosition(host));
    }

    public void testMoveManyUp() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.checkPrecondition();
        IHost[] hosts = new IHost[]{this.hostArray[5], this.hostArray[4]};
        this.registry.moveHosts("TestProfile", hosts, -2);
        HostMoveTest.assertEquals((int)3, (int)this.registry.getHostPosition(this.hostArray[5]));
        HostMoveTest.assertEquals((int)2, (int)this.registry.getHostPosition(this.hostArray[4]));
        this.flushEventQueue();
        HostMoveTest.assertEquals((int)3, (int)this.registry.getHostPosition(this.hostArray[5]));
        HostMoveTest.assertEquals((int)2, (int)this.registry.getHostPosition(this.hostArray[4]));
        this.registry.moveHosts("TestProfile", hosts, 2);
        HostMoveTest.assertEquals((int)5, (int)this.registry.getHostPosition(this.hostArray[5]));
        HostMoveTest.assertEquals((int)4, (int)this.registry.getHostPosition(this.hostArray[4]));
    }

    public void testMoveFirstUp() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.checkPrecondition();
        IHost host = this.hostArray[0];
        HostMoveTest.assertEquals((int)0, (int)this.registry.getHostPosition(host));
        IHost[] hosts = new IHost[]{host};
        this.registry.moveHosts("TestProfile", hosts, -1);
        HostMoveTest.assertEquals((int)0, (int)this.registry.getHostPosition(host));
    }

    public void testMoveOneDown() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.checkPrecondition();
        IHost host = this.hostArray[1];
        HostMoveTest.assertEquals((int)1, (int)this.registry.getHostPosition(host));
        IHost[] hosts = new IHost[]{host};
        this.registry.moveHosts("TestProfile", hosts, 1);
        HostMoveTest.assertEquals((int)2, (int)this.registry.getHostPosition(host));
        this.registry.moveHosts("TestProfile", hosts, -1);
        HostMoveTest.assertEquals((int)1, (int)this.registry.getHostPosition(host));
    }

    public void testMoveManyDown() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.checkPrecondition();
        IHost[] hosts = new IHost[]{this.hostArray[0], this.hostArray[2], this.hostArray[4]};
        HostMoveTest.assertEquals((int)0, (int)this.registry.getHostPosition(this.hostArray[0]));
        HostMoveTest.assertEquals((int)2, (int)this.registry.getHostPosition(this.hostArray[2]));
        HostMoveTest.assertEquals((int)4, (int)this.registry.getHostPosition(this.hostArray[4]));
        this.registry.moveHosts("TestProfile", hosts, 1);
        HostMoveTest.assertEquals((int)1, (int)this.registry.getHostPosition(this.hostArray[0]));
        HostMoveTest.assertEquals((int)3, (int)this.registry.getHostPosition(this.hostArray[2]));
        HostMoveTest.assertEquals((int)5, (int)this.registry.getHostPosition(this.hostArray[4]));
        this.registry.moveHosts("TestProfile", hosts, -1);
        HostMoveTest.assertEquals((int)0, (int)this.registry.getHostPosition(this.hostArray[0]));
        HostMoveTest.assertEquals((int)2, (int)this.registry.getHostPosition(this.hostArray[2]));
        HostMoveTest.assertEquals((int)4, (int)this.registry.getHostPosition(this.hostArray[4]));
    }

    public void testMoveLastDown() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.checkPrecondition();
        IHost host = this.hostArray[5];
        HostMoveTest.assertEquals((int)5, (int)this.registry.getHostPosition(host));
        IHost[] hosts = new IHost[]{host};
        this.registry.moveHosts("TestProfile", hosts, 1);
        HostMoveTest.assertEquals((int)5, (int)this.registry.getHostPosition(host));
    }

    public void testNoHost() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.checkPrecondition();
        IHost[] hosts = new IHost[]{};
        this.registry.moveHosts("TestProfile", hosts, -1);
    }

    private void createHosts() throws Exception {
        this.hostArray = new IHost[6];
        Properties properties = new Properties();
        properties.setProperty("profile_name", "TestProfile");
        properties.setProperty("address", "localhost");
        properties.setProperty("system_type_id", "org.eclipse.rse.systemtype.unix");
        properties.setProperty("userid", "userid");
        properties.setProperty("password", "password");
        IRSEConnectionProperties props = this.getConnectionManager().loadConnectionProperties(properties, false);
        int i = 0;
        while (i < this.hostArray.length) {
            String hostName = this.getHostName(i);
            properties.setProperty("name", hostName);
            this.hostArray[i] = this.getConnectionManager().findOrCreateConnection(props);
            HostMoveTest.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)this.hostArray[i]);
            ++i;
        }
    }

    private void deleteHosts() {
        int i = 1;
        while (i < this.hostArray.length) {
            this.registry.deleteHost(this.hostArray[i]);
            ++i;
        }
    }

    private void checkPrecondition() {
        int i = 0;
        while (i < this.hostArray.length) {
            HostMoveTest.assertEquals((String)"Precondition check failed", (int)i, (int)this.registry.getHostPosition(this.hostArray[i]));
            ++i;
        }
    }

    private String getHostName(int i) {
        String hostName = "TestHost" + Integer.toString(i);
        return hostName;
    }
}

