/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemOperationMonitor;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class DeleteThread
extends SecuredThread
implements ICancellableHandler {
    protected DataElement _theElement;
    protected DataElement _status;
    protected UniversalFileSystemMiner _miner;
    protected boolean _batch;
    protected boolean _isCancelled = false;
    protected boolean _isDone = false;
    protected SystemOperationMonitor systemOperationMonitor = new SystemOperationMonitor();
    public static final String CLASSNAME = "DeleteThread";

    public DeleteThread(DataElement theElement, UniversalFileSystemMiner miner, DataStore dataStore, boolean batch, DataElement status) {
        super(dataStore);
        this._theElement = theElement;
        this._miner = miner;
        this._status = status;
        this._batch = batch;
    }

    public void cancel() {
        this._isCancelled = true;
        if (this.systemOperationMonitor != null) {
            this.systemOperationMonitor.setCancelled(true);
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    public void run() {
        super.run();
        try {
            if (this._batch) {
                this.handleDeleteBatch();
            } else {
                this.handleDelete(this._theElement, this._status);
            }
        }
        catch (SystemMessageException systemMessageException) {
            this._status.setAttribute(4, "failed");
            this._miner.statusDone(this._status);
        }
        this._isDone = true;
    }

    private DataElement handleDeleteBatch() throws SystemMessageException {
        DataElement substatus = this._dataStore.createObject(null, "status", "substatus");
        int numOfSources = this._theElement.getNestedSize() - 2;
        int i = 0;
        while (i < numOfSources) {
            if (this.isCancelled()) {
                return this._miner.statusCancelled(this._status);
            }
            DataElement subject = this._miner.getCommandArgument(this._theElement, i + 1);
            this.handleDelete(subject, substatus);
            ++i;
        }
        this._status.setAttribute(4, substatus.getSource());
        return this._miner.statusDone(this._status);
    }

    private DataElement handleDelete(DataElement subject, DataElement thisStatus) throws SystemMessageException {
        String type = subject.getType();
        if (type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject")) {
            return this.handleDeleteFromArchive(subject, thisStatus);
        }
        File deleteObj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        DataElement deObj = null;
        boolean exists = deleteObj.exists();
        if (!exists) {
            String attributes = subject.getSource();
            String classification = "file";
            String[] str = attributes.split("\\|");
            if (str.length > 11) {
                classification = str[11];
            }
            if (classification.startsWith("broken symbolic link")) {
                exists = true;
            }
        }
        if (!exists) {
            thisStatus.setAttribute(4, "failed with does not exist|" + deleteObj.getAbsolutePath());
            UniversalServerUtilities.logError(CLASSNAME, "The object to delete does not exist", null, this._dataStore);
        } else {
            try {
                if (deleteObj.isFile()) {
                    if (!deleteObj.delete()) {
                        thisStatus.setAttribute(4, "failed|" + deleteObj.getAbsolutePath());
                    } else {
                        deObj = this._dataStore.find(subject, 2, subject.getName(), 1);
                        this._dataStore.deleteObject(subject, deObj);
                        thisStatus.setAttribute(4, "success|" + deleteObj.getAbsolutePath());
                    }
                    this._dataStore.refresh(subject);
                } else if (deleteObj.isDirectory()) {
                    this.deleteDir(deleteObj, thisStatus);
                    if (!deleteObj.delete()) {
                        thisStatus.setAttribute(4, "failed|" + deleteObj.getAbsolutePath());
                        UniversalServerUtilities.logError(CLASSNAME, "Deletion of dir fialed", null, this._dataStore);
                    } else {
                        this._dataStore.deleteObjects(subject);
                        DataElement parent = subject.getParent();
                        this._dataStore.deleteObject(parent, subject);
                        this._dataStore.refresh(parent);
                        thisStatus.setAttribute(4, "success|" + deleteObj.getAbsolutePath());
                    }
                } else {
                    if (!deleteObj.delete()) {
                        thisStatus.setAttribute(4, "failed|" + deleteObj.getAbsolutePath());
                        UniversalServerUtilities.logError(CLASSNAME, "The object to delete is neither a File or Folder! in handleDelete", null, this._dataStore);
                    } else {
                        deObj = this._dataStore.find(subject, 2, subject.getName(), 1);
                        this._dataStore.deleteObject(subject, deObj);
                        thisStatus.setAttribute(4, "success|" + deleteObj.getAbsolutePath());
                    }
                    this._dataStore.refresh(subject);
                }
            }
            catch (Exception e) {
                thisStatus.setAttribute(4, "failed with exception|" + deleteObj.getAbsolutePath());
                thisStatus.setAttribute(3, e.getLocalizedMessage());
                UniversalServerUtilities.logError(CLASSNAME, "Delete of the object failed", e, this._dataStore);
            }
        }
        this._dataStore.refresh(subject);
        return this._miner.statusDone(this._status);
    }

    public DataElement handleDeleteFromArchive(DataElement subject, DataElement status) throws SystemMessageException {
        String type = subject.getType();
        DataElement deObj = null;
        AbsoluteVirtualPath vpath = this._miner.getAbsoluteVirtualPath(subject);
        if (vpath != null) {
            ArchiveHandlerManager archiveHandlerManager = ArchiveHandlerManager.getInstance();
            ISystemArchiveHandler handler = archiveHandlerManager.getRegisteredHandler(new File(vpath.getContainingArchiveString()));
            if (handler == null || !handler.delete(vpath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor)) {
                status.setAttribute(4, "failed|" + vpath.toString());
                this._dataStore.refresh(subject);
                return this._miner.statusDone(status);
            }
            if (type.equals("universal.VirtualFileObject")) {
                deObj = this._dataStore.find(subject, 2, subject.getName(), 1);
                this._dataStore.deleteObject(subject, deObj);
                status.setAttribute(4, "success");
            } else if (type.equals("universal.VirtualFolderObject")) {
                this._dataStore.deleteObjects(subject);
                DataElement parent = subject.getParent();
                this._dataStore.deleteObject(parent, subject);
                this._dataStore.refresh(parent);
                status.setAttribute(4, "success");
            }
        }
        this._dataStore.refresh(subject);
        return this._miner.statusDone(status);
    }

    public void deleteDir(File fileObj, DataElement status) {
        try {
            File[] list = fileObj.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isFile()) {
                    if (!list[i].delete()) {
                        status.setAttribute(4, "failed");
                        UniversalServerUtilities.logWarning(CLASSNAME, "Deletion of dir failed", this._dataStore);
                    }
                } else {
                    this.deleteDir(list[i], status);
                    if (!list[i].delete()) {
                        status.setAttribute(4, "failed");
                        UniversalServerUtilities.logWarning(CLASSNAME, "Deletion of dir failed", this._dataStore);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            status.setAttribute(4, "failed with exception");
            status.setAttribute(3, e.getLocalizedMessage());
            UniversalServerUtilities.logError(CLASSNAME, "Deletion of dir failed", e, this._dataStore);
        }
    }
}

