/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.local;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.local.LocalConnectorService;
import org.eclipse.rse.internal.connectorservice.local.LocalConnectorServiceManager;
import org.eclipse.rse.internal.services.local.ILocalService;
import org.eclipse.rse.internal.services.local.processes.LocalProcessService;
import org.eclipse.rse.internal.subsystems.processes.local.LocalProcessAdapter;
import org.eclipse.rse.services.processes.IProcessService;
import org.eclipse.rse.subsystems.processes.core.subsystem.IHostProcessToRemoteProcessAdapter;
import org.eclipse.rse.subsystems.processes.servicesubsystem.ProcessServiceSubSystem;
import org.eclipse.rse.subsystems.processes.servicesubsystem.ProcessServiceSubSystemConfiguration;

public class LocalProcessSubSystemConfiguration
extends ProcessServiceSubSystemConfiguration {
    protected IHostProcessToRemoteProcessAdapter _hostProcessAdapter;

    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = ProcessServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        LocalConnectorService connectorService = (LocalConnectorService)this.getConnectorService(host);
        ProcessServiceSubSystem subsys = new ProcessServiceSubSystem(host, (IConnectorService)connectorService, this.getProcessService(host), this.getHostProcessAdapter());
        return subsys;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsSearch() {
        return false;
    }

    public boolean supportsEnvironmentVariablesPropertyPage() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }

    public boolean supportsSubSystemConnect() {
        return false;
    }

    public IConnectorService getConnectorService(IHost host) {
        return LocalConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public IProcessService createProcessService(IHost host) {
        return new LocalProcessService();
    }

    public IHostProcessToRemoteProcessAdapter getHostProcessAdapter() {
        if (this._hostProcessAdapter == null) {
            this._hostProcessAdapter = new LocalProcessAdapter();
        }
        return this._hostProcessAdapter;
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        LocalConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public Class getServiceImplType() {
        return ILocalService.class;
    }
}

