/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.ssh;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorServiceManager;
import org.eclipse.rse.internal.services.ssh.ISshService;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.terminal.SshTerminalService;
import org.eclipse.rse.internal.subsystems.shells.ssh.SshServiceCommandShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IServiceCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystemConfiguration;

public class SshShellSubSystemConfiguration
extends ShellServiceSubSystemConfiguration {
    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = ShellServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        SshConnectorService connectorService = (SshConnectorService)this.getConnectorService(host);
        ShellServiceSubSystem subsys = new ShellServiceSubSystem(host, (IConnectorService)connectorService, this.createShellService(host));
        return subsys;
    }

    public IShellService createShellService(IHost host) {
        SshConnectorService cserv = (SshConnectorService)this.getConnectorService(host);
        return (IShellService)new SshTerminalService((ISshSessionProvider)cserv).getAdapter(IShellService.class);
    }

    public IConnectorService getConnectorService(IHost host) {
        return SshConnectorServiceManager.getInstance().getConnectorService(host, ISshService.class);
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        SshConnectorServiceManager.getInstance().setConnectorService(host, ISshService.class, connectorService);
    }

    public Class getServiceImplType() {
        return ISshService.class;
    }

    public IServiceCommandShell createRemoteCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        return new SshServiceCommandShell(cmdSS, hostShell);
    }
}

