/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;

public class AbsoluteVirtualPath {
    protected AbsoluteVirtualPath _realPart;
    protected String _realPartName;
    protected String _virtualPart;
    protected boolean _isVirtual;
    protected String _absVirtualPath;

    public AbsoluteVirtualPath(String absolutePath) {
        String sep = "#virtual#/";
        this._absVirtualPath = ArchiveHandlerManager.cleanUpVirtualPath(absolutePath);
        int i = this._absVirtualPath.lastIndexOf(sep);
        if (i == -1) {
            this._absVirtualPath = absolutePath;
            this._virtualPart = "";
            this._realPartName = this._absVirtualPath;
            this._realPart = this;
            this._isVirtual = false;
        } else {
            this._virtualPart = this._absVirtualPath.substring(i + sep.length());
            this._realPartName = this._absVirtualPath.substring(0, i);
            this._realPart = new AbsoluteVirtualPath(this._realPartName);
            this._isVirtual = true;
        }
    }

    public boolean isVirtual() {
        return this._isVirtual;
    }

    public AbsoluteVirtualPath getContainingArchivePath() {
        return this._realPart;
    }

    public String getContainingArchiveString() {
        return this._realPartName;
    }

    public String getVirtualPart() {
        return this._virtualPart;
    }

    public String toString() {
        return this._absVirtualPath;
    }

    public void setVirtualPart(String newVirtualPart) {
        this._virtualPart = newVirtualPart;
        if (newVirtualPart == "") {
            int i = this._absVirtualPath.lastIndexOf("#virtual#/");
            this._absVirtualPath = this._absVirtualPath.substring(0, i);
            this._isVirtual = this._realPart._isVirtual;
        } else {
            this._absVirtualPath = String.valueOf(this._realPartName) + "#virtual#/" + newVirtualPart;
        }
    }

    public String getName() {
        return this._absVirtualPath.substring(this._absVirtualPath.lastIndexOf("/") + 1);
    }

    public String getPath() {
        String path = this._absVirtualPath.substring(0, this._absVirtualPath.lastIndexOf("/"));
        return path;
    }
}

