/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import org.eclipse.rse.internal.tests.framework.scripting.Script;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptParserMessage;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptParserMessageList;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptPause;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptShow;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptTell;
import org.eclipse.rse.internal.tests.framework.scripting.SyntaxNode;

public class ScriptParser {
    private ScriptParserMessageList messageList;
    private int lineNumber = 0;
    private String statement = null;
    private int statementLineNumber = 0;
    private BufferedReader in = null;
    private Stack nodes = null;

    public ScriptParser(ScriptParserMessageList messageList) {
        this.messageList = messageList;
    }

    public Script parse(InputStream inStream) throws IOException {
        this.lineNumber = 0;
        this.nodes = new Stack();
        this.nodes.push(new Script());
        this.in = new BufferedReader(new InputStreamReader(inStream));
        this.getStatement();
        while (this.statement != null) {
            this.parseStatement();
            this.getStatement();
        }
        Script result = null;
        SyntaxNode top = this.getCurrentNode();
        if (top != null) {
            if (top instanceof Script) {
                result = (Script)top;
            } else {
                this.messageList.add(new ScriptParserMessage(this.lineNumber, 2, "Incomplete statement"));
            }
        } else {
            this.messageList.add(new ScriptParserMessage(this.lineNumber, 2, "Internal error"));
        }
        return result;
    }

    private void parseStatement() {
        if (this.statement.startsWith("tell")) {
            this.parseTell();
        } else if (this.statement.startsWith("show")) {
            this.parseShow();
        } else if (this.statement.startsWith("pause")) {
            this.parsePause();
        } else {
            this.messageList.add(new ScriptParserMessage(this.lineNumber, 2, "Unrecognized statement"));
        }
    }

    private void parseTell() {
        String remark = this.statement.substring(4);
        remark = remark.trim();
        ScriptTell tell = new ScriptTell(remark, this.statementLineNumber);
        this.getCurrentNode().add(tell);
    }

    private void parseShow() {
        String imageName = this.statement.substring(4);
        imageName = imageName.trim();
        ScriptShow show = new ScriptShow(imageName, this.statementLineNumber);
        this.getCurrentNode().add(show);
    }

    private void parsePause() {
        String remark = this.statement.substring(5);
        remark = remark.trim();
        ScriptPause pause = new ScriptPause(remark, this.statementLineNumber);
        this.getCurrentNode().add(pause);
    }

    private void getStatement() throws IOException {
        this.statement = null;
        String line = this.in.readLine();
        while (line != null) {
            ++this.lineNumber;
            line = this.trimComment(line);
            line = line.trim();
            if (this.statement == null) {
                this.statementLineNumber = this.lineNumber;
                this.statement = line;
            } else {
                this.statement = String.valueOf(this.statement) + line;
            }
            if (!this.statement.endsWith("+")) break;
            this.statement = this.statement.substring(0, this.statement.length() - 1);
            line = this.in.readLine();
        }
    }

    private String trimComment(String line) {
        int n = line.indexOf(35);
        if (n >= 0) {
            line = line.substring(0, n);
        }
        return line;
    }

    private SyntaxNode getCurrentNode() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return (SyntaxNode)this.nodes.peek();
    }
}

