/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.launch.ui;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.launch.LocalTerminalLaunchUtilities;
import org.eclipse.tm.internal.terminal.local.process.LocalTerminalProcessRegistry;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalStillRunningDialog
extends MessageDialog
implements Runnable,
SelectionListener,
ILaunchesListener2 {
    private static final String TITLE = LocalTerminalMessages.warningTitleTerminalsStillRunning;
    private static final String MESSAGE = LocalTerminalMessages.warningMessageTerminalsStillRunning;
    private static final String QUIT_ANYWAY = LocalTerminalMessages.quitWorkbenchAnyway;
    private static final String DO_NOT_QUIT = LocalTerminalMessages.doNoQuitWorkbench;
    private static final String[] BUTTONS = new String[]{QUIT_ANYWAY, DO_NOT_QUIT};
    private static final RGB WHITE = new RGB(255, 255, 255);
    private static final int SCROLLABLE_HEIGHT = 100;
    private static final String IMG_LCL_TERMINATE = "IMG_LCL_TERMINATE";
    private ILaunch[] unterminated;
    private Composite content;

    private LocalTerminalStillRunningDialog(Shell parentShell, ILaunch[] launches) {
        super(parentShell, TITLE, null, MESSAGE, 4, BUTTONS, 0);
        this.setShellStyle(68656);
        this.unterminated = launches;
    }

    public static boolean openDialog(Shell shell, ILaunch[] launches) {
        LocalTerminalStillRunningDialog dialog = new LocalTerminalStillRunningDialog(shell, launches);
        dialog.setBlockOnOpen(true);
        try {
            LocalTerminalUtilities.LAUNCH_MANAGER.addLaunchListener((ILaunchesListener)dialog);
            boolean bl = dialog.open() == 0;
            return bl;
        }
        finally {
            LocalTerminalUtilities.LAUNCH_MANAGER.removeLaunchListener((ILaunchesListener)dialog);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(1).forceFocus();
    }

    protected Control createCustomArea(Composite parent) {
        ScrolledComposite scrollable = new ScrolledComposite(parent, 2560);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        scrollable.setLayoutData((Object)gridData);
        scrollable.setExpandHorizontal(true);
        scrollable.setExpandVertical(true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.content = new Composite((Composite)scrollable, 0);
        this.content.setLayout((Layout)gridLayout);
        this.content.setBackground(new Color((Device)parent.getDisplay(), WHITE));
        scrollable.setContent((Control)this.content);
        int index = 0;
        while (index < this.unterminated.length) {
            Composite item = this.createItem(this.content, this.unterminated[index]);
            item.setLayoutData((Object)new GridData(768));
            ++index;
        }
        this.content.pack();
        scrollable.setMinHeight(this.content.getBounds().height);
        return scrollable;
    }

    public void widgetSelected(SelectionEvent event) {
        ToolItem item = (ToolItem)event.widget;
        ILaunch launch = (ILaunch)item.getParent().getParent().getData();
        item.setEnabled(false);
        try {
            LocalTerminalProcessRegistry.addProcessBackToFinishedLaunch(launch);
            launch.terminate();
        }
        catch (DebugException exception) {
            Logger.logException((Exception)((Object)exception));
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void run() {
        boolean allLaunchesTerminated = true;
        Control[] child = this.content.getChildren();
        int numberOfChildren = child.length;
        int number = 0;
        while (number < numberOfChildren) {
            ILaunch launch = (ILaunch)child[number].getData();
            if (launch != null && launch.isTerminated()) {
                String exitValue;
                child[number].setData(null);
                try {
                    exitValue = String.valueOf(launch.getProcesses()[0].getExitValue());
                }
                catch (DebugException couldNotGetExitValue) {
                    exitValue = String.valueOf('(') + couldNotGetExitValue.getMessage() + ')';
                }
                Label label = (Label)((Composite)child[number]).getChildren()[1];
                String process = label.getText();
                process = NLS.bind((String)LocalTerminalMessages.terminatedProcess, (Object)process, (Object)exitValue);
                label.setText(process);
                ((Composite)child[number]).getChildren()[2].setEnabled(false);
            }
            if (child[number].getData() != null) {
                allLaunchesTerminated = false;
            }
            ++number;
        }
        if (allLaunchesTerminated) {
            this.setReturnCode(0);
            this.close();
        }
    }

    public void launchesTerminated(ILaunch[] terminated) {
        Display.getDefault().syncExec((Runnable)this);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    private Composite createItem(Composite parent, ILaunch launch) {
        Composite item = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        item.setData((Object)launch);
        item.setLayout((Layout)gridLayout);
        Image processImage = LocalTerminalLaunchUtilities.getImage(launch.getLaunchConfiguration());
        Label icon = new Label(item, 0);
        icon.setImage(processImage);
        Label label = new Label(item, 0);
        label.setText(launch.getLaunchConfiguration().getName());
        ToolItem stopButton = new ToolItem(new ToolBar(item, 0x800000), 8);
        stopButton.addSelectionListener((SelectionListener)this);
        Image deleteImage = DebugUITools.getImage((String)IMG_LCL_TERMINATE);
        stopButton.setImage(deleteImage);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return item;
    }
}

