/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.core.RSEWaitAndDispatchUtil;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.rse.tests.subsystems.files.FileServiceHelper;

public class ScpFileSubsystemTestCase
extends RSEBaseConnectionTestCase {
    private ISubSystem subSystem;
    private IHost connection;

    protected void tearDown() throws Exception {
        if (this.subSystem != null && this.subSystem.isConnected()) {
            this.subSystem.disconnect(true);
        }
        if (this.connection != null) {
            this.getConnectionManager().removeConnection(this.connection.getSystemProfileName(), this.connection.getName());
        }
        this.subSystem = null;
        this.connection = null;
        super.tearDown();
    }

    public void testScpAccessToRemoteHost() {
        if (this.isTestDisabled()) {
            return;
        }
        String propFileName = "scpConnection.properties";
        Exception exception = null;
        String cause = null;
        this.subSystem = null;
        try {
            this.subSystem = this.getScpSubSystem(propFileName);
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        ScpFileSubsystemTestCase.assertNull((String)("Failed to get scp.files subsystem! Possible cause: " + cause), (Object)exception);
        ScpFileSubsystemTestCase.assertNotNull((String)"No scp.files subystem", (Object)this.subSystem);
        ISubSystemConfiguration configuration = this.subSystem.getSubSystemConfiguration();
        ScpFileSubsystemTestCase.assertNotNull((String)"Failed to get scp.files subsystem configuration instance!", (Object)configuration);
        try {
            this.subSystem.connect(false, null);
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        ScpFileSubsystemTestCase.assertNull((String)("Failed to connect scp.files subsystem to host ! Possible cause: " + cause), (Object)exception);
        RSEWaitAndDispatchUtil.waitAndDispatch(10000L);
        if (!this.subSystem.isConnected()) {
            return;
        }
        FileServiceSubSystem inputFss = (FileServiceSubSystem)this.subSystem;
        try {
            IRemoteFile homeDirectory = inputFss.getRemoteFileObject(".", (IProgressMonitor)new NullProgressMonitor());
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation((IFileServiceSubSystem)inputFss, homeFolderName, baseFolderName, (IProgressMonitor)new NullProgressMonitor());
            IHostFile testDir = inputFss.getFileService().createFolder(homeFolderName, testFolderName.substring(testFolderName.lastIndexOf("/") + 1), (IProgressMonitor)new NullProgressMonitor());
            ScpFileSubsystemTestCase.assertTrue((testDir != null ? 1 : 0) != 0);
            IHostFile hostfile = inputFss.getFileService().createFile(testFolderName, "test-scp.txt", (IProgressMonitor)new NullProgressMonitor());
            ScpFileSubsystemTestCase.assertTrue((hostfile != null ? 1 : 0) != 0);
            inputFss.getFileService().delete(testFolderName, "test-scp.txt", (IProgressMonitor)new NullProgressMonitor());
            inputFss.getFileService().delete(testFolderName, testFolderName.substring(testFolderName.lastIndexOf("/") + 1), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
        }
    }

    protected ISubSystem getScpSubSystem(String propertiesFileName) throws Exception {
        if (propertiesFileName == null) {
            return null;
        }
        IHost host = this.getHost(propertiesFileName);
        return this.getConnectionManager().getFileSubSystem(host, "scp.files");
    }
}

