/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.ResourceBundle;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.rse.ui.ISystemMassager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SystemStringFieldEditor
extends FieldEditor {
    private Text textField;
    private String tip;
    private boolean isValid = true;
    private ModifyListener modifyListener = null;
    private boolean ignoreSelection = false;
    private ISystemValidator validator = null;
    private ISystemMassager massager = null;
    private Composite parentComposite;
    private String oldValue;
    private int numColumnsInParentComposite;

    private SystemStringFieldEditor() {
    }

    public SystemStringFieldEditor(String name, ResourceBundle rb, String rbKey, Composite parent) {
        super(name, rb.getString(String.valueOf(rbKey) + "label"), parent);
        this.oldValue = "";
        this.doOurFillIntoGrid();
        this.setToolTipText(rb.getString(String.valueOf(rbKey) + "tooltip"));
    }

    public void setValidator(ISystemValidator validator) {
        this.validator = validator;
        if (this.textField != null) {
            this.textField.setTextLimit(validator.getMaximumNameLength());
        }
    }

    public void setMassager(ISystemMassager massager) {
        this.massager = massager;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doStore() {
        String text = this.textField.getText();
        if (this.massager != null) {
            text = this.massager.massage(text);
            this.ignoreSelection = true;
            this.textField.setText(text);
            this.ignoreSelection = false;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), text);
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.initSelection(value);
        }
    }

    protected void doLoad() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.initSelection(value);
        }
    }

    private void initSelection(String value) {
        if (value != null) {
            this.ignoreSelection = true;
            this.textField.setText(value);
            this.oldValue = value;
            this.ignoreSelection = false;
        } else {
            this.oldValue = "";
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.parentComposite = parent;
        this.numColumnsInParentComposite = numColumns;
    }

    protected void doOurFillIntoGrid() {
        this.getLabelControl(this.parentComposite);
        this.textField = this.getTextControl(this.parentComposite);
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = this.numColumnsInParentComposite - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textField.setLayoutData((Object)gd);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected Text getTextControl() {
        return this.textField;
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = SystemWidgetHelpers.createTextField(parent, null);
            if (this.tip != null) {
                this.textField.setToolTipText(this.tip);
            }
            this.textField.addModifyListener(this.getModifyListener());
            if (this.validator != null) {
                this.textField.setTextLimit(this.validator.getMaximumNameLength());
            }
            this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    SystemStringFieldEditor.this.refreshValidState();
                }

                public void focusLost(FocusEvent e) {
                    SystemStringFieldEditor.this.clearErrorMessage();
                }
            });
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SystemStringFieldEditor.this.textField = null;
                }
            });
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public void setToolTipText(String tip) {
        if (this.textField != null) {
            this.textField.setToolTipText(tip);
        }
        this.tip = tip;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.createModifyListener();
        }
        return this.modifyListener;
    }

    protected void createModifyListener() {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Widget widget = event.widget;
                if (widget == SystemStringFieldEditor.this.textField) {
                    SystemStringFieldEditor.this.valueChanged();
                }
            }
        };
    }

    protected void validate() {
        if (!this.ignoreSelection) {
            this.setPresentsDefaultValue(false);
            if (this.validator != null) {
                String value = this.textField.getText();
                String errmsg = this.validator.isValid(value);
                if (errmsg != null) {
                    this.showErrorMessage(errmsg);
                } else {
                    this.clearErrorMessage();
                }
                this.isValid = errmsg == null;
            }
        }
        this.ignoreSelection = false;
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        String newValue = this.textField.getText();
        this.fireValueChanged("field_editor_value", this.oldValue, newValue);
        this.oldValue = newValue;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.validate();
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }
}

