/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.wizards;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.wizards.SystemNewFileWizard;
import org.eclipse.rse.internal.files.ui.wizards.SystemNewFolderWizardMainPage;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;

public class SystemNewFolderWizard
extends AbstractSystemWizard {
    private SystemNewFolderWizardMainPage mainPage;
    private static final String CLASSNAME = "SystemNewFolderWizard";

    public SystemNewFolderWizard() {
        super(FileResources.RESID_NEWFOLDER_TITLE, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newfolder_wizBannerIcon"));
    }

    public void addPages() {
        try {
            this.mainPage = this.createMainPage();
            this.addPage((IWizardPage)this.mainPage);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"New File: Error in createPages: ", (Throwable)exc);
        }
    }

    protected SystemNewFolderWizardMainPage createMainPage() {
        IRemoteFile[] parentFolders = null;
        SystemMessage errMsg = null;
        try {
            parentFolders = this.getParentFolders();
        }
        catch (SystemMessageException exc) {
            errMsg = exc.getSystemMessage();
        }
        this.mainPage = new SystemNewFolderWizardMainPage((Wizard)this, parentFolders);
        if (errMsg != null) {
            this.mainPage.setErrorMessage(errMsg);
        }
        return this.mainPage;
    }

    public boolean performFinish() {
        boolean ok = true;
        if (this.mainPage.performFinish()) {
            SimpleSystemMessage msg = null;
            IRemoteFile parentFolder = this.mainPage.getParentFolder();
            String name = this.mainPage.getfolderName();
            String absName = SystemNewFileWizard.getNewAbsoluteName(parentFolder, name);
            if (!parentFolder.exists()) {
                String msgTxt = NLS.bind((String)FileResources.FILEMSG_FILE_NOTFOUND, (Object)parentFolder.getAbsolutePath());
                msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1006", 4, msgTxt);
                this.mainPage.setMessage((SystemMessage)msg);
                return false;
            }
            if (this.isInputAFilter() && !this.meetsFilterCriteria(this.getSelectedFilterReference(), parentFolder, absName)) {
                return false;
            }
            String msgTxt = NLS.bind((String)FileResources.MSG_CREATEFOLDERGENERIC_PROGRESS, (Object)name);
            CreateNewFolderJob createNewFolderJob = new CreateNewFolderJob(parentFolder, name, absName, msgTxt);
            createNewFolderJob.schedule();
        }
        return ok;
    }

    protected boolean meetsFilterCriteria(ISystemFilterReference selectedFilterRef, IRemoteFile parentFolder, String newAbsName) {
        boolean meets = false;
        ISystemFilter filter = selectedFilterRef.getReferencedFilter();
        String[] strings = filter.getFilterStrings();
        if (strings != null) {
            int idx = 0;
            while (!meets && idx < strings.length) {
                String filterString = strings[idx];
                if (filterString.indexOf("/ns") == -1) {
                    meets = strings.length > 0 && !filterString.startsWith(parentFolder.getAbsolutePath()) ? filterString.equals("./*") : true;
                }
                ++idx;
            }
        }
        if (!meets) {
            String msgTxt = FileResources.FILEMSG_CREATE_RESOURCE_NOTVISIBLE;
            String msgDetails = FileResources.FILEMSG_CREATE_RESOURCE_NOTVISIBLE_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1310", 2, msgTxt, msgDetails);
            SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), (SystemMessage)msg);
            if (msgDlg.openQuestionNoException()) {
                meets = true;
            }
        }
        return meets;
    }

    protected boolean isInputAFilter() {
        return this.getInputObject() instanceof ISystemFilterReference;
    }

    protected ISystemFilterReference getSelectedFilterReference() {
        if (this.isInputAFilter()) {
            return (ISystemFilterReference)this.getInputObject();
        }
        return null;
    }

    protected IRemoteFile[] getParentFolders() throws SystemMessageException {
        Object input = this.getInputObject();
        if (input instanceof IRemoteFile) {
            return new IRemoteFile[]{(IRemoteFile)input};
        }
        if (input instanceof ISystemFilterReference) {
            return SystemNewFileWizard.getParentFolders((ISystemFilterReference)input);
        }
        return null;
    }

    private class CreateNewFolderJob
    extends WorkspaceJob {
        IRemoteFile parentFolder;
        String name;
        String absName;
        String message;

        public CreateNewFolderJob(IRemoteFile parentFolder, String name, String absName, String message) {
            super(message);
            this.parentFolder = null;
            this.name = null;
            this.absName = null;
            this.message = null;
            this.parentFolder = parentFolder;
            this.name = name;
            this.absName = absName;
            this.message = message;
            this.setUser(true);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            boolean ok = true;
            IStatus status = Status.OK_STATUS;
            IRemoteFileSubSystem rfss = this.parentFolder.getParentRemoteFileSubSystem();
            IRemoteFile newFolder = null;
            try {
                IRemoteFile newFolderPath = rfss.getRemoteFileObject(this.absName, monitor);
                newFolder = rfss.createFolder(newFolderPath, monitor);
            }
            catch (RemoteFileIOException remoteFileIOException) {
                ok = false;
                SystemBasePlugin.logDebugMessage((String)"SystemNewFolderWizard:", (String)(" Creating remote folder " + this.absName + " failed with RemoteFileIOException "));
                String msgTxt = FileResources.FILEMSG_CREATE_FOLDER_FAILED_EXIST;
                String msgDetails = NLS.bind((String)FileResources.FILEMSG_CREATE_FOLDER_FAILED_EXIST_DETAILS, (Object)this.absName);
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1309", 4, msgTxt, msgDetails);
                SystemMessageDialog.displayErrorMessage(null, (SystemMessage)msg);
            }
            catch (RemoteFileSecurityException remoteFileSecurityException) {
                ok = false;
                String msgTxt = FileResources.FILEMSG_CREATE_FOLDER_FAILED;
                String msgDetails = FileResources.FILEMSG_CREATE_FOLDER_FAILED_DETAILS;
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1304", 4, msgTxt, msgDetails);
                SystemBasePlugin.logDebugMessage((String)"SystemNewFolderWizard:", (String)(" Creating remote folder " + this.absName + " failed with RemoteFileSecurityException "));
                SystemMessageDialog.displayErrorMessage(null, (SystemMessage)msg);
            }
            catch (SystemMessageException exc) {
                ok = false;
                if (monitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                }
                SystemMessageDialog.displayErrorMessage(null, (SystemMessage)exc.getSystemMessage());
            }
            if (ok) {
                SystemNewFileWizard.updateGUI(this.parentFolder, newFolder, SystemNewFolderWizard.this.getViewer(), SystemNewFolderWizard.this.isInputAFilter(), SystemNewFolderWizard.this.getSelectedFilterReference());
            }
            return status;
        }
    }
}

