/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.scratchpad;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.internal.ui.view.scratchpad.ClearAction;
import org.eclipse.rse.internal.ui.view.scratchpad.ClearSelectedAction;
import org.eclipse.rse.internal.ui.view.scratchpad.SystemScratchpadView;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.actions.SystemRefreshAction;
import org.eclipse.rse.ui.internal.model.SystemRegistryUI;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.ViewPart;

public class SystemScratchpadViewPart
extends ViewPart
implements ISelectionListener,
ISelectionChangedListener,
ISystemResourceChangeListener,
ISystemShellProvider,
ISystemMessageLine,
IRSEViewPart {
    private SystemScratchpadView _viewer;
    private SystemCopyToClipboardAction _copyAction;
    private SystemPasteFromClipboardAction _pasteAction;
    private SystemCommonDeleteAction _deleteAction;
    private SystemCommonRenameAction _renameAction;
    private ClearAction _clearAction;
    private ClearSelectedAction _clearSelectionAction;
    private SystemRefreshAction _refreshAction;
    private String _message;
    private String _errorMessage;
    private SystemMessage sysErrorMessage;
    private IStatusLineManager _statusLine = null;
    public static final String ID = "org.eclipse.rse.ui.view.scratchpad.SystemScratchpadViewPart";
    static /* synthetic */ Class class$0;

    public void setFocus() {
        this._viewer.getControl().setFocus();
    }

    public SystemScratchpadView getViewer() {
        return this._viewer;
    }

    public Viewer getRSEViewer() {
        return this._viewer;
    }

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 99074);
        this._viewer = new SystemScratchpadView(tree, this);
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)this);
        this._viewer.addSelectionChangedListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this._viewer);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SystemScratchpadViewPart.this.handleDoubleClick(event);
            }
        });
        this.fillLocalToolBar();
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        CellEditorActionHandler editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this._copyAction = new SystemCopyToClipboardAction(this._viewer.getShell(), null);
        this._pasteAction = new SystemPasteFromClipboardAction(this._viewer.getShell(), null);
        this._deleteAction = new SystemCommonDeleteAction(this._viewer.getShell(), this._viewer);
        this._renameAction = new SystemCommonRenameAction(this._viewer.getShell(), this._viewer);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this._renameAction);
        editorActionHandler.setCopyAction((IAction)this._copyAction);
        editorActionHandler.setPasteAction((IAction)this._pasteAction);
        editorActionHandler.setDeleteAction((IAction)this._deleteAction);
        registry.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        SystemWidgetHelpers.setHelp(this._viewer.getControl(), "org.eclipse.rse.ui.scrp0000");
        this.setInput(SystemRegistryUI.getInstance().getSystemScratchPad());
        this.getSite().registerContextMenu(this._viewer.getContextMenuManager(), (ISelectionProvider)this._viewer);
        this.getSite().registerContextMenu("org.eclipse.rse.views.common", this._viewer.getContextMenuManager(), (ISelectionProvider)this._viewer);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
    }

    public void dispose() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener((ISelectionListener)this);
        this._viewer.removeSelectionChangedListener(this);
        RSECorePlugin.getTheSystemRegistry().removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        if (this._viewer != null) {
            this._viewer.dispose();
        }
        super.dispose();
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISystemViewElementAdapter adapter;
        ITreeSelection s = (ITreeSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null || !(element instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
            if (adapter.hasChildren((IAdaptable)element)) {
                TreePath[] paths = s.getPathsFor(element);
                if (paths == null || paths.length == 0 || paths[0] == null) {
                    return;
                }
                TreePath elementPath = paths[0];
                if (this._viewer.getExpandedState(elementPath)) {
                    this._viewer.collapseToLevel(elementPath, 1);
                } else {
                    this._viewer.expandToLevel(elementPath, 1);
                }
            } else {
                adapter.handleDoubleClick(element);
            }
        }
    }

    public void updateActionStates() {
        if (this._clearAction == null) {
            this.fillLocalToolBar();
        }
        this._clearAction.checkEnabledState();
        this._clearSelectionAction.checkEnabledState();
    }

    public void fillLocalToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        IMenuManager menuMgr = actionBars.getMenuManager();
        if (this._clearAction == null) {
            this._clearAction = new ClearAction(this._viewer);
            this._clearSelectionAction = new ClearSelectedAction(this._viewer);
        }
        if (this._refreshAction == null) {
            this._refreshAction = new SystemRefreshAction(this.getShell());
            this._refreshAction.setId(ActionFactory.REFRESH.getId());
            this._refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
            this._refreshAction.setSelectionProvider(this._viewer);
        }
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this._refreshAction);
        this.updateActionStates();
        this._statusLine = actionBars.getStatusLineManager();
        this.addToolBarItems(toolBarManager);
        this.addToolBarMenuItems(menuMgr);
    }

    private void addToolBarMenuItems(IMenuManager menuManager) {
        menuManager.removeAll();
        menuManager.add((IAction)this._refreshAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this._clearSelectionAction);
        menuManager.add((IAction)this._clearAction);
    }

    private void addToolBarItems(IToolBarManager toolBarManager) {
        toolBarManager.removeAll();
        toolBarManager.add((IAction)this._refreshAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this._clearSelectionAction);
        toolBarManager.add((IAction)this._clearAction);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        this.updateActionStates();
        IStructuredSelection sel = (IStructuredSelection)e.getSelection();
        this._copyAction.setEnabled(this._copyAction.updateSelection(sel));
        this._pasteAction.setEnabled(this._pasteAction.updateSelection(sel));
        this._deleteAction.setEnabled(this._deleteAction.updateSelection(sel));
    }

    public void setInput(IAdaptable object) {
        this.setInput(object, null);
    }

    public void setInput(IAdaptable object, String[] filters) {
        if (this._viewer != null && object != null) {
            this._viewer.setInput(object);
            this.updateActionStates();
        }
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Object parent = event.getParent();
        event.getType();
        if (parent == this._viewer.getInput()) {
            this.updateActionStates();
        }
    }

    public Shell getShell() {
        return this._viewer.getShell();
    }

    public void clearErrorMessage() {
        this._errorMessage = null;
        this.sysErrorMessage = null;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(this._errorMessage);
        }
    }

    public void clearMessage() {
        this._message = null;
        if (this._statusLine != null) {
            this._statusLine.setMessage(this._message);
        }
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getMessage() {
        return this._message;
    }

    public void setErrorMessage(String message) {
        this._errorMessage = message;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this._message = message;
        if (this._statusLine != null) {
            this._statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }
}

