/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.menus;

import java.util.ArrayList;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.text.TMPresentationReconciler;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.service.prefs.BackingStoreException;

public final class ThemeContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private @Nullable IHandlerService handlerService;

    public void initialize(@Nullable IServiceLocator serviceLocator) {
        assert (serviceLocator != null);
        this.handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
    }

    protected IContributionItem[] getContributionItems() {
        IEditorPart editorPart;
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        if (this.handlerService != null && (editorPart = ThemeContribution.getActivePart(this.handlerService.getCurrentState())) != null) {
            IGrammar grammar;
            IThemeManager manager = TMUIPlugin.getThemeManager();
            boolean dark = manager.isDarkEclipseTheme();
            ITheme[] themes = manager.getThemes();
            TMPresentationReconciler presentationReconciler = TMPresentationReconciler.getTMPresentationReconciler(editorPart);
            if (presentationReconciler != null && (grammar = presentationReconciler.getGrammar()) != null) {
                String scopeName = grammar.getScopeName();
                ITheme selectedTheme = manager.getThemeForScope(scopeName, dark);
                ITheme[] iThemeArray = themes;
                int n = themes.length;
                int n2 = 0;
                while (n2 < n) {
                    ITheme theme = iThemeArray[n2];
                    Action action = this.createAction(scopeName, theme, dark);
                    if (theme.equals(selectedTheme)) {
                        action.setChecked(true);
                    }
                    ActionContributionItem item = new ActionContributionItem((IAction)action);
                    items.add(item);
                    ++n2;
                }
            }
        }
        return (IContributionItem[])items.toArray(IContributionItem[]::new);
    }

    private Action createAction(final String scopeName, final ITheme theme, final boolean whenDark) {
        return new Action(theme.getName()){

            public void run() {
                IThemeManager manager = TMUIPlugin.getThemeManager();
                ThemeAssociation association = new ThemeAssociation(theme.getId(), scopeName, whenDark);
                manager.registerThemeAssociation(association);
                try {
                    manager.save();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private static @Nullable IEditorPart getActivePart(@Nullable IEvaluationContext context) {
        if (context == null) {
            return null;
        }
        Object activePart = context.getVariable("activePart");
        if (activePart instanceof IEditorPart) {
            return (IEditorPart)activePart;
        }
        return null;
    }
}

