/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CommentSupport;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleLineCommentHandler
extends AbstractHandler {
    public static final String TOGGLE_LINE_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.toggleLineCommentCommand";
    public static final String ADD_BLOCK_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.addBlockCommentCommand";
    public static final String REMOVE_BLOCK_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.removeBlockCommentCommand";

    private static <T> @Nullable T adapt(@Nullable Object sourceObject, Class<T> adapter) {
        return (T)Adapters.adapt((Object)sourceObject, adapter);
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        block56: {
            if (event == null) {
                return null;
            }
            IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            ITextEditor editor = ToggleLineCommentHandler.adapt(part, ITextEditor.class);
            if (editor == null) {
                return null;
            }
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (!(selection instanceof ITextSelection var5_6)) break block56;
            IEditorInput input = editor.getEditorInput();
            IDocumentProvider docProvider = editor.getDocumentProvider();
            if (docProvider == null || input == null) {
                return null;
            }
            IDocument document = docProvider.getDocument((Object)input);
            if (document == null) {
                return null;
            }
            try {
                info = ContentTypeHelper.findContentTypes((IDocument)document);
                if (info == null) {
                    return null;
                }
            }
            catch (CoreException e) {
                return null;
            }
            IContentType[] contentTypes = info.getContentTypes();
            Command command = event.getCommand();
            CommentSupport commentSupport = this.getCommentSupport(contentTypes);
            if (commentSupport == null) {
                return null;
            }
            if (!this.isValid(commentSupport, command)) {
                return null;
            }
            IRewriteTarget target = ToggleLineCommentHandler.adapt(editor, IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                try {
                    switch (command.getId()) {
                        case "org.eclipse.tm4e.languageconfiguration.toggleLineCommentCommand": {
                            String lineComment = commentSupport.getLineComment();
                            if (lineComment != null && !lineComment.isEmpty()) {
                                this.updateLineComment(document, (ITextSelection)textSelection, lineComment, editor);
                                break;
                            }
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (blockComment != null) {
                                Set<Integer> lines = this.computeLines((ITextSelection)textSelection, document);
                                int selectionStartLine = textSelection.getStartLine();
                                int selectionEndLine = textSelection.getEndLine();
                                int[] lineRange = new int[]{-1, -1};
                                lines = lines.stream().filter(l -> l >= selectionStartLine && l <= selectionEndLine && !TextUtils.isBlankLine(document, l)).map(l -> {
                                    nArray[0] = lineRange[0] == -1 || lineRange[0] > l ? l : lineRange[0];
                                    nArray[1] = lineRange[1] < l ? l : lineRange[1];
                                    return l;
                                }).collect(Collectors.toSet());
                                int first = lineRange[0];
                                int last = lineRange[1];
                                boolean isToAdd = false;
                                int shiftOffset = 0;
                                int shiftLength = 0;
                                for (int line : lines) {
                                    Set<ITypedRegion> existingBlocks = this.getBlockCommentPartsForLine(document, line, commentSupport);
                                    if (line == first) {
                                        isToAdd = existingBlocks.isEmpty();
                                    }
                                    int deletedChars = 0;
                                    for (ITypedRegion existingBlock : existingBlocks) {
                                        existingBlock = new TypedRegion(existingBlock.getOffset() - deletedChars, existingBlock.getLength(), existingBlock.getType());
                                        document.replace(existingBlock.getOffset(), existingBlock.getLength(), "");
                                        deletedChars += existingBlock.getLength();
                                        int selectionStart = textSelection.getOffset() + shiftOffset;
                                        int selectionLength = textSelection.getLength() + shiftLength;
                                        int selectionEnd = selectionStart + selectionLength;
                                        if (ToggleLineCommentHandler.isBeforeSelection((IRegion)existingBlock, selectionStart)) {
                                            shiftOffset -= existingBlock.getLength();
                                            continue;
                                        }
                                        if (ToggleLineCommentHandler.isInsideSelection((IRegion)existingBlock, selectionStart, selectionEnd)) {
                                            shiftLength -= existingBlock.getLength();
                                            continue;
                                        }
                                        if (blockComment.open.equals(existingBlock.getType()) && ToggleLineCommentHandler.isSelectioinStartOverlaps((IRegion)existingBlock, selectionStart)) {
                                            int diff = selectionStart - existingBlock.getOffset();
                                            shiftOffset -= diff;
                                            int lengthDiff = existingBlock.getLength() - diff;
                                            shiftLength -= lengthDiff <= selectionLength ? lengthDiff : selectionLength;
                                            continue;
                                        }
                                        if (ToggleLineCommentHandler.isSelectioinEndOverlaps((IRegion)existingBlock, selectionEnd)) {
                                            int lengthDiff = selectionEnd - existingBlock.getOffset();
                                            if (ToggleLineCommentHandler.isSelectioinEndOverlaps((IRegion)existingBlock, selectionStart)) {
                                                shiftOffset -= lengthDiff;
                                            }
                                            shiftLength -= lengthDiff <= selectionLength ? lengthDiff : selectionLength;
                                            continue;
                                        }
                                        if (!ToggleLineCommentHandler.isSelectionInside((IRegion)existingBlock, selectionStart, selectionEnd)) continue;
                                        shiftLength -= selectionLength;
                                        shiftOffset -= selectionStart - existingBlock.getOffset();
                                    }
                                }
                                textSelection = new TextSelection(textSelection.getOffset() + shiftOffset, textSelection.getLength() + shiftLength);
                                shiftLength = 0;
                                shiftOffset = 0;
                                if (isToAdd) {
                                    for (int line : lines) {
                                        int lineOffset = document.getLineOffset(line);
                                        int lineLength = document.getLineLength(line);
                                        String lineDelimiter = document.getLineDelimiter(line);
                                        TextSelection range = new TextSelection(document, lineOffset, lineDelimiter != null ? lineLength - lineDelimiter.length() : lineLength);
                                        this.addBlockComment(document, (ITextSelection)range, blockComment, true, editor);
                                        if (line == first) {
                                            if (range.getOffset() <= textSelection.getOffset()) {
                                                shiftOffset += blockComment.open.length();
                                            }
                                            if (range.getOffset() + range.getLength() < textSelection.getOffset() + textSelection.getLength()) {
                                                shiftLength += blockComment.close.length();
                                            }
                                        }
                                        if (line == last && line != first) {
                                            int thisShiftLength = shiftLength;
                                            if (range.getOffset() <= textSelection.getOffset() + shiftOffset + textSelection.getLength() + thisShiftLength) {
                                                shiftLength += blockComment.open.length();
                                            }
                                            if (range.getOffset() + range.getLength() < textSelection.getOffset() + shiftOffset + textSelection.getLength() + thisShiftLength) {
                                                shiftLength += blockComment.close.length();
                                            }
                                        }
                                        if (line == first || line == last) continue;
                                        shiftLength += blockComment.open.length() + blockComment.close.length();
                                    }
                                    textSelection = new TextSelection(textSelection.getOffset() + shiftOffset, textSelection.getLength() + shiftLength);
                                }
                                editor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
                            }
                            break;
                        }
                        case "org.eclipse.tm4e.languageconfiguration.addBlockCommentCommand": {
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (blockComment != null && !blockComment.open.isEmpty() && !blockComment.close.isEmpty()) {
                                IRegion existingBlock = this.getBlockComment(document, (ITextSelection)textSelection, commentSupport);
                                if (existingBlock == null) {
                                    this.addBlockComment(document, (ITextSelection)textSelection, blockComment, false, editor);
                                }
                            } else {
                                String lineComment = commentSupport.getLineComment();
                                if (lineComment != null && !lineComment.isEmpty()) {
                                    this.updateLineComment(document, (ITextSelection)textSelection, lineComment, editor);
                                }
                            }
                            break;
                        }
                        case "org.eclipse.tm4e.languageconfiguration.removeBlockCommentCommand": {
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (blockComment != null && !blockComment.open.isEmpty() && !blockComment.close.isEmpty()) {
                                IRegion existingBlock = this.getBlockComment(document, (ITextSelection)textSelection, commentSupport);
                                if (existingBlock != null) {
                                    this.removeBlockComment(document, (ITextSelection)textSelection, existingBlock, blockComment, editor);
                                }
                                break;
                            }
                            String lineComment = commentSupport.getLineComment();
                            if (lineComment == null || lineComment.isEmpty()) break;
                            this.updateLineComment(document, (ITextSelection)textSelection, lineComment, editor);
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        return null;
    }

    private static boolean isBeforeSelection(IRegion region, int selectionStart) {
        int regionStart = region.getOffset();
        int regionEnd = regionStart + region.getLength();
        return regionStart < selectionStart && regionEnd <= selectionStart;
    }

    private static boolean isSelectioinStartOverlaps(IRegion region, int selectionStart) {
        int regionStart = region.getOffset();
        int regionEnd = regionStart + region.getLength();
        return selectionStart >= regionStart && selectionStart < regionEnd;
    }

    private static boolean isSelectioinEndOverlaps(IRegion region, int selectionEnd) {
        int regionStart = region.getOffset();
        int regionEnd = regionStart + region.getLength();
        return selectionEnd > regionStart && selectionEnd < regionEnd;
    }

    private static boolean isInsideSelection(IRegion region, int selectionStart, int selectionEnd) {
        int regionStart = region.getOffset();
        int regionEnd = regionStart + region.getLength();
        return selectionStart <= regionStart && selectionEnd >= regionEnd;
    }

    private static boolean isSelectionInside(IRegion region, int selectionStart, int selectionEnd) {
        int regionStart = region.getOffset();
        int regionEnd = regionStart + region.getLength();
        return selectionStart >= regionStart && selectionEnd < regionEnd;
    }

    private Set<Integer> computeLines(ITextSelection textSelection, IDocument document) throws BadLocationException {
        if (textSelection instanceof IMultiTextSelection var4_4) {
            v0 = multiSelection.getRegions();
        } else {
            IRegion[] iRegionArray = new IRegion[1];
            v0 = iRegionArray;
            iRegionArray[0] = new Region(textSelection.getOffset(), textSelection.getLength());
        }
        IRegion[] regions = v0;
        HashSet<Integer> lines = new HashSet<Integer>();
        IRegion[] iRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion region = iRegionArray[n2];
            int lineFrom = document.getLineOfOffset(region.getOffset());
            int lineTo = document.getLineOfOffset(region.getOffset() + region.getLength());
            int line = lineFrom;
            while (line <= lineTo) {
                lines.add(line);
                ++line;
            }
            ++n2;
        }
        return lines;
    }

    private boolean isValid(CommentSupport commentSupport, Command command) {
        String lineComment = commentSupport.getLineComment();
        CharacterPair blockComment = commentSupport.getBlockComment();
        if ((lineComment == null || lineComment.isEmpty()) && (blockComment == null || blockComment.open.isEmpty() || blockComment.close.isEmpty())) {
            return false;
        }
        return TOGGLE_LINE_COMMENT_COMMAND_ID.equals(command.getId()) || ADD_BLOCK_COMMENT_COMMAND_ID.equals(command.getId()) || REMOVE_BLOCK_COMMENT_COMMAND_ID.equals(command.getId());
    }

    private @Nullable CommentSupport getCommentSupport(IContentType[] contentTypes) {
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CommentSupport commentSupport;
            IContentType contentType = iContentTypeArray[n2];
            if (registry.shouldComment(contentType) && (commentSupport = registry.getCommentSupport(contentType)) != null) {
                return commentSupport;
            }
            ++n2;
        }
        return null;
    }

    private void updateLineComment(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        if (this.areLinesCommented(document, selection, comment)) {
            this.removeLineComments(document, selection, comment, editor);
        } else {
            this.addLineComments(document, selection, comment, editor);
        }
    }

    private boolean areLinesCommented(IDocument document, ITextSelection selection, String comment) throws BadLocationException {
        int lineNumber = selection.getStartLine();
        while (lineNumber <= selection.getEndLine()) {
            IRegion lineRegion = document.getLineInformation(lineNumber);
            if (!document.get(lineRegion.getOffset(), lineRegion.getLength()).trim().startsWith(comment)) {
                return false;
            }
            ++lineNumber;
        }
        return true;
    }

    private Set<ITypedRegion> getBlockCommentPartsForLine(IDocument document, int line, CommentSupport commentSupport) throws BadLocationException {
        CharacterPair blockComment = commentSupport.getBlockComment();
        if (blockComment == null) {
            return Collections.emptySet();
        }
        TreeSet<ITypedRegion> result = new TreeSet<ITypedRegion>((r1, r2) -> r1.getOffset() - r2.getOffset());
        int lineStart = document.getLineOffset(line);
        int lineLength = document.getLineLength(line);
        String open = blockComment.open;
        String close = blockComment.close;
        String lineText = document.get(lineStart, lineLength);
        int index = 0;
        while (true) {
            int indexOpen = lineText.indexOf(open, index);
            int indexClose = lineText.indexOf(close, index);
            if (indexOpen != -1 && (indexClose == -1 || indexOpen < indexClose)) {
                result.add((ITypedRegion)new TypedRegion(lineStart + indexOpen, open.length(), open));
                index = indexOpen + open.length();
                continue;
            }
            if (indexClose == -1) break;
            result.add((ITypedRegion)new TypedRegion(lineStart + indexClose, close.length(), close));
            index = indexClose + close.length();
        }
        return result;
    }

    private @Nullable IRegion getBlockComment(IDocument document, ITextSelection selection, CommentSupport commentSupport) throws BadLocationException {
        if (selection.getText() == null) {
            return null;
        }
        CharacterPair blockComment = commentSupport.getBlockComment();
        if (blockComment == null) {
            return null;
        }
        String text = document.get();
        String open = blockComment.open;
        String close = blockComment.close;
        int selectionStart = selection.getOffset();
        int selectionEnd = selectionStart + selection.getLength();
        int openOffset = TextUtils.startIndexOfOffsetTouchingString(text, selectionStart, open);
        if (openOffset == -1 && ((openOffset = text.lastIndexOf(open, selectionStart)) == -1 || openOffset < document.getLineOffset(selection.getStartLine()))) {
            return null;
        }
        int closeOffset = TextUtils.startIndexOfOffsetTouchingString(text, selectionEnd, close);
        if (closeOffset == -1 || closeOffset < openOffset + open.length()) {
            closeOffset = text.indexOf(close, selectionEnd);
            IRegion endLineRegion = document.getLineInformation(document.getLineOfOffset(selectionEnd));
            if (openOffset == -1 || closeOffset < openOffset + open.length() || closeOffset > endLineRegion.getOffset() + endLineRegion.getLength()) {
                return null;
            }
        }
        int othercloseOffset = text.indexOf(close, openOffset + open.length());
        while (othercloseOffset != -1 && othercloseOffset < closeOffset) {
            int startOfLineOffset = document.getLineOffset(document.getLineOfOffset(othercloseOffset));
            if (commentSupport.getLineComment() != null && text.substring(startOfLineOffset, othercloseOffset).indexOf(commentSupport.getLineComment()) != -1) {
                return null;
            }
            othercloseOffset = text.indexOf(close, othercloseOffset + close.length());
        }
        return new Region(openOffset, closeOffset - openOffset);
    }

    private void removeLineComments(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        String oldText = document.get();
        int deletedChars = 0;
        boolean isStartBeforeComment = false;
        Set lines = this.computeLines(selection, document).stream().filter(l -> l >= selection.getStartLine() && l <= selection.getEndLine()).collect(Collectors.toSet());
        boolean isFirstLineUpdated = false;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int lineNumber = (Integer)iterator.next();
            int commentOffset = oldText.indexOf(comment, document.getLineOffset(lineNumber) + deletedChars);
            document.replace(commentOffset - deletedChars, comment.length(), "");
            deletedChars += comment.length();
            if (isFirstLineUpdated) continue;
            isFirstLineUpdated = true;
            boolean bl = isStartBeforeComment = commentOffset >= selection.getOffset();
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() - (isStartBeforeComment ? 0 : comment.length()), selection.getLength() - deletedChars + (isStartBeforeComment ? 0 : comment.length()));
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private void addLineComments(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        int insertedChars = 0;
        Set lines = this.computeLines(selection, document).stream().filter(l -> l >= selection.getStartLine() && l <= selection.getEndLine()).collect(Collectors.toSet());
        boolean isFirstLineUpdated = false;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int lineNumber = (Integer)iterator.next();
            document.replace(document.getLineOffset(lineNumber), 0, comment);
            if (isFirstLineUpdated) {
                insertedChars += comment.length();
                continue;
            }
            isFirstLineUpdated = true;
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() + comment.length(), selection.getLength() + insertedChars);
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private void removeBlockComment(IDocument document, ITextSelection selection, IRegion existingBlock, CharacterPair blockComment, ITextEditor editor) throws BadLocationException {
        int openOffset = existingBlock.getOffset();
        int openLength = blockComment.open.length();
        int closeOffset = existingBlock.getOffset() + existingBlock.getLength();
        int closeLength = blockComment.close.length();
        document.replace(openOffset, openLength, "");
        document.replace(closeOffset - openLength, closeLength, "");
        int offsetFix = openLength;
        int lengthFix = 0;
        if (selection.getOffset() < openOffset + openLength) {
            offsetFix = selection.getOffset() - openOffset;
            lengthFix = openLength - offsetFix;
        }
        if (selection.getOffset() + selection.getLength() > closeOffset) {
            lengthFix += selection.getOffset() + selection.getLength() - closeOffset;
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() - offsetFix, selection.getLength() - lengthFix);
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private void addBlockComment(IDocument document, ITextSelection selection, CharacterPair blockComment, boolean skipSelection, ITextEditor editor) throws BadLocationException {
        document.replace(selection.getOffset(), 0, blockComment.open);
        document.replace(selection.getOffset() + selection.getLength() + blockComment.open.length(), 0, blockComment.close);
        TextSelection newSelection = new TextSelection(selection.getOffset() + blockComment.open.length(), selection.getLength());
        if (!skipSelection) {
            editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
        }
    }
}

