/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.widgets;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JApplet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.trace4cps.common.jfreechart.ui.internal.ChartPanelFactory;
import org.eclipse.trace4cps.common.jfreechart.ui.internal.ChartPanelScrollbarHandler;
import org.eclipse.trace4cps.common.jfreechart.ui.internal.SWT_AWT_PATCH_377104;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.util.Args;

public class ChartPanelComposite
extends Composite {
    private final Frame baseFrame;
    private final ChartPanel chartPanel;
    private final ChartPanelScrollbarHandler scrollbarHandler;

    public ChartPanelComposite(Composite parent, int style) {
        this(ChartPanelFactory.createChartPanel(null), parent, style);
    }

    public ChartPanelComposite(ChartPanel chartPanel, Composite parent, int style) {
        super(parent, 0x1000000 | style);
        Args.nullNotPermitted((Object)chartPanel, (String)"chartPanel");
        this.baseFrame = SWT_AWT_PATCH_377104.new_Frame(this);
        this.chartPanel = chartPanel;
        this.scrollbarHandler = new ChartPanelScrollbarHandler(this);
        java.awt.Color background = ChartPanelComposite.toAwtColor(this.getDisplay().getSystemColor(29));
        try {
            ChartPanelComposite.invokeAndWait(() -> this.createAWTComponent(this.baseFrame, background));
        }
        catch (InterruptedException | InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.trace4cps.common.jfreechart.ui", "Failed to create AWT component: " + e.getLocalizedMessage(), (Throwable)e);
            StatusManager.getManager().handle((IStatus)status);
        }
    }

    private void createAWTComponent(Frame baseFrame, java.awt.Color background) {
        this.chartPanel.setBackground(background);
        this.chartPanel.addMouseListener((MouseListener)new SWTMenuActivator());
        JApplet chartApplet = new JApplet();
        chartApplet.add((Component)this.chartPanel);
        baseFrame.add(chartApplet);
    }

    public void dispose() {
        EventQueue.invokeLater(this.baseFrame::dispose);
        this.scrollbarHandler.dispose();
        super.dispose();
    }

    public boolean setFocus() {
        boolean gotFocus = super.setFocus();
        if (gotFocus) {
            EventQueue.invokeLater(() -> this.chartPanel.requestFocusInWindow());
        }
        return gotFocus;
    }

    public boolean isNotify() {
        JFreeChart chart = this.getChart();
        return chart != null && chart.isNotify();
    }

    public void setNotify(boolean notify) {
        JFreeChart chart = this.getChart();
        if (chart != null && !chart.isNotify()) {
            chart.getPlot().setNotify(notify);
            chart.setNotify(notify);
        }
    }

    public Plot getPlot() {
        JFreeChart chart = this.getChart();
        return chart == null ? null : chart.getPlot();
    }

    public JFreeChart getChart() {
        return this.chartPanel.getChart();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setChart(JFreeChart chart) {
        try {
            ChartPanelComposite.invokeAndWait(() -> this.chartPanel.setChart(chart));
        }
        catch (InterruptedException | InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.trace4cps.common.jfreechart.ui", "Failed to set chart: " + e.getLocalizedMessage(), (Throwable)e);
            StatusManager.getManager().handle((IStatus)status);
        }
    }

    public void setMenu(Menu menu) {
        if (menu == null) {
            this.chartPanel.setPopupPredicate(MouseEvent::isPopupTrigger);
        } else {
            this.chartPanel.setPopupPredicate(e -> false);
        }
        super.setMenu(menu);
    }

    private static java.awt.Color toAwtColor(Color color) {
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static void invokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    private class SWTMenuActivator
    extends MouseAdapter {
        private SWTMenuActivator() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && !e.isConsumed() && !ChartPanelComposite.this.isDisposed() && !ChartPanelComposite.this.getDisplay().isDisposed()) {
                ChartPanelComposite.this.getDisplay().syncExec(() -> {
                    Menu menu = ChartPanelComposite.this.getMenu();
                    if (menu != null) {
                        menu.setVisible(true);
                        e.consume();
                    }
                });
            }
        }
    }
}

