/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.Shape;

public final class PsopFragment
implements IPsopFragment {
    private final Number c;
    private final Number b;
    private final Number a;
    private final IInterval dom;
    private final int order;
    private final Shape shape;

    public PsopFragment(Number c, Number b, Number a, IInterval timeDomain) {
        this(c, b, a, timeDomain, null);
    }

    private PsopFragment(Number c, Number b, Number a, IInterval timeDomain, Shape shape) {
        if (c == null || b == null || a == null) {
            throw new IllegalArgumentException("coefficients must not be null");
        }
        if (timeDomain == null || timeDomain.isEmpty()) {
            throw new IllegalArgumentException("cannot create fragment with empty domain");
        }
        if (timeDomain.isOpenLb() || !timeDomain.isOpenUb()) {
            throw new IllegalArgumentException("cannot create fragment with non [lb, ub) time domain");
        }
        this.c = c;
        this.b = b;
        this.a = a;
        this.order = a.doubleValue() != 0.0 ? 2 : (b.doubleValue() != 0.0 ? 1 : 0);
        this.dom = timeDomain;
        this.shape = shape == null ? this.computeShape() : shape;
    }

    @Override
    public Number getA() {
        return this.a;
    }

    @Override
    public Number getB() {
        return this.b;
    }

    @Override
    public Number getC() {
        return this.c;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public IInterval dom() {
        return this.dom;
    }

    public String toString() {
        return "PsopFragment[dom=" + this.dom + ", c=" + this.c + ", b=" + this.b + ", a=" + this.a + ", shape=" + (Object)((Object)this.shape) + "]";
    }

    private Shape computeShape() {
        if (this.order == 0) {
            return Shape.CONSTANT;
        }
        if (this.order == 1) {
            if (this.b.doubleValue() > 0.0) {
                return Shape.INCREASING;
            }
            return Shape.DECREASING;
        }
        if (this.order == 2) {
            return this.compute2ndOrderShape();
        }
        throw new IllegalStateException();
    }

    private Shape compute2ndOrderShape() {
        double tTop = -this.b.doubleValue() / (2.0 * this.a.doubleValue());
        if (this.dom.lb().doubleValue() < this.dom.lb().doubleValue() + tTop && this.dom.lb().doubleValue() + tTop < this.dom.ub().doubleValue()) {
            return this.compute2ndOrderShapeTopInSegment(tTop);
        }
        double dt = this.dom.ub().doubleValue() - this.dom.lb().doubleValue();
        double xEnd = this.c.doubleValue() + this.b.doubleValue() * dt + this.a.doubleValue() * dt * dt;
        if (this.c.doubleValue() < xEnd) {
            return Shape.INCREASING;
        }
        return Shape.DECREASING;
    }

    private Shape compute2ndOrderShapeTopInSegment(double tTop) {
        double dt = this.dom.ub().doubleValue() - this.dom.lb().doubleValue();
        double xTop = this.c.doubleValue() + this.b.doubleValue() * tTop + this.a.doubleValue() * tTop * tTop;
        double xEnd = this.c.doubleValue() + this.b.doubleValue() * dt + this.a.doubleValue() * dt * dt;
        if (this.c.doubleValue() < xTop && xTop > xEnd) {
            return Shape.PARABOLA_CAP;
        }
        if (this.c.doubleValue() > xTop && xTop < xEnd) {
            return Shape.PARABOLA_CUP;
        }
        if (this.c.doubleValue() <= xTop && xTop <= xEnd) {
            return Shape.INCREASING;
        }
        if (this.c.doubleValue() >= xTop && xTop >= xEnd) {
            return Shape.DECREASING;
        }
        throw new IllegalStateException();
    }
}

