/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class Util {
    private Util() {
    }

    public static String getPath(IFile file) {
        return file.getLocation().toFile().getAbsolutePath();
    }

    public static String browseForFileInWorkspace(Shell parent, String[] ext) {
        List<String> r = Util.browseForFilesInWorkspace(parent, ext, false);
        if (r == null || r.isEmpty()) {
            return null;
        }
        return r.get(0);
    }

    public static List<String> browseForFilesInWorkspace(Shell parent, String[] ext) {
        return Util.browseForFilesInWorkspace(parent, ext, true);
    }

    private static List<String> browseForFilesInWorkspace(Shell parent, final String[] ext, boolean allowMultiple) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select file");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(allowMultiple);
        if (ext != null && ext.length > 0) {
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parent, Object element) {
                    if (element instanceof IFile) {
                        IFile f = (IFile)element;
                        String[] stringArray = ext;
                        int n = ext.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String extension = stringArray[n2];
                            if (f.getName().endsWith(extension)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        if (dialog.open() == 0) {
            ArrayList<String> result = new ArrayList<String>();
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object r = objectArray[n2];
                IResource resource = (IResource)r;
                result.add(resource.getLocation().toString());
                ++n2;
            }
            return result;
        }
        return null;
    }

    public static IFile getFileFromEditorInput(IEditorInput input) {
        if (input == null) {
            return null;
        }
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        IPath path = Util.getPathFromEditorInput(input);
        if (path == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public static IPath getPathFromEditorInput(IEditorInput input) {
        IPath path;
        URI uri;
        if (input instanceof ILocationProvider) {
            return ((ILocationProvider)input).getPath((Object)input);
        }
        if (input instanceof IURIEditorInput && (uri = ((IURIEditorInput)input).getURI()) != null && (path = URIUtil.toPath((URI)uri)) != null) {
            return path;
        }
        return null;
    }
}

