/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.data.xy;

import java.io.Serializable;
import org.eclipse.trace4cps.common.jfreechart.chart.labels.LabeledDataItem;
import org.jfree.chart.util.Args;

public class XYEdgeDataItem
implements LabeledDataItem,
Serializable {
    private static final long serialVersionUID = -7116745427210808035L;
    private final Number x0;
    private final Number y0;
    private final Number x1;
    private final Number y1;
    private String itemLabel;

    public XYEdgeDataItem(Number x0, Number y0, Number x1, Number y1) {
        Args.nullNotPermitted((Object)x0, (String)"x0");
        Args.nullNotPermitted((Object)x1, (String)"x1");
        Args.nullNotPermitted((Object)y0, (String)"y0");
        Args.nullNotPermitted((Object)y1, (String)"y1");
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public boolean isNaN() {
        return Double.isNaN(this.getX0Value()) || Double.isNaN(this.getX1Value()) || Double.isNaN(this.getY0Value()) || Double.isNaN(this.getY1Value());
    }

    public Number getX0() {
        return this.x0;
    }

    public Number getY0() {
        return this.y0;
    }

    public Number getX1() {
        return this.x1;
    }

    public Number getY1() {
        return this.y1;
    }

    public double getX0Value() {
        return this.x0.doubleValue();
    }

    public double getY0Value() {
        return this.y0.doubleValue();
    }

    public double getX1Value() {
        return this.x1.doubleValue();
    }

    public double getY1Value() {
        return this.y1.doubleValue();
    }

    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }

    @Override
    public String getItemLabel() {
        return this.itemLabel;
    }
}

