/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * generated by Xtext 2.22.0
 */
package org.eclipse.trace4cps.tl.etl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.trace4cps.tl.etl.EtlFactory
 * @model kind="package"
 * @generated
 */
public interface EtlPackage extends EPackage
{
  /**
   * The package name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNAME = "etl";

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_URI = "http://www.eclipse.org/trace4cps/tl/etl";

  /**
   * The package namespace name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_PREFIX = "etl";

  /**
   * The singleton instance of the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  EtlPackage eINSTANCE = org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl.init();

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.EtlModelImpl <em>Model</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlModelImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getEtlModel()
   * @generated
   */
  int ETL_MODEL = 0;

  /**
   * The feature id for the '<em><b>Elements</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETL_MODEL__ELEMENTS = 0;

  /**
   * The number of structural features of the '<em>Model</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETL_MODEL_FEATURE_COUNT = 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.TopLevelModelElementImpl <em>Top Level Model Element</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.TopLevelModelElementImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getTopLevelModelElement()
   * @generated
   */
  int TOP_LEVEL_MODEL_ELEMENT = 1;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TOP_LEVEL_MODEL_ELEMENT__NAME = 0;

  /**
   * The number of structural features of the '<em>Top Level Model Element</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT = 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.SignalImpl <em>Signal</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.SignalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getSignal()
   * @generated
   */
  int SIGNAL = 2;

  /**
   * The number of structural features of the '<em>Signal</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int SIGNAL_FEATURE_COUNT = 0;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.ConvSpecImpl <em>Conv Spec</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.ConvSpecImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getConvSpec()
   * @generated
   */
  int CONV_SPEC = 3;

  /**
   * The feature id for the '<em><b>Window Width</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONV_SPEC__WINDOW_WIDTH = 0;

  /**
   * The feature id for the '<em><b>Window Unit</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONV_SPEC__WINDOW_UNIT = 1;

  /**
   * The number of structural features of the '<em>Conv Spec</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONV_SPEC_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.FormulaImpl <em>Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.FormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getFormula()
   * @generated
   */
  int FORMULA = 4;

  /**
   * The number of structural features of the '<em>Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FORMULA_FEATURE_COUNT = 0;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.StlApImpl <em>Stl Ap</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.StlApImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getStlAp()
   * @generated
   */
  int STL_AP = 5;

  /**
   * The feature id for the '<em><b>Ref</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP__REF = 0;

  /**
   * The feature id for the '<em><b>Comp Op</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP__COMP_OP = 1;

  /**
   * The feature id for the '<em><b>Val</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP__VAL = 2;

  /**
   * The number of structural features of the '<em>Stl Ap</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP_FEATURE_COUNT = 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.MtlApImpl <em>Mtl Ap</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.MtlApImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getMtlAp()
   * @generated
   */
  int MTL_AP = 6;

  /**
   * The feature id for the '<em><b>Filter</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int MTL_AP__FILTER = 0;

  /**
   * The number of structural features of the '<em>Mtl Ap</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int MTL_AP_FEATURE_COUNT = 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.AttributeFilterImpl <em>Attribute Filter</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.AttributeFilterImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getAttributeFilter()
   * @generated
   */
  int ATTRIBUTE_FILTER = 7;

  /**
   * The feature id for the '<em><b>Key Vals</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ATTRIBUTE_FILTER__KEY_VALS = 0;

  /**
   * The number of structural features of the '<em>Attribute Filter</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ATTRIBUTE_FILTER_FEATURE_COUNT = 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.KeyValImpl <em>Key Val</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.KeyValImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getKeyVal()
   * @generated
   */
  int KEY_VAL = 8;

  /**
   * The feature id for the '<em><b>Att</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int KEY_VAL__ATT = 0;

  /**
   * The feature id for the '<em><b>Val</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int KEY_VAL__VAL = 1;

  /**
   * The number of structural features of the '<em>Key Val</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int KEY_VAL_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.IdStringImpl <em>Id String</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.IdStringImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIdString()
   * @generated
   */
  int ID_STRING = 9;

  /**
   * The feature id for the '<em><b>Left</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ID_STRING__LEFT = 0;

  /**
   * The feature id for the '<em><b>Id</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ID_STRING__ID = 1;

  /**
   * The feature id for the '<em><b>Right</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ID_STRING__RIGHT = 2;

  /**
   * The number of structural features of the '<em>Id String</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ID_STRING_FEATURE_COUNT = 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalImpl <em>Interval</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.IntervalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getInterval()
   * @generated
   */
  int INTERVAL = 10;

  /**
   * The feature id for the '<em><b>Iss</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL__ISS = 0;

  /**
   * The feature id for the '<em><b>Isn</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL__ISN = 1;

  /**
   * The feature id for the '<em><b>Ins</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL__INS = 2;

  /**
   * The feature id for the '<em><b>Inn</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL__INN = 3;

  /**
   * The feature id for the '<em><b>Time Unit</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL__TIME_UNIT = 4;

  /**
   * The number of structural features of the '<em>Interval</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_FEATURE_COUNT = 5;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalSSImpl <em>Interval SS</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.IntervalSSImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalSS()
   * @generated
   */
  int INTERVAL_SS = 11;

  /**
   * The feature id for the '<em><b>Lb</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_SS__LB = 0;

  /**
   * The feature id for the '<em><b>Ub</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_SS__UB = 1;

  /**
   * The feature id for the '<em><b>Infty</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_SS__INFTY = 2;

  /**
   * The number of structural features of the '<em>Interval SS</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_SS_FEATURE_COUNT = 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalSNImpl <em>Interval SN</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.IntervalSNImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalSN()
   * @generated
   */
  int INTERVAL_SN = 12;

  /**
   * The feature id for the '<em><b>Lb</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_SN__LB = 0;

  /**
   * The feature id for the '<em><b>Ub</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_SN__UB = 1;

  /**
   * The number of structural features of the '<em>Interval SN</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_SN_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalNSImpl <em>Interval NS</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.IntervalNSImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalNS()
   * @generated
   */
  int INTERVAL_NS = 13;

  /**
   * The feature id for the '<em><b>Lb</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_NS__LB = 0;

  /**
   * The feature id for the '<em><b>Ub</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_NS__UB = 1;

  /**
   * The feature id for the '<em><b>Infty</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_NS__INFTY = 2;

  /**
   * The number of structural features of the '<em>Interval NS</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_NS_FEATURE_COUNT = 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalNNImpl <em>Interval NN</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.IntervalNNImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalNN()
   * @generated
   */
  int INTERVAL_NN = 14;

  /**
   * The feature id for the '<em><b>Lb</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_NN__LB = 0;

  /**
   * The feature id for the '<em><b>Ub</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_NN__UB = 1;

  /**
   * The number of structural features of the '<em>Interval NN</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERVAL_NN_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.SignalDefImpl <em>Signal Def</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.SignalDefImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getSignalDef()
   * @generated
   */
  int SIGNAL_DEF = 15;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int SIGNAL_DEF__NAME = TOP_LEVEL_MODEL_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Signal</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int SIGNAL_DEF__SIGNAL = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Signal Def</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int SIGNAL_DEF_FEATURE_COUNT = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.DefImpl <em>Def</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.DefImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getDef()
   * @generated
   */
  int DEF = 16;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DEF__NAME = TOP_LEVEL_MODEL_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Param</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DEF__PARAM = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Formula</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DEF__FORMULA = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Def</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DEF_FEATURE_COUNT = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.CheckImpl <em>Check</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.CheckImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getCheck()
   * @generated
   */
  int CHECK = 17;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHECK__NAME = TOP_LEVEL_MODEL_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Var</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHECK__VAR = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Lb</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHECK__LB = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Ub</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHECK__UB = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>Formula</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHECK__FORMULA = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 3;

  /**
   * The number of structural features of the '<em>Check</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHECK_FEATURE_COUNT = TOP_LEVEL_MODEL_ELEMENT_FEATURE_COUNT + 4;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.TraceSignalImpl <em>Trace Signal</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.TraceSignalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getTraceSignal()
   * @generated
   */
  int TRACE_SIGNAL = 18;

  /**
   * The feature id for the '<em><b>Filter</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TRACE_SIGNAL__FILTER = SIGNAL_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Trace Signal</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TRACE_SIGNAL_FEATURE_COUNT = SIGNAL_FEATURE_COUNT + 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.ThroughputSignalImpl <em>Throughput Signal</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.ThroughputSignalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getThroughputSignal()
   * @generated
   */
  int THROUGHPUT_SIGNAL = 19;

  /**
   * The feature id for the '<em><b>Id Att</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int THROUGHPUT_SIGNAL__ID_ATT = SIGNAL_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Ap</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int THROUGHPUT_SIGNAL__AP = SIGNAL_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Scale</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int THROUGHPUT_SIGNAL__SCALE = SIGNAL_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>Conv Spec</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int THROUGHPUT_SIGNAL__CONV_SPEC = SIGNAL_FEATURE_COUNT + 3;

  /**
   * The number of structural features of the '<em>Throughput Signal</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int THROUGHPUT_SIGNAL_FEATURE_COUNT = SIGNAL_FEATURE_COUNT + 4;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.LatencySignalImpl <em>Latency Signal</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.LatencySignalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getLatencySignal()
   * @generated
   */
  int LATENCY_SIGNAL = 20;

  /**
   * The feature id for the '<em><b>Id Att</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LATENCY_SIGNAL__ID_ATT = SIGNAL_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Scale</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LATENCY_SIGNAL__SCALE = SIGNAL_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Conv Spec</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LATENCY_SIGNAL__CONV_SPEC = SIGNAL_FEATURE_COUNT + 2;

  /**
   * The number of structural features of the '<em>Latency Signal</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LATENCY_SIGNAL_FEATURE_COUNT = SIGNAL_FEATURE_COUNT + 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.WipSignalImpl <em>Wip Signal</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.WipSignalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getWipSignal()
   * @generated
   */
  int WIP_SIGNAL = 21;

  /**
   * The feature id for the '<em><b>Id Att</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int WIP_SIGNAL__ID_ATT = SIGNAL_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Conv Spec</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int WIP_SIGNAL__CONV_SPEC = SIGNAL_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Wip Signal</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int WIP_SIGNAL_FEATURE_COUNT = SIGNAL_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.ResourceAmountSignalImpl <em>Resource Amount Signal</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.ResourceAmountSignalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getResourceAmountSignal()
   * @generated
   */
  int RESOURCE_AMOUNT_SIGNAL = 22;

  /**
   * The feature id for the '<em><b>Filter</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int RESOURCE_AMOUNT_SIGNAL__FILTER = SIGNAL_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Conv Spec</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int RESOURCE_AMOUNT_SIGNAL__CONV_SPEC = SIGNAL_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Resource Amount Signal</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int RESOURCE_AMOUNT_SIGNAL_FEATURE_COUNT = SIGNAL_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.ResourceClientSignalImpl <em>Resource Client Signal</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.ResourceClientSignalImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getResourceClientSignal()
   * @generated
   */
  int RESOURCE_CLIENT_SIGNAL = 23;

  /**
   * The feature id for the '<em><b>Filter</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int RESOURCE_CLIENT_SIGNAL__FILTER = SIGNAL_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Conv Spec</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int RESOURCE_CLIENT_SIGNAL__CONV_SPEC = SIGNAL_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Resource Client Signal</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int RESOURCE_CLIENT_SIGNAL_FEATURE_COUNT = SIGNAL_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.ReferenceFormulaImpl <em>Reference Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.ReferenceFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getReferenceFormula()
   * @generated
   */
  int REFERENCE_FORMULA = 24;

  /**
   * The feature id for the '<em><b>Def</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REFERENCE_FORMULA__DEF = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Param</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REFERENCE_FORMULA__PARAM = FORMULA_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Val</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REFERENCE_FORMULA__VAL = FORMULA_FEATURE_COUNT + 2;

  /**
   * The number of structural features of the '<em>Reference Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REFERENCE_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.ApFormulaImpl <em>Ap Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.ApFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getApFormula()
   * @generated
   */
  int AP_FORMULA = 25;

  /**
   * The feature id for the '<em><b>Mtl AP</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int AP_FORMULA__MTL_AP = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Stl AP</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int AP_FORMULA__STL_AP = FORMULA_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Ap Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int AP_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.NotFormulaImpl <em>Not Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.NotFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getNotFormula()
   * @generated
   */
  int NOT_FORMULA = 26;

  /**
   * The feature id for the '<em><b>Formula</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NOT_FORMULA__FORMULA = FORMULA_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Not Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NOT_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.AndOrFormulaImpl <em>And Or Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.AndOrFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getAndOrFormula()
   * @generated
   */
  int AND_OR_FORMULA = 27;

  /**
   * The feature id for the '<em><b>Left</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int AND_OR_FORMULA__LEFT = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Op</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int AND_OR_FORMULA__OP = FORMULA_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Right</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int AND_OR_FORMULA__RIGHT = FORMULA_FEATURE_COUNT + 2;

  /**
   * The number of structural features of the '<em>And Or Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int AND_OR_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.IfThenFormulaImpl <em>If Then Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.IfThenFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIfThenFormula()
   * @generated
   */
  int IF_THEN_FORMULA = 28;

  /**
   * The feature id for the '<em><b>Left</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IF_THEN_FORMULA__LEFT = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Right</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IF_THEN_FORMULA__RIGHT = FORMULA_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>If Then Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IF_THEN_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.GloballyUntimedFormulaImpl <em>Globally Untimed Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.GloballyUntimedFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getGloballyUntimedFormula()
   * @generated
   */
  int GLOBALLY_UNTIMED_FORMULA = 29;

  /**
   * The feature id for the '<em><b>Formula</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int GLOBALLY_UNTIMED_FORMULA__FORMULA = FORMULA_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Globally Untimed Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int GLOBALLY_UNTIMED_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.GloballyFormulaImpl <em>Globally Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.GloballyFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getGloballyFormula()
   * @generated
   */
  int GLOBALLY_FORMULA = 30;

  /**
   * The feature id for the '<em><b>Interval</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int GLOBALLY_FORMULA__INTERVAL = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Formula</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int GLOBALLY_FORMULA__FORMULA = FORMULA_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Globally Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int GLOBALLY_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.FinallyUntimedFormulaImpl <em>Finally Untimed Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.FinallyUntimedFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getFinallyUntimedFormula()
   * @generated
   */
  int FINALLY_UNTIMED_FORMULA = 31;

  /**
   * The feature id for the '<em><b>Formula</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FINALLY_UNTIMED_FORMULA__FORMULA = FORMULA_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Finally Untimed Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FINALLY_UNTIMED_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 1;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.FinallyFormulaImpl <em>Finally Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.FinallyFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getFinallyFormula()
   * @generated
   */
  int FINALLY_FORMULA = 32;

  /**
   * The feature id for the '<em><b>Interval</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FINALLY_FORMULA__INTERVAL = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Formula</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FINALLY_FORMULA__FORMULA = FORMULA_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Finally Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FINALLY_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.UntilUntimedFormulaImpl <em>Until Untimed Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.UntilUntimedFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getUntilUntimedFormula()
   * @generated
   */
  int UNTIL_UNTIMED_FORMULA = 33;

  /**
   * The feature id for the '<em><b>Right</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int UNTIL_UNTIMED_FORMULA__RIGHT = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Left</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int UNTIL_UNTIMED_FORMULA__LEFT = FORMULA_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Until Untimed Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int UNTIL_UNTIMED_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 2;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.UntilFormulaImpl <em>Until Formula</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.UntilFormulaImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getUntilFormula()
   * @generated
   */
  int UNTIL_FORMULA = 34;

  /**
   * The feature id for the '<em><b>Interval</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int UNTIL_FORMULA__INTERVAL = FORMULA_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Right</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int UNTIL_FORMULA__RIGHT = FORMULA_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Left</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int UNTIL_FORMULA__LEFT = FORMULA_FEATURE_COUNT + 2;

  /**
   * The number of structural features of the '<em>Until Formula</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int UNTIL_FORMULA_FEATURE_COUNT = FORMULA_FEATURE_COUNT + 3;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.StlApDerivImpl <em>Stl Ap Deriv</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.StlApDerivImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getStlApDeriv()
   * @generated
   */
  int STL_AP_DERIV = 35;

  /**
   * The feature id for the '<em><b>Ref</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP_DERIV__REF = STL_AP__REF;

  /**
   * The feature id for the '<em><b>Comp Op</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP_DERIV__COMP_OP = STL_AP__COMP_OP;

  /**
   * The feature id for the '<em><b>Val</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP_DERIV__VAL = STL_AP__VAL;

  /**
   * The number of structural features of the '<em>Stl Ap Deriv</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STL_AP_DERIV_FEATURE_COUNT = STL_AP_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.MtlApStartImpl <em>Mtl Ap Start</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.MtlApStartImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getMtlApStart()
   * @generated
   */
  int MTL_AP_START = 36;

  /**
   * The feature id for the '<em><b>Filter</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int MTL_AP_START__FILTER = MTL_AP__FILTER;

  /**
   * The number of structural features of the '<em>Mtl Ap Start</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int MTL_AP_START_FEATURE_COUNT = MTL_AP_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.impl.MtlApEndImpl <em>Mtl Ap End</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.impl.MtlApEndImpl
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getMtlApEnd()
   * @generated
   */
  int MTL_AP_END = 37;

  /**
   * The feature id for the '<em><b>Filter</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int MTL_AP_END__FILTER = MTL_AP__FILTER;

  /**
   * The number of structural features of the '<em>Mtl Ap End</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int MTL_AP_END_FEATURE_COUNT = MTL_AP_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.TimeUnitEnum <em>Time Unit Enum</em>}' enum.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.TimeUnitEnum
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getTimeUnitEnum()
   * @generated
   */
  int TIME_UNIT_ENUM = 38;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.AndOr <em>And Or</em>}' enum.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.AndOr
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getAndOr()
   * @generated
   */
  int AND_OR = 39;

  /**
   * The meta object id for the '{@link org.eclipse.trace4cps.tl.etl.CompOp <em>Comp Op</em>}' enum.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.trace4cps.tl.etl.CompOp
   * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getCompOp()
   * @generated
   */
  int COMP_OP = 40;


  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.EtlModel <em>Model</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Model</em>'.
   * @see org.eclipse.trace4cps.tl.etl.EtlModel
   * @generated
   */
  EClass getEtlModel();

  /**
   * Returns the meta object for the containment reference list '{@link org.eclipse.trace4cps.tl.etl.EtlModel#getElements <em>Elements</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Elements</em>'.
   * @see org.eclipse.trace4cps.tl.etl.EtlModel#getElements()
   * @see #getEtlModel()
   * @generated
   */
  EReference getEtlModel_Elements();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.TopLevelModelElement <em>Top Level Model Element</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Top Level Model Element</em>'.
   * @see org.eclipse.trace4cps.tl.etl.TopLevelModelElement
   * @generated
   */
  EClass getTopLevelModelElement();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.TopLevelModelElement#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see org.eclipse.trace4cps.tl.etl.TopLevelModelElement#getName()
   * @see #getTopLevelModelElement()
   * @generated
   */
  EAttribute getTopLevelModelElement_Name();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.Signal <em>Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Signal
   * @generated
   */
  EClass getSignal();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.ConvSpec <em>Conv Spec</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Conv Spec</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ConvSpec
   * @generated
   */
  EClass getConvSpec();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.ConvSpec#getWindowWidth <em>Window Width</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Window Width</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ConvSpec#getWindowWidth()
   * @see #getConvSpec()
   * @generated
   */
  EAttribute getConvSpec_WindowWidth();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.ConvSpec#getWindowUnit <em>Window Unit</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Window Unit</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ConvSpec#getWindowUnit()
   * @see #getConvSpec()
   * @generated
   */
  EAttribute getConvSpec_WindowUnit();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.Formula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Formula
   * @generated
   */
  EClass getFormula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.StlAp <em>Stl Ap</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Stl Ap</em>'.
   * @see org.eclipse.trace4cps.tl.etl.StlAp
   * @generated
   */
  EClass getStlAp();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.trace4cps.tl.etl.StlAp#getRef <em>Ref</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Ref</em>'.
   * @see org.eclipse.trace4cps.tl.etl.StlAp#getRef()
   * @see #getStlAp()
   * @generated
   */
  EReference getStlAp_Ref();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.StlAp#getCompOp <em>Comp Op</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Comp Op</em>'.
   * @see org.eclipse.trace4cps.tl.etl.StlAp#getCompOp()
   * @see #getStlAp()
   * @generated
   */
  EAttribute getStlAp_CompOp();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.StlAp#getVal <em>Val</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Val</em>'.
   * @see org.eclipse.trace4cps.tl.etl.StlAp#getVal()
   * @see #getStlAp()
   * @generated
   */
  EAttribute getStlAp_Val();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.MtlAp <em>Mtl Ap</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Mtl Ap</em>'.
   * @see org.eclipse.trace4cps.tl.etl.MtlAp
   * @generated
   */
  EClass getMtlAp();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.MtlAp#getFilter <em>Filter</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Filter</em>'.
   * @see org.eclipse.trace4cps.tl.etl.MtlAp#getFilter()
   * @see #getMtlAp()
   * @generated
   */
  EReference getMtlAp_Filter();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.AttributeFilter <em>Attribute Filter</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Attribute Filter</em>'.
   * @see org.eclipse.trace4cps.tl.etl.AttributeFilter
   * @generated
   */
  EClass getAttributeFilter();

  /**
   * Returns the meta object for the containment reference list '{@link org.eclipse.trace4cps.tl.etl.AttributeFilter#getKeyVals <em>Key Vals</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Key Vals</em>'.
   * @see org.eclipse.trace4cps.tl.etl.AttributeFilter#getKeyVals()
   * @see #getAttributeFilter()
   * @generated
   */
  EReference getAttributeFilter_KeyVals();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.KeyVal <em>Key Val</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Key Val</em>'.
   * @see org.eclipse.trace4cps.tl.etl.KeyVal
   * @generated
   */
  EClass getKeyVal();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.KeyVal#getAtt <em>Att</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Att</em>'.
   * @see org.eclipse.trace4cps.tl.etl.KeyVal#getAtt()
   * @see #getKeyVal()
   * @generated
   */
  EReference getKeyVal_Att();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.KeyVal#getVal <em>Val</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Val</em>'.
   * @see org.eclipse.trace4cps.tl.etl.KeyVal#getVal()
   * @see #getKeyVal()
   * @generated
   */
  EReference getKeyVal_Val();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.IdString <em>Id String</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Id String</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IdString
   * @generated
   */
  EClass getIdString();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IdString#getLeft <em>Left</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Left</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IdString#getLeft()
   * @see #getIdString()
   * @generated
   */
  EAttribute getIdString_Left();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IdString#getId <em>Id</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Id</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IdString#getId()
   * @see #getIdString()
   * @generated
   */
  EAttribute getIdString_Id();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IdString#getRight <em>Right</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Right</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IdString#getRight()
   * @see #getIdString()
   * @generated
   */
  EAttribute getIdString_Right();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.Interval <em>Interval</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Interval</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Interval
   * @generated
   */
  EClass getInterval();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.Interval#getIss <em>Iss</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Iss</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Interval#getIss()
   * @see #getInterval()
   * @generated
   */
  EReference getInterval_Iss();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.Interval#getIsn <em>Isn</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Isn</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Interval#getIsn()
   * @see #getInterval()
   * @generated
   */
  EReference getInterval_Isn();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.Interval#getIns <em>Ins</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Ins</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Interval#getIns()
   * @see #getInterval()
   * @generated
   */
  EReference getInterval_Ins();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.Interval#getInn <em>Inn</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Inn</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Interval#getInn()
   * @see #getInterval()
   * @generated
   */
  EReference getInterval_Inn();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.Interval#getTimeUnit <em>Time Unit</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Time Unit</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Interval#getTimeUnit()
   * @see #getInterval()
   * @generated
   */
  EAttribute getInterval_TimeUnit();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.IntervalSS <em>Interval SS</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Interval SS</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSS
   * @generated
   */
  EClass getIntervalSS();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalSS#getLb <em>Lb</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Lb</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSS#getLb()
   * @see #getIntervalSS()
   * @generated
   */
  EAttribute getIntervalSS_Lb();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalSS#getUb <em>Ub</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Ub</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSS#getUb()
   * @see #getIntervalSS()
   * @generated
   */
  EAttribute getIntervalSS_Ub();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalSS#getInfty <em>Infty</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Infty</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSS#getInfty()
   * @see #getIntervalSS()
   * @generated
   */
  EAttribute getIntervalSS_Infty();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.IntervalSN <em>Interval SN</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Interval SN</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSN
   * @generated
   */
  EClass getIntervalSN();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalSN#getLb <em>Lb</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Lb</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSN#getLb()
   * @see #getIntervalSN()
   * @generated
   */
  EAttribute getIntervalSN_Lb();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalSN#getUb <em>Ub</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Ub</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSN#getUb()
   * @see #getIntervalSN()
   * @generated
   */
  EAttribute getIntervalSN_Ub();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.IntervalNS <em>Interval NS</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Interval NS</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNS
   * @generated
   */
  EClass getIntervalNS();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalNS#getLb <em>Lb</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Lb</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNS#getLb()
   * @see #getIntervalNS()
   * @generated
   */
  EAttribute getIntervalNS_Lb();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalNS#getUb <em>Ub</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Ub</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNS#getUb()
   * @see #getIntervalNS()
   * @generated
   */
  EAttribute getIntervalNS_Ub();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalNS#getInfty <em>Infty</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Infty</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNS#getInfty()
   * @see #getIntervalNS()
   * @generated
   */
  EAttribute getIntervalNS_Infty();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.IntervalNN <em>Interval NN</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Interval NN</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNN
   * @generated
   */
  EClass getIntervalNN();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalNN#getLb <em>Lb</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Lb</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNN#getLb()
   * @see #getIntervalNN()
   * @generated
   */
  EAttribute getIntervalNN_Lb();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.IntervalNN#getUb <em>Ub</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Ub</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNN#getUb()
   * @see #getIntervalNN()
   * @generated
   */
  EAttribute getIntervalNN_Ub();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.SignalDef <em>Signal Def</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Signal Def</em>'.
   * @see org.eclipse.trace4cps.tl.etl.SignalDef
   * @generated
   */
  EClass getSignalDef();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.SignalDef#getSignal <em>Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.SignalDef#getSignal()
   * @see #getSignalDef()
   * @generated
   */
  EReference getSignalDef_Signal();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.Def <em>Def</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Def</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Def
   * @generated
   */
  EClass getDef();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.Def#getParam <em>Param</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Param</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Def#getParam()
   * @see #getDef()
   * @generated
   */
  EAttribute getDef_Param();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.Def#getFormula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Def#getFormula()
   * @see #getDef()
   * @generated
   */
  EReference getDef_Formula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.Check <em>Check</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Check</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Check
   * @generated
   */
  EClass getCheck();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.Check#getVar <em>Var</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Var</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Check#getVar()
   * @see #getCheck()
   * @generated
   */
  EAttribute getCheck_Var();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.Check#getLb <em>Lb</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Lb</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Check#getLb()
   * @see #getCheck()
   * @generated
   */
  EAttribute getCheck_Lb();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.Check#getUb <em>Ub</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Ub</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Check#getUb()
   * @see #getCheck()
   * @generated
   */
  EAttribute getCheck_Ub();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.Check#getFormula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.Check#getFormula()
   * @see #getCheck()
   * @generated
   */
  EReference getCheck_Formula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.TraceSignal <em>Trace Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Trace Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.TraceSignal
   * @generated
   */
  EClass getTraceSignal();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.TraceSignal#getFilter <em>Filter</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Filter</em>'.
   * @see org.eclipse.trace4cps.tl.etl.TraceSignal#getFilter()
   * @see #getTraceSignal()
   * @generated
   */
  EReference getTraceSignal_Filter();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.ThroughputSignal <em>Throughput Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Throughput Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ThroughputSignal
   * @generated
   */
  EClass getThroughputSignal();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.ThroughputSignal#getIdAtt <em>Id Att</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Id Att</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ThroughputSignal#getIdAtt()
   * @see #getThroughputSignal()
   * @generated
   */
  EAttribute getThroughputSignal_IdAtt();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ThroughputSignal#getAp <em>Ap</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Ap</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ThroughputSignal#getAp()
   * @see #getThroughputSignal()
   * @generated
   */
  EReference getThroughputSignal_Ap();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.ThroughputSignal#getScale <em>Scale</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Scale</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ThroughputSignal#getScale()
   * @see #getThroughputSignal()
   * @generated
   */
  EAttribute getThroughputSignal_Scale();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ThroughputSignal#getConvSpec <em>Conv Spec</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Conv Spec</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ThroughputSignal#getConvSpec()
   * @see #getThroughputSignal()
   * @generated
   */
  EReference getThroughputSignal_ConvSpec();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.LatencySignal <em>Latency Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Latency Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.LatencySignal
   * @generated
   */
  EClass getLatencySignal();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.LatencySignal#getIdAtt <em>Id Att</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Id Att</em>'.
   * @see org.eclipse.trace4cps.tl.etl.LatencySignal#getIdAtt()
   * @see #getLatencySignal()
   * @generated
   */
  EAttribute getLatencySignal_IdAtt();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.LatencySignal#getScale <em>Scale</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Scale</em>'.
   * @see org.eclipse.trace4cps.tl.etl.LatencySignal#getScale()
   * @see #getLatencySignal()
   * @generated
   */
  EAttribute getLatencySignal_Scale();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.LatencySignal#getConvSpec <em>Conv Spec</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Conv Spec</em>'.
   * @see org.eclipse.trace4cps.tl.etl.LatencySignal#getConvSpec()
   * @see #getLatencySignal()
   * @generated
   */
  EReference getLatencySignal_ConvSpec();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.WipSignal <em>Wip Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Wip Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.WipSignal
   * @generated
   */
  EClass getWipSignal();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.WipSignal#getIdAtt <em>Id Att</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Id Att</em>'.
   * @see org.eclipse.trace4cps.tl.etl.WipSignal#getIdAtt()
   * @see #getWipSignal()
   * @generated
   */
  EAttribute getWipSignal_IdAtt();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.WipSignal#getConvSpec <em>Conv Spec</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Conv Spec</em>'.
   * @see org.eclipse.trace4cps.tl.etl.WipSignal#getConvSpec()
   * @see #getWipSignal()
   * @generated
   */
  EReference getWipSignal_ConvSpec();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.ResourceAmountSignal <em>Resource Amount Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Resource Amount Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ResourceAmountSignal
   * @generated
   */
  EClass getResourceAmountSignal();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ResourceAmountSignal#getFilter <em>Filter</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Filter</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ResourceAmountSignal#getFilter()
   * @see #getResourceAmountSignal()
   * @generated
   */
  EReference getResourceAmountSignal_Filter();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ResourceAmountSignal#getConvSpec <em>Conv Spec</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Conv Spec</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ResourceAmountSignal#getConvSpec()
   * @see #getResourceAmountSignal()
   * @generated
   */
  EReference getResourceAmountSignal_ConvSpec();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.ResourceClientSignal <em>Resource Client Signal</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Resource Client Signal</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ResourceClientSignal
   * @generated
   */
  EClass getResourceClientSignal();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ResourceClientSignal#getFilter <em>Filter</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Filter</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ResourceClientSignal#getFilter()
   * @see #getResourceClientSignal()
   * @generated
   */
  EReference getResourceClientSignal_Filter();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ResourceClientSignal#getConvSpec <em>Conv Spec</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Conv Spec</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ResourceClientSignal#getConvSpec()
   * @see #getResourceClientSignal()
   * @generated
   */
  EReference getResourceClientSignal_ConvSpec();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.ReferenceFormula <em>Reference Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Reference Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ReferenceFormula
   * @generated
   */
  EClass getReferenceFormula();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.trace4cps.tl.etl.ReferenceFormula#getDef <em>Def</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Def</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ReferenceFormula#getDef()
   * @see #getReferenceFormula()
   * @generated
   */
  EReference getReferenceFormula_Def();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.ReferenceFormula#getParam <em>Param</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Param</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ReferenceFormula#getParam()
   * @see #getReferenceFormula()
   * @generated
   */
  EAttribute getReferenceFormula_Param();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.ReferenceFormula#getVal <em>Val</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Val</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ReferenceFormula#getVal()
   * @see #getReferenceFormula()
   * @generated
   */
  EAttribute getReferenceFormula_Val();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.ApFormula <em>Ap Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Ap Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ApFormula
   * @generated
   */
  EClass getApFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ApFormula#getMtlAP <em>Mtl AP</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Mtl AP</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ApFormula#getMtlAP()
   * @see #getApFormula()
   * @generated
   */
  EReference getApFormula_MtlAP();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.ApFormula#getStlAP <em>Stl AP</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Stl AP</em>'.
   * @see org.eclipse.trace4cps.tl.etl.ApFormula#getStlAP()
   * @see #getApFormula()
   * @generated
   */
  EReference getApFormula_StlAP();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.NotFormula <em>Not Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Not Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.NotFormula
   * @generated
   */
  EClass getNotFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.NotFormula#getFormula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.NotFormula#getFormula()
   * @see #getNotFormula()
   * @generated
   */
  EReference getNotFormula_Formula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.AndOrFormula <em>And Or Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>And Or Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.AndOrFormula
   * @generated
   */
  EClass getAndOrFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.AndOrFormula#getLeft <em>Left</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Left</em>'.
   * @see org.eclipse.trace4cps.tl.etl.AndOrFormula#getLeft()
   * @see #getAndOrFormula()
   * @generated
   */
  EReference getAndOrFormula_Left();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.trace4cps.tl.etl.AndOrFormula#getOp <em>Op</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Op</em>'.
   * @see org.eclipse.trace4cps.tl.etl.AndOrFormula#getOp()
   * @see #getAndOrFormula()
   * @generated
   */
  EAttribute getAndOrFormula_Op();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.AndOrFormula#getRight <em>Right</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Right</em>'.
   * @see org.eclipse.trace4cps.tl.etl.AndOrFormula#getRight()
   * @see #getAndOrFormula()
   * @generated
   */
  EReference getAndOrFormula_Right();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.IfThenFormula <em>If Then Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>If Then Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IfThenFormula
   * @generated
   */
  EClass getIfThenFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.IfThenFormula#getLeft <em>Left</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Left</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IfThenFormula#getLeft()
   * @see #getIfThenFormula()
   * @generated
   */
  EReference getIfThenFormula_Left();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.IfThenFormula#getRight <em>Right</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Right</em>'.
   * @see org.eclipse.trace4cps.tl.etl.IfThenFormula#getRight()
   * @see #getIfThenFormula()
   * @generated
   */
  EReference getIfThenFormula_Right();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula <em>Globally Untimed Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Globally Untimed Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula
   * @generated
   */
  EClass getGloballyUntimedFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula#getFormula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula#getFormula()
   * @see #getGloballyUntimedFormula()
   * @generated
   */
  EReference getGloballyUntimedFormula_Formula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.GloballyFormula <em>Globally Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Globally Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.GloballyFormula
   * @generated
   */
  EClass getGloballyFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.GloballyFormula#getInterval <em>Interval</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Interval</em>'.
   * @see org.eclipse.trace4cps.tl.etl.GloballyFormula#getInterval()
   * @see #getGloballyFormula()
   * @generated
   */
  EReference getGloballyFormula_Interval();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.GloballyFormula#getFormula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.GloballyFormula#getFormula()
   * @see #getGloballyFormula()
   * @generated
   */
  EReference getGloballyFormula_Formula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula <em>Finally Untimed Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Finally Untimed Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula
   * @generated
   */
  EClass getFinallyUntimedFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula#getFormula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula#getFormula()
   * @see #getFinallyUntimedFormula()
   * @generated
   */
  EReference getFinallyUntimedFormula_Formula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.FinallyFormula <em>Finally Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Finally Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.FinallyFormula
   * @generated
   */
  EClass getFinallyFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.FinallyFormula#getInterval <em>Interval</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Interval</em>'.
   * @see org.eclipse.trace4cps.tl.etl.FinallyFormula#getInterval()
   * @see #getFinallyFormula()
   * @generated
   */
  EReference getFinallyFormula_Interval();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.FinallyFormula#getFormula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.FinallyFormula#getFormula()
   * @see #getFinallyFormula()
   * @generated
   */
  EReference getFinallyFormula_Formula();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.UntilUntimedFormula <em>Until Untimed Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Until Untimed Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.UntilUntimedFormula
   * @generated
   */
  EClass getUntilUntimedFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.UntilUntimedFormula#getRight <em>Right</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Right</em>'.
   * @see org.eclipse.trace4cps.tl.etl.UntilUntimedFormula#getRight()
   * @see #getUntilUntimedFormula()
   * @generated
   */
  EReference getUntilUntimedFormula_Right();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.UntilUntimedFormula#getLeft <em>Left</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Left</em>'.
   * @see org.eclipse.trace4cps.tl.etl.UntilUntimedFormula#getLeft()
   * @see #getUntilUntimedFormula()
   * @generated
   */
  EReference getUntilUntimedFormula_Left();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.UntilFormula <em>Until Formula</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Until Formula</em>'.
   * @see org.eclipse.trace4cps.tl.etl.UntilFormula
   * @generated
   */
  EClass getUntilFormula();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.UntilFormula#getInterval <em>Interval</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Interval</em>'.
   * @see org.eclipse.trace4cps.tl.etl.UntilFormula#getInterval()
   * @see #getUntilFormula()
   * @generated
   */
  EReference getUntilFormula_Interval();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.UntilFormula#getRight <em>Right</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Right</em>'.
   * @see org.eclipse.trace4cps.tl.etl.UntilFormula#getRight()
   * @see #getUntilFormula()
   * @generated
   */
  EReference getUntilFormula_Right();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.trace4cps.tl.etl.UntilFormula#getLeft <em>Left</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Left</em>'.
   * @see org.eclipse.trace4cps.tl.etl.UntilFormula#getLeft()
   * @see #getUntilFormula()
   * @generated
   */
  EReference getUntilFormula_Left();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.StlApDeriv <em>Stl Ap Deriv</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Stl Ap Deriv</em>'.
   * @see org.eclipse.trace4cps.tl.etl.StlApDeriv
   * @generated
   */
  EClass getStlApDeriv();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.MtlApStart <em>Mtl Ap Start</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Mtl Ap Start</em>'.
   * @see org.eclipse.trace4cps.tl.etl.MtlApStart
   * @generated
   */
  EClass getMtlApStart();

  /**
   * Returns the meta object for class '{@link org.eclipse.trace4cps.tl.etl.MtlApEnd <em>Mtl Ap End</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Mtl Ap End</em>'.
   * @see org.eclipse.trace4cps.tl.etl.MtlApEnd
   * @generated
   */
  EClass getMtlApEnd();

  /**
   * Returns the meta object for enum '{@link org.eclipse.trace4cps.tl.etl.TimeUnitEnum <em>Time Unit Enum</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for enum '<em>Time Unit Enum</em>'.
   * @see org.eclipse.trace4cps.tl.etl.TimeUnitEnum
   * @generated
   */
  EEnum getTimeUnitEnum();

  /**
   * Returns the meta object for enum '{@link org.eclipse.trace4cps.tl.etl.AndOr <em>And Or</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for enum '<em>And Or</em>'.
   * @see org.eclipse.trace4cps.tl.etl.AndOr
   * @generated
   */
  EEnum getAndOr();

  /**
   * Returns the meta object for enum '{@link org.eclipse.trace4cps.tl.etl.CompOp <em>Comp Op</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for enum '<em>Comp Op</em>'.
   * @see org.eclipse.trace4cps.tl.etl.CompOp
   * @generated
   */
  EEnum getCompOp();

  /**
   * Returns the factory that creates the instances of the model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the factory that creates the instances of the model.
   * @generated
   */
  EtlFactory getEtlFactory();

  /**
   * <!-- begin-user-doc -->
   * Defines literals for the meta objects that represent
   * <ul>
   *   <li>each class,</li>
   *   <li>each feature of each class,</li>
   *   <li>each enum,</li>
   *   <li>and each data type</li>
   * </ul>
   * <!-- end-user-doc -->
   * @generated
   */
  interface Literals
  {
    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.EtlModelImpl <em>Model</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlModelImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getEtlModel()
     * @generated
     */
    EClass ETL_MODEL = eINSTANCE.getEtlModel();

    /**
     * The meta object literal for the '<em><b>Elements</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference ETL_MODEL__ELEMENTS = eINSTANCE.getEtlModel_Elements();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.TopLevelModelElementImpl <em>Top Level Model Element</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.TopLevelModelElementImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getTopLevelModelElement()
     * @generated
     */
    EClass TOP_LEVEL_MODEL_ELEMENT = eINSTANCE.getTopLevelModelElement();

    /**
     * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute TOP_LEVEL_MODEL_ELEMENT__NAME = eINSTANCE.getTopLevelModelElement_Name();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.SignalImpl <em>Signal</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.SignalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getSignal()
     * @generated
     */
    EClass SIGNAL = eINSTANCE.getSignal();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.ConvSpecImpl <em>Conv Spec</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.ConvSpecImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getConvSpec()
     * @generated
     */
    EClass CONV_SPEC = eINSTANCE.getConvSpec();

    /**
     * The meta object literal for the '<em><b>Window Width</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CONV_SPEC__WINDOW_WIDTH = eINSTANCE.getConvSpec_WindowWidth();

    /**
     * The meta object literal for the '<em><b>Window Unit</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CONV_SPEC__WINDOW_UNIT = eINSTANCE.getConvSpec_WindowUnit();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.FormulaImpl <em>Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.FormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getFormula()
     * @generated
     */
    EClass FORMULA = eINSTANCE.getFormula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.StlApImpl <em>Stl Ap</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.StlApImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getStlAp()
     * @generated
     */
    EClass STL_AP = eINSTANCE.getStlAp();

    /**
     * The meta object literal for the '<em><b>Ref</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference STL_AP__REF = eINSTANCE.getStlAp_Ref();

    /**
     * The meta object literal for the '<em><b>Comp Op</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute STL_AP__COMP_OP = eINSTANCE.getStlAp_CompOp();

    /**
     * The meta object literal for the '<em><b>Val</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute STL_AP__VAL = eINSTANCE.getStlAp_Val();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.MtlApImpl <em>Mtl Ap</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.MtlApImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getMtlAp()
     * @generated
     */
    EClass MTL_AP = eINSTANCE.getMtlAp();

    /**
     * The meta object literal for the '<em><b>Filter</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference MTL_AP__FILTER = eINSTANCE.getMtlAp_Filter();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.AttributeFilterImpl <em>Attribute Filter</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.AttributeFilterImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getAttributeFilter()
     * @generated
     */
    EClass ATTRIBUTE_FILTER = eINSTANCE.getAttributeFilter();

    /**
     * The meta object literal for the '<em><b>Key Vals</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference ATTRIBUTE_FILTER__KEY_VALS = eINSTANCE.getAttributeFilter_KeyVals();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.KeyValImpl <em>Key Val</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.KeyValImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getKeyVal()
     * @generated
     */
    EClass KEY_VAL = eINSTANCE.getKeyVal();

    /**
     * The meta object literal for the '<em><b>Att</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference KEY_VAL__ATT = eINSTANCE.getKeyVal_Att();

    /**
     * The meta object literal for the '<em><b>Val</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference KEY_VAL__VAL = eINSTANCE.getKeyVal_Val();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.IdStringImpl <em>Id String</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.IdStringImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIdString()
     * @generated
     */
    EClass ID_STRING = eINSTANCE.getIdString();

    /**
     * The meta object literal for the '<em><b>Left</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute ID_STRING__LEFT = eINSTANCE.getIdString_Left();

    /**
     * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute ID_STRING__ID = eINSTANCE.getIdString_Id();

    /**
     * The meta object literal for the '<em><b>Right</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute ID_STRING__RIGHT = eINSTANCE.getIdString_Right();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalImpl <em>Interval</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.IntervalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getInterval()
     * @generated
     */
    EClass INTERVAL = eINSTANCE.getInterval();

    /**
     * The meta object literal for the '<em><b>Iss</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference INTERVAL__ISS = eINSTANCE.getInterval_Iss();

    /**
     * The meta object literal for the '<em><b>Isn</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference INTERVAL__ISN = eINSTANCE.getInterval_Isn();

    /**
     * The meta object literal for the '<em><b>Ins</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference INTERVAL__INS = eINSTANCE.getInterval_Ins();

    /**
     * The meta object literal for the '<em><b>Inn</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference INTERVAL__INN = eINSTANCE.getInterval_Inn();

    /**
     * The meta object literal for the '<em><b>Time Unit</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL__TIME_UNIT = eINSTANCE.getInterval_TimeUnit();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalSSImpl <em>Interval SS</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.IntervalSSImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalSS()
     * @generated
     */
    EClass INTERVAL_SS = eINSTANCE.getIntervalSS();

    /**
     * The meta object literal for the '<em><b>Lb</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_SS__LB = eINSTANCE.getIntervalSS_Lb();

    /**
     * The meta object literal for the '<em><b>Ub</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_SS__UB = eINSTANCE.getIntervalSS_Ub();

    /**
     * The meta object literal for the '<em><b>Infty</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_SS__INFTY = eINSTANCE.getIntervalSS_Infty();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalSNImpl <em>Interval SN</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.IntervalSNImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalSN()
     * @generated
     */
    EClass INTERVAL_SN = eINSTANCE.getIntervalSN();

    /**
     * The meta object literal for the '<em><b>Lb</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_SN__LB = eINSTANCE.getIntervalSN_Lb();

    /**
     * The meta object literal for the '<em><b>Ub</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_SN__UB = eINSTANCE.getIntervalSN_Ub();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalNSImpl <em>Interval NS</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.IntervalNSImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalNS()
     * @generated
     */
    EClass INTERVAL_NS = eINSTANCE.getIntervalNS();

    /**
     * The meta object literal for the '<em><b>Lb</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_NS__LB = eINSTANCE.getIntervalNS_Lb();

    /**
     * The meta object literal for the '<em><b>Ub</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_NS__UB = eINSTANCE.getIntervalNS_Ub();

    /**
     * The meta object literal for the '<em><b>Infty</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_NS__INFTY = eINSTANCE.getIntervalNS_Infty();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.IntervalNNImpl <em>Interval NN</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.IntervalNNImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIntervalNN()
     * @generated
     */
    EClass INTERVAL_NN = eINSTANCE.getIntervalNN();

    /**
     * The meta object literal for the '<em><b>Lb</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_NN__LB = eINSTANCE.getIntervalNN_Lb();

    /**
     * The meta object literal for the '<em><b>Ub</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INTERVAL_NN__UB = eINSTANCE.getIntervalNN_Ub();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.SignalDefImpl <em>Signal Def</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.SignalDefImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getSignalDef()
     * @generated
     */
    EClass SIGNAL_DEF = eINSTANCE.getSignalDef();

    /**
     * The meta object literal for the '<em><b>Signal</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference SIGNAL_DEF__SIGNAL = eINSTANCE.getSignalDef_Signal();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.DefImpl <em>Def</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.DefImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getDef()
     * @generated
     */
    EClass DEF = eINSTANCE.getDef();

    /**
     * The meta object literal for the '<em><b>Param</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute DEF__PARAM = eINSTANCE.getDef_Param();

    /**
     * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference DEF__FORMULA = eINSTANCE.getDef_Formula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.CheckImpl <em>Check</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.CheckImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getCheck()
     * @generated
     */
    EClass CHECK = eINSTANCE.getCheck();

    /**
     * The meta object literal for the '<em><b>Var</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CHECK__VAR = eINSTANCE.getCheck_Var();

    /**
     * The meta object literal for the '<em><b>Lb</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CHECK__LB = eINSTANCE.getCheck_Lb();

    /**
     * The meta object literal for the '<em><b>Ub</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CHECK__UB = eINSTANCE.getCheck_Ub();

    /**
     * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CHECK__FORMULA = eINSTANCE.getCheck_Formula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.TraceSignalImpl <em>Trace Signal</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.TraceSignalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getTraceSignal()
     * @generated
     */
    EClass TRACE_SIGNAL = eINSTANCE.getTraceSignal();

    /**
     * The meta object literal for the '<em><b>Filter</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference TRACE_SIGNAL__FILTER = eINSTANCE.getTraceSignal_Filter();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.ThroughputSignalImpl <em>Throughput Signal</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.ThroughputSignalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getThroughputSignal()
     * @generated
     */
    EClass THROUGHPUT_SIGNAL = eINSTANCE.getThroughputSignal();

    /**
     * The meta object literal for the '<em><b>Id Att</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute THROUGHPUT_SIGNAL__ID_ATT = eINSTANCE.getThroughputSignal_IdAtt();

    /**
     * The meta object literal for the '<em><b>Ap</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference THROUGHPUT_SIGNAL__AP = eINSTANCE.getThroughputSignal_Ap();

    /**
     * The meta object literal for the '<em><b>Scale</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute THROUGHPUT_SIGNAL__SCALE = eINSTANCE.getThroughputSignal_Scale();

    /**
     * The meta object literal for the '<em><b>Conv Spec</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference THROUGHPUT_SIGNAL__CONV_SPEC = eINSTANCE.getThroughputSignal_ConvSpec();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.LatencySignalImpl <em>Latency Signal</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.LatencySignalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getLatencySignal()
     * @generated
     */
    EClass LATENCY_SIGNAL = eINSTANCE.getLatencySignal();

    /**
     * The meta object literal for the '<em><b>Id Att</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LATENCY_SIGNAL__ID_ATT = eINSTANCE.getLatencySignal_IdAtt();

    /**
     * The meta object literal for the '<em><b>Scale</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LATENCY_SIGNAL__SCALE = eINSTANCE.getLatencySignal_Scale();

    /**
     * The meta object literal for the '<em><b>Conv Spec</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference LATENCY_SIGNAL__CONV_SPEC = eINSTANCE.getLatencySignal_ConvSpec();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.WipSignalImpl <em>Wip Signal</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.WipSignalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getWipSignal()
     * @generated
     */
    EClass WIP_SIGNAL = eINSTANCE.getWipSignal();

    /**
     * The meta object literal for the '<em><b>Id Att</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute WIP_SIGNAL__ID_ATT = eINSTANCE.getWipSignal_IdAtt();

    /**
     * The meta object literal for the '<em><b>Conv Spec</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference WIP_SIGNAL__CONV_SPEC = eINSTANCE.getWipSignal_ConvSpec();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.ResourceAmountSignalImpl <em>Resource Amount Signal</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.ResourceAmountSignalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getResourceAmountSignal()
     * @generated
     */
    EClass RESOURCE_AMOUNT_SIGNAL = eINSTANCE.getResourceAmountSignal();

    /**
     * The meta object literal for the '<em><b>Filter</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference RESOURCE_AMOUNT_SIGNAL__FILTER = eINSTANCE.getResourceAmountSignal_Filter();

    /**
     * The meta object literal for the '<em><b>Conv Spec</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference RESOURCE_AMOUNT_SIGNAL__CONV_SPEC = eINSTANCE.getResourceAmountSignal_ConvSpec();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.ResourceClientSignalImpl <em>Resource Client Signal</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.ResourceClientSignalImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getResourceClientSignal()
     * @generated
     */
    EClass RESOURCE_CLIENT_SIGNAL = eINSTANCE.getResourceClientSignal();

    /**
     * The meta object literal for the '<em><b>Filter</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference RESOURCE_CLIENT_SIGNAL__FILTER = eINSTANCE.getResourceClientSignal_Filter();

    /**
     * The meta object literal for the '<em><b>Conv Spec</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference RESOURCE_CLIENT_SIGNAL__CONV_SPEC = eINSTANCE.getResourceClientSignal_ConvSpec();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.ReferenceFormulaImpl <em>Reference Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.ReferenceFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getReferenceFormula()
     * @generated
     */
    EClass REFERENCE_FORMULA = eINSTANCE.getReferenceFormula();

    /**
     * The meta object literal for the '<em><b>Def</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference REFERENCE_FORMULA__DEF = eINSTANCE.getReferenceFormula_Def();

    /**
     * The meta object literal for the '<em><b>Param</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REFERENCE_FORMULA__PARAM = eINSTANCE.getReferenceFormula_Param();

    /**
     * The meta object literal for the '<em><b>Val</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REFERENCE_FORMULA__VAL = eINSTANCE.getReferenceFormula_Val();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.ApFormulaImpl <em>Ap Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.ApFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getApFormula()
     * @generated
     */
    EClass AP_FORMULA = eINSTANCE.getApFormula();

    /**
     * The meta object literal for the '<em><b>Mtl AP</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference AP_FORMULA__MTL_AP = eINSTANCE.getApFormula_MtlAP();

    /**
     * The meta object literal for the '<em><b>Stl AP</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference AP_FORMULA__STL_AP = eINSTANCE.getApFormula_StlAP();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.NotFormulaImpl <em>Not Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.NotFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getNotFormula()
     * @generated
     */
    EClass NOT_FORMULA = eINSTANCE.getNotFormula();

    /**
     * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference NOT_FORMULA__FORMULA = eINSTANCE.getNotFormula_Formula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.AndOrFormulaImpl <em>And Or Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.AndOrFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getAndOrFormula()
     * @generated
     */
    EClass AND_OR_FORMULA = eINSTANCE.getAndOrFormula();

    /**
     * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference AND_OR_FORMULA__LEFT = eINSTANCE.getAndOrFormula_Left();

    /**
     * The meta object literal for the '<em><b>Op</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute AND_OR_FORMULA__OP = eINSTANCE.getAndOrFormula_Op();

    /**
     * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference AND_OR_FORMULA__RIGHT = eINSTANCE.getAndOrFormula_Right();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.IfThenFormulaImpl <em>If Then Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.IfThenFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getIfThenFormula()
     * @generated
     */
    EClass IF_THEN_FORMULA = eINSTANCE.getIfThenFormula();

    /**
     * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference IF_THEN_FORMULA__LEFT = eINSTANCE.getIfThenFormula_Left();

    /**
     * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference IF_THEN_FORMULA__RIGHT = eINSTANCE.getIfThenFormula_Right();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.GloballyUntimedFormulaImpl <em>Globally Untimed Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.GloballyUntimedFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getGloballyUntimedFormula()
     * @generated
     */
    EClass GLOBALLY_UNTIMED_FORMULA = eINSTANCE.getGloballyUntimedFormula();

    /**
     * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference GLOBALLY_UNTIMED_FORMULA__FORMULA = eINSTANCE.getGloballyUntimedFormula_Formula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.GloballyFormulaImpl <em>Globally Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.GloballyFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getGloballyFormula()
     * @generated
     */
    EClass GLOBALLY_FORMULA = eINSTANCE.getGloballyFormula();

    /**
     * The meta object literal for the '<em><b>Interval</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference GLOBALLY_FORMULA__INTERVAL = eINSTANCE.getGloballyFormula_Interval();

    /**
     * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference GLOBALLY_FORMULA__FORMULA = eINSTANCE.getGloballyFormula_Formula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.FinallyUntimedFormulaImpl <em>Finally Untimed Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.FinallyUntimedFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getFinallyUntimedFormula()
     * @generated
     */
    EClass FINALLY_UNTIMED_FORMULA = eINSTANCE.getFinallyUntimedFormula();

    /**
     * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference FINALLY_UNTIMED_FORMULA__FORMULA = eINSTANCE.getFinallyUntimedFormula_Formula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.FinallyFormulaImpl <em>Finally Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.FinallyFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getFinallyFormula()
     * @generated
     */
    EClass FINALLY_FORMULA = eINSTANCE.getFinallyFormula();

    /**
     * The meta object literal for the '<em><b>Interval</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference FINALLY_FORMULA__INTERVAL = eINSTANCE.getFinallyFormula_Interval();

    /**
     * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference FINALLY_FORMULA__FORMULA = eINSTANCE.getFinallyFormula_Formula();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.UntilUntimedFormulaImpl <em>Until Untimed Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.UntilUntimedFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getUntilUntimedFormula()
     * @generated
     */
    EClass UNTIL_UNTIMED_FORMULA = eINSTANCE.getUntilUntimedFormula();

    /**
     * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference UNTIL_UNTIMED_FORMULA__RIGHT = eINSTANCE.getUntilUntimedFormula_Right();

    /**
     * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference UNTIL_UNTIMED_FORMULA__LEFT = eINSTANCE.getUntilUntimedFormula_Left();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.UntilFormulaImpl <em>Until Formula</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.UntilFormulaImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getUntilFormula()
     * @generated
     */
    EClass UNTIL_FORMULA = eINSTANCE.getUntilFormula();

    /**
     * The meta object literal for the '<em><b>Interval</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference UNTIL_FORMULA__INTERVAL = eINSTANCE.getUntilFormula_Interval();

    /**
     * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference UNTIL_FORMULA__RIGHT = eINSTANCE.getUntilFormula_Right();

    /**
     * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference UNTIL_FORMULA__LEFT = eINSTANCE.getUntilFormula_Left();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.StlApDerivImpl <em>Stl Ap Deriv</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.StlApDerivImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getStlApDeriv()
     * @generated
     */
    EClass STL_AP_DERIV = eINSTANCE.getStlApDeriv();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.MtlApStartImpl <em>Mtl Ap Start</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.MtlApStartImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getMtlApStart()
     * @generated
     */
    EClass MTL_AP_START = eINSTANCE.getMtlApStart();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.impl.MtlApEndImpl <em>Mtl Ap End</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.impl.MtlApEndImpl
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getMtlApEnd()
     * @generated
     */
    EClass MTL_AP_END = eINSTANCE.getMtlApEnd();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.TimeUnitEnum <em>Time Unit Enum</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.TimeUnitEnum
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getTimeUnitEnum()
     * @generated
     */
    EEnum TIME_UNIT_ENUM = eINSTANCE.getTimeUnitEnum();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.AndOr <em>And Or</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.AndOr
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getAndOr()
     * @generated
     */
    EEnum AND_OR = eINSTANCE.getAndOr();

    /**
     * The meta object literal for the '{@link org.eclipse.trace4cps.tl.etl.CompOp <em>Comp Op</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.trace4cps.tl.etl.CompOp
     * @see org.eclipse.trace4cps.tl.etl.impl.EtlPackageImpl#getCompOp()
     * @generated
     */
    EEnum COMP_OP = eINSTANCE.getCompOp();

  }

} //EtlPackage
