/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

/*
 * generated by Xtext 2.22.0
 */
grammar InternalEtl;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.trace4cps.tl.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.trace4cps.tl.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.trace4cps.tl.services.EtlGrammarAccess;

}

@parser::members {

 	private EtlGrammarAccess grammarAccess;

    public InternalEtlParser(TokenStream input, EtlGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "EtlModel";
   	}

   	@Override
   	protected EtlGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleEtlModel
entryRuleEtlModel returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEtlModelRule()); }
	iv_ruleEtlModel=ruleEtlModel
	{ $current=$iv_ruleEtlModel.current; }
	EOF;

// Rule EtlModel
ruleEtlModel returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getEtlModelAccess().getElementsTopLevelModelElementParserRuleCall_0());
			}
			lv_elements_0_0=ruleTopLevelModelElement
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getEtlModelRule());
				}
				add(
					$current,
					"elements",
					lv_elements_0_0,
					"org.eclipse.trace4cps.tl.Etl.TopLevelModelElement");
				afterParserOrEnumRuleCall();
			}
		)
	)*
;

// Entry rule entryRuleTopLevelModelElement
entryRuleTopLevelModelElement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTopLevelModelElementRule()); }
	iv_ruleTopLevelModelElement=ruleTopLevelModelElement
	{ $current=$iv_ruleTopLevelModelElement.current; }
	EOF;

// Rule TopLevelModelElement
ruleTopLevelModelElement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getTopLevelModelElementAccess().getSignalDefAction_0_0(),
						$current);
				}
			)
			otherlv_1='signal'
			{
				newLeafNode(otherlv_1, grammarAccess.getTopLevelModelElementAccess().getSignalKeyword_0_1());
			}
			(
				(
					lv_name_2_0=RULE_ID
					{
						newLeafNode(lv_name_2_0, grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_0_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getTopLevelModelElementRule());
						}
						setWithLastConsumed(
							$current,
							"name",
							lv_name_2_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			otherlv_3=':'
			{
				newLeafNode(otherlv_3, grammarAccess.getTopLevelModelElementAccess().getColonKeyword_0_3());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTopLevelModelElementAccess().getSignalSignalParserRuleCall_0_4_0());
					}
					lv_signal_4_0=ruleSignal
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTopLevelModelElementRule());
						}
						set(
							$current,
							"signal",
							lv_signal_4_0,
							"org.eclipse.trace4cps.tl.Etl.Signal");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getTopLevelModelElementAccess().getDefAction_1_0(),
						$current);
				}
			)
			otherlv_6='def'
			{
				newLeafNode(otherlv_6, grammarAccess.getTopLevelModelElementAccess().getDefKeyword_1_1());
			}
			(
				(
					lv_name_7_0=RULE_ID
					{
						newLeafNode(lv_name_7_0, grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_1_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getTopLevelModelElementRule());
						}
						setWithLastConsumed(
							$current,
							"name",
							lv_name_7_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			(
				otherlv_8='('
				{
					newLeafNode(otherlv_8, grammarAccess.getTopLevelModelElementAccess().getLeftParenthesisKeyword_1_3_0());
				}
				(
					(
						lv_param_9_0=RULE_ID
						{
							newLeafNode(lv_param_9_0, grammarAccess.getTopLevelModelElementAccess().getParamIDTerminalRuleCall_1_3_1_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getTopLevelModelElementRule());
							}
							setWithLastConsumed(
								$current,
								"param",
								lv_param_9_0,
								"org.eclipse.xtext.common.Terminals.ID");
						}
					)
				)
				otherlv_10=')'
				{
					newLeafNode(otherlv_10, grammarAccess.getTopLevelModelElementAccess().getRightParenthesisKeyword_1_3_2());
				}
			)?
			otherlv_11=':'
			{
				newLeafNode(otherlv_11, grammarAccess.getTopLevelModelElementAccess().getColonKeyword_1_4());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTopLevelModelElementAccess().getFormulaFormulaParserRuleCall_1_5_0());
					}
					lv_formula_12_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTopLevelModelElementRule());
						}
						set(
							$current,
							"formula",
							lv_formula_12_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getTopLevelModelElementAccess().getCheckAction_2_0(),
						$current);
				}
			)
			otherlv_14='check'
			{
				newLeafNode(otherlv_14, grammarAccess.getTopLevelModelElementAccess().getCheckKeyword_2_1());
			}
			(
				(
					lv_name_15_0=RULE_ID
					{
						newLeafNode(lv_name_15_0, grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_2_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getTopLevelModelElementRule());
						}
						setWithLastConsumed(
							$current,
							"name",
							lv_name_15_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			otherlv_16=':'
			{
				newLeafNode(otherlv_16, grammarAccess.getTopLevelModelElementAccess().getColonKeyword_2_3());
			}
			(
				otherlv_17='forall'
				{
					newLeafNode(otherlv_17, grammarAccess.getTopLevelModelElementAccess().getForallKeyword_2_4_0());
				}
				otherlv_18='('
				{
					newLeafNode(otherlv_18, grammarAccess.getTopLevelModelElementAccess().getLeftParenthesisKeyword_2_4_1());
				}
				(
					(
						lv_var_19_0=RULE_ID
						{
							newLeafNode(lv_var_19_0, grammarAccess.getTopLevelModelElementAccess().getVarIDTerminalRuleCall_2_4_2_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getTopLevelModelElementRule());
							}
							setWithLastConsumed(
								$current,
								"var",
								lv_var_19_0,
								"org.eclipse.xtext.common.Terminals.ID");
						}
					)
				)
				otherlv_20=':'
				{
					newLeafNode(otherlv_20, grammarAccess.getTopLevelModelElementAccess().getColonKeyword_2_4_3());
				}
				(
					(
						lv_lb_21_0=RULE_INT_T
						{
							newLeafNode(lv_lb_21_0, grammarAccess.getTopLevelModelElementAccess().getLbINT_TTerminalRuleCall_2_4_4_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getTopLevelModelElementRule());
							}
							setWithLastConsumed(
								$current,
								"lb",
								lv_lb_21_0,
								"org.eclipse.trace4cps.tl.Etl.INT_T");
						}
					)
				)
				otherlv_22='...'
				{
					newLeafNode(otherlv_22, grammarAccess.getTopLevelModelElementAccess().getFullStopFullStopFullStopKeyword_2_4_5());
				}
				(
					(
						lv_ub_23_0=RULE_INT_T
						{
							newLeafNode(lv_ub_23_0, grammarAccess.getTopLevelModelElementAccess().getUbINT_TTerminalRuleCall_2_4_6_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getTopLevelModelElementRule());
							}
							setWithLastConsumed(
								$current,
								"ub",
								lv_ub_23_0,
								"org.eclipse.trace4cps.tl.Etl.INT_T");
						}
					)
				)
				otherlv_24=')'
				{
					newLeafNode(otherlv_24, grammarAccess.getTopLevelModelElementAccess().getRightParenthesisKeyword_2_4_7());
				}
			)?
			(
				(
					{
						newCompositeNode(grammarAccess.getTopLevelModelElementAccess().getFormulaFormulaParserRuleCall_2_5_0());
					}
					lv_formula_25_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTopLevelModelElementRule());
						}
						set(
							$current,
							"formula",
							lv_formula_25_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
	)
;

// Entry rule entryRuleSignal
entryRuleSignal returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSignalRule()); }
	iv_ruleSignal=ruleSignal
	{ $current=$iv_ruleSignal.current; }
	EOF;

// Rule Signal
ruleSignal returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getSignalAccess().getTraceSignalAction_0_0(),
						$current);
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_0_1_0());
					}
					lv_filter_1_0=ruleAttributeFilter
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"filter",
							lv_filter_1_0,
							"org.eclipse.trace4cps.tl.Etl.AttributeFilter");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getSignalAccess().getThroughputSignalAction_1_0(),
						$current);
				}
			)
			otherlv_3='throughput'
			{
				newLeafNode(otherlv_3, grammarAccess.getSignalAccess().getThroughputKeyword_1_1());
			}
			otherlv_4='of'
			{
				newLeafNode(otherlv_4, grammarAccess.getSignalAccess().getOfKeyword_1_2());
			}
			(
				(
					(
						lv_idAtt_5_0=RULE_ID
						{
							newLeafNode(lv_idAtt_5_0, grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_1_3_0_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getSignalRule());
							}
							setWithLastConsumed(
								$current,
								"idAtt",
								lv_idAtt_5_0,
								"org.eclipse.xtext.common.Terminals.ID");
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getSignalAccess().getApMtlApParserRuleCall_1_3_1_0());
						}
						lv_ap_6_0=ruleMtlAp
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSignalRule());
							}
							set(
								$current,
								"ap",
								lv_ap_6_0,
								"org.eclipse.trace4cps.tl.Etl.MtlAp");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			(
				otherlv_7='per'
				{
					newLeafNode(otherlv_7, grammarAccess.getSignalAccess().getPerKeyword_1_4_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getSignalAccess().getScaleTimeUnitEnumEnumRuleCall_1_4_1_0());
						}
						lv_scale_8_0=ruleTimeUnitEnum
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSignalRule());
							}
							set(
								$current,
								"scale",
								lv_scale_8_0,
								"org.eclipse.trace4cps.tl.Etl.TimeUnitEnum");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)?
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_1_5_0());
					}
					lv_convSpec_9_0=ruleConvSpec
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"convSpec",
							lv_convSpec_9_0,
							"org.eclipse.trace4cps.tl.Etl.ConvSpec");
						afterParserOrEnumRuleCall();
					}
				)
			)?
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getSignalAccess().getLatencySignalAction_2_0(),
						$current);
				}
			)
			otherlv_11='latency'
			{
				newLeafNode(otherlv_11, grammarAccess.getSignalAccess().getLatencyKeyword_2_1());
			}
			otherlv_12='of'
			{
				newLeafNode(otherlv_12, grammarAccess.getSignalAccess().getOfKeyword_2_2());
			}
			(
				(
					lv_idAtt_13_0=RULE_ID
					{
						newLeafNode(lv_idAtt_13_0, grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_2_3_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSignalRule());
						}
						setWithLastConsumed(
							$current,
							"idAtt",
							lv_idAtt_13_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			(
				otherlv_14='in'
				{
					newLeafNode(otherlv_14, grammarAccess.getSignalAccess().getInKeyword_2_4_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getSignalAccess().getScaleTimeUnitEnumEnumRuleCall_2_4_1_0());
						}
						lv_scale_15_0=ruleTimeUnitEnum
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSignalRule());
							}
							set(
								$current,
								"scale",
								lv_scale_15_0,
								"org.eclipse.trace4cps.tl.Etl.TimeUnitEnum");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)?
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_2_5_0());
					}
					lv_convSpec_16_0=ruleConvSpec
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"convSpec",
							lv_convSpec_16_0,
							"org.eclipse.trace4cps.tl.Etl.ConvSpec");
						afterParserOrEnumRuleCall();
					}
				)
			)?
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getSignalAccess().getWipSignalAction_3_0(),
						$current);
				}
			)
			otherlv_18='wip'
			{
				newLeafNode(otherlv_18, grammarAccess.getSignalAccess().getWipKeyword_3_1());
			}
			otherlv_19='of'
			{
				newLeafNode(otherlv_19, grammarAccess.getSignalAccess().getOfKeyword_3_2());
			}
			(
				(
					lv_idAtt_20_0=RULE_ID
					{
						newLeafNode(lv_idAtt_20_0, grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_3_3_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSignalRule());
						}
						setWithLastConsumed(
							$current,
							"idAtt",
							lv_idAtt_20_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_3_4_0());
					}
					lv_convSpec_21_0=ruleConvSpec
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"convSpec",
							lv_convSpec_21_0,
							"org.eclipse.trace4cps.tl.Etl.ConvSpec");
						afterParserOrEnumRuleCall();
					}
				)
			)?
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getSignalAccess().getResourceAmountSignalAction_4_0(),
						$current);
				}
			)
			otherlv_23='resource-amount'
			{
				newLeafNode(otherlv_23, grammarAccess.getSignalAccess().getResourceAmountKeyword_4_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_4_2_0());
					}
					lv_filter_24_0=ruleAttributeFilter
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"filter",
							lv_filter_24_0,
							"org.eclipse.trace4cps.tl.Etl.AttributeFilter");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_4_3_0());
					}
					lv_convSpec_25_0=ruleConvSpec
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"convSpec",
							lv_convSpec_25_0,
							"org.eclipse.trace4cps.tl.Etl.ConvSpec");
						afterParserOrEnumRuleCall();
					}
				)
			)?
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getSignalAccess().getResourceClientSignalAction_5_0(),
						$current);
				}
			)
			otherlv_27='resource-clients'
			{
				newLeafNode(otherlv_27, grammarAccess.getSignalAccess().getResourceClientsKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_5_2_0());
					}
					lv_filter_28_0=ruleAttributeFilter
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"filter",
							lv_filter_28_0,
							"org.eclipse.trace4cps.tl.Etl.AttributeFilter");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_5_3_0());
					}
					lv_convSpec_29_0=ruleConvSpec
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSignalRule());
						}
						set(
							$current,
							"convSpec",
							lv_convSpec_29_0,
							"org.eclipse.trace4cps.tl.Etl.ConvSpec");
						afterParserOrEnumRuleCall();
					}
				)
			)?
		)
	)
;

// Entry rule entryRuleConvSpec
entryRuleConvSpec returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConvSpecRule()); }
	iv_ruleConvSpec=ruleConvSpec
	{ $current=$iv_ruleConvSpec.current; }
	EOF;

// Rule ConvSpec
ruleConvSpec returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='over'
		{
			newLeafNode(otherlv_0, grammarAccess.getConvSpecAccess().getOverKeyword_0());
		}
		(
			(
				lv_windowWidth_1_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_windowWidth_1_0, grammarAccess.getConvSpecAccess().getWindowWidthDOUBLE_TTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getConvSpecRule());
					}
					setWithLastConsumed(
						$current,
						"windowWidth",
						lv_windowWidth_1_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getConvSpecAccess().getWindowUnitTimeUnitEnumEnumRuleCall_2_0());
				}
				lv_windowUnit_2_0=ruleTimeUnitEnum
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConvSpecRule());
					}
					set(
						$current,
						"windowUnit",
						lv_windowUnit_2_0,
						"org.eclipse.trace4cps.tl.Etl.TimeUnitEnum");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleFormula
entryRuleFormula returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFormulaRule()); }
	iv_ruleFormula=ruleFormula
	{ $current=$iv_ruleFormula.current; }
	EOF;

// Rule Formula
ruleFormula returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getReferenceFormulaAction_0_0(),
						$current);
				}
			)
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getFormulaRule());
						}
					}
					otherlv_1=RULE_ID
					{
						newLeafNode(otherlv_1, grammarAccess.getFormulaAccess().getDefDefCrossReference_0_1_0());
					}
				)
			)
			(
				otherlv_2='('
				{
					newLeafNode(otherlv_2, grammarAccess.getFormulaAccess().getLeftParenthesisKeyword_0_2_0());
				}
				(
					(
						lv_param_3_0=RULE_ID
						{
							newLeafNode(lv_param_3_0, grammarAccess.getFormulaAccess().getParamIDTerminalRuleCall_0_2_1_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getFormulaRule());
							}
							setWithLastConsumed(
								$current,
								"param",
								lv_param_3_0,
								"org.eclipse.xtext.common.Terminals.ID");
						}
					)
				)
				(
					otherlv_4='+'
					{
						newLeafNode(otherlv_4, grammarAccess.getFormulaAccess().getPlusSignKeyword_0_2_2_0());
					}
					(
						(
							lv_val_5_0=RULE_INT_T
							{
								newLeafNode(lv_val_5_0, grammarAccess.getFormulaAccess().getValINT_TTerminalRuleCall_0_2_2_1_0());
							}
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getFormulaRule());
								}
								setWithLastConsumed(
									$current,
									"val",
									lv_val_5_0,
									"org.eclipse.trace4cps.tl.Etl.INT_T");
							}
						)
					)
				)?
				otherlv_6=')'
				{
					newLeafNode(otherlv_6, grammarAccess.getFormulaAccess().getRightParenthesisKeyword_0_2_3());
				}
			)?
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getApFormulaAction_1_0(),
						$current);
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getMtlAPMtlApParserRuleCall_1_1_0());
					}
					lv_mtlAP_8_0=ruleMtlAp
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"mtlAP",
							lv_mtlAP_8_0,
							"org.eclipse.trace4cps.tl.Etl.MtlAp");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getApFormulaAction_2_0(),
						$current);
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getStlAPStlApParserRuleCall_2_1_0());
					}
					lv_stlAP_10_0=ruleStlAp
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"stlAP",
							lv_stlAP_10_0,
							"org.eclipse.trace4cps.tl.Etl.StlAp");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getNotFormulaAction_3_0(),
						$current);
				}
			)
			otherlv_12='not'
			{
				newLeafNode(otherlv_12, grammarAccess.getFormulaAccess().getNotKeyword_3_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_3_2_0());
					}
					lv_formula_13_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"formula",
							lv_formula_13_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getAndOrFormulaAction_4_0(),
						$current);
				}
			)
			otherlv_15='('
			{
				newLeafNode(otherlv_15, grammarAccess.getFormulaAccess().getLeftParenthesisKeyword_4_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_4_2_0());
					}
					lv_left_16_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"left",
							lv_left_16_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getOpAndOrEnumRuleCall_4_3_0());
					}
					lv_op_17_0=ruleAndOr
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"op",
							lv_op_17_0,
							"org.eclipse.trace4cps.tl.Etl.AndOr");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_4_4_0());
					}
					lv_right_18_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"right",
							lv_right_18_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_19=')'
			{
				newLeafNode(otherlv_19, grammarAccess.getFormulaAccess().getRightParenthesisKeyword_4_5());
			}
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getIfThenFormulaAction_5_0(),
						$current);
				}
			)
			otherlv_21='if'
			{
				newLeafNode(otherlv_21, grammarAccess.getFormulaAccess().getIfKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_5_2_0());
					}
					lv_left_22_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"left",
							lv_left_22_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_23='then'
			{
				newLeafNode(otherlv_23, grammarAccess.getFormulaAccess().getThenKeyword_5_3());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_5_4_0());
					}
					lv_right_24_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"right",
							lv_right_24_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getGloballyUntimedFormulaAction_6_0(),
						$current);
				}
			)
			otherlv_26='globally'
			{
				newLeafNode(otherlv_26, grammarAccess.getFormulaAccess().getGloballyKeyword_6_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_6_2_0());
					}
					lv_formula_27_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"formula",
							lv_formula_27_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getGloballyFormulaAction_7_0(),
						$current);
				}
			)
			otherlv_29='during'
			{
				newLeafNode(otherlv_29, grammarAccess.getFormulaAccess().getDuringKeyword_7_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_7_2_0());
					}
					lv_interval_30_0=ruleInterval
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"interval",
							lv_interval_30_0,
							"org.eclipse.trace4cps.tl.Etl.Interval");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_7_3_0());
					}
					lv_formula_31_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"formula",
							lv_formula_31_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getFinallyUntimedFormulaAction_8_0(),
						$current);
				}
			)
			otherlv_33='finally'
			{
				newLeafNode(otherlv_33, grammarAccess.getFormulaAccess().getFinallyKeyword_8_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_8_2_0());
					}
					lv_formula_34_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"formula",
							lv_formula_34_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getFinallyFormulaAction_9_0(),
						$current);
				}
			)
			otherlv_36='within'
			{
				newLeafNode(otherlv_36, grammarAccess.getFormulaAccess().getWithinKeyword_9_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_9_2_0());
					}
					lv_interval_37_0=ruleInterval
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"interval",
							lv_interval_37_0,
							"org.eclipse.trace4cps.tl.Etl.Interval");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_9_3_0());
					}
					lv_formula_38_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"formula",
							lv_formula_38_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getUntilUntimedFormulaAction_10_0(),
						$current);
				}
			)
			otherlv_40='until'
			{
				newLeafNode(otherlv_40, grammarAccess.getFormulaAccess().getUntilKeyword_10_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_10_2_0());
					}
					lv_right_41_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"right",
							lv_right_41_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_42='we'
			{
				newLeafNode(otherlv_42, grammarAccess.getFormulaAccess().getWeKeyword_10_3());
			}
			otherlv_43='have'
			{
				newLeafNode(otherlv_43, grammarAccess.getFormulaAccess().getHaveKeyword_10_4());
			}
			otherlv_44='that'
			{
				newLeafNode(otherlv_44, grammarAccess.getFormulaAccess().getThatKeyword_10_5());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_10_6_0());
					}
					lv_left_45_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"left",
							lv_left_45_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getFormulaAccess().getUntilFormulaAction_11_0(),
						$current);
				}
			)
			otherlv_47='by'
			{
				newLeafNode(otherlv_47, grammarAccess.getFormulaAccess().getByKeyword_11_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_11_2_0());
					}
					lv_interval_48_0=ruleInterval
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"interval",
							lv_interval_48_0,
							"org.eclipse.trace4cps.tl.Etl.Interval");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_11_3_0());
					}
					lv_right_49_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"right",
							lv_right_49_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_50='and'
			{
				newLeafNode(otherlv_50, grammarAccess.getFormulaAccess().getAndKeyword_11_4());
			}
			otherlv_51='until'
			{
				newLeafNode(otherlv_51, grammarAccess.getFormulaAccess().getUntilKeyword_11_5());
			}
			otherlv_52='then'
			{
				newLeafNode(otherlv_52, grammarAccess.getFormulaAccess().getThenKeyword_11_6());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_11_7_0());
					}
					lv_left_53_0=ruleFormula
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFormulaRule());
						}
						set(
							$current,
							"left",
							lv_left_53_0,
							"org.eclipse.trace4cps.tl.Etl.Formula");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
	)
;

// Entry rule entryRuleStlAp
entryRuleStlAp returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStlApRule()); }
	iv_ruleStlAp=ruleStlAp
	{ $current=$iv_ruleStlAp.current; }
	EOF;

// Rule StlAp
ruleStlAp returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getStlApRule());
						}
					}
					otherlv_0=RULE_ID
					{
						newLeafNode(otherlv_0, grammarAccess.getStlApAccess().getRefSignalDefCrossReference_0_0_0());
					}
				)
			)
			    |
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getStlApAccess().getStlApDerivAction_0_1_0(),
							$current);
					}
				)
				otherlv_2='d'
				{
					newLeafNode(otherlv_2, grammarAccess.getStlApAccess().getDKeyword_0_1_1());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getStlApRule());
							}
						}
						otherlv_3=RULE_ID
						{
							newLeafNode(otherlv_3, grammarAccess.getStlApAccess().getRefSignalDefCrossReference_0_1_2_0());
						}
					)
				)
				otherlv_4='/'
				{
					newLeafNode(otherlv_4, grammarAccess.getStlApAccess().getSolidusKeyword_0_1_3());
				}
				otherlv_5='dt'
				{
					newLeafNode(otherlv_5, grammarAccess.getStlApAccess().getDtKeyword_0_1_4());
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getStlApAccess().getCompOpCompOpEnumRuleCall_1_0());
				}
				lv_compOp_6_0=ruleCompOp
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStlApRule());
					}
					set(
						$current,
						"compOp",
						lv_compOp_6_0,
						"org.eclipse.trace4cps.tl.Etl.CompOp");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_val_7_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_val_7_0, grammarAccess.getStlApAccess().getValDOUBLE_TTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStlApRule());
					}
					setWithLastConsumed(
						$current,
						"val",
						lv_val_7_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
	)
;

// Entry rule entryRuleMtlAp
entryRuleMtlAp returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMtlApRule()); }
	iv_ruleMtlAp=ruleMtlAp
	{ $current=$iv_ruleMtlAp.current; }
	EOF;

// Rule MtlAp
ruleMtlAp returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getMtlApAccess().getMtlApStartAction_0_0_0(),
							$current);
					}
				)
				otherlv_1='start'
				{
					newLeafNode(otherlv_1, grammarAccess.getMtlApAccess().getStartKeyword_0_0_1());
				}
			)
			    |
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getMtlApAccess().getMtlApEndAction_0_1_0(),
							$current);
					}
				)
				otherlv_3='end'
				{
					newLeafNode(otherlv_3, grammarAccess.getMtlApAccess().getEndKeyword_0_1_1());
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getMtlApAccess().getFilterAttributeFilterParserRuleCall_1_0());
				}
				lv_filter_4_0=ruleAttributeFilter
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMtlApRule());
					}
					set(
						$current,
						"filter",
						lv_filter_4_0,
						"org.eclipse.trace4cps.tl.Etl.AttributeFilter");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleAttributeFilter
entryRuleAttributeFilter returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAttributeFilterRule()); }
	iv_ruleAttributeFilter=ruleAttributeFilter
	{ $current=$iv_ruleAttributeFilter.current; }
	EOF;

// Rule AttributeFilter
ruleAttributeFilter returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='{'
		{
			newLeafNode(otherlv_0, grammarAccess.getAttributeFilterAccess().getLeftCurlyBracketKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAttributeFilterAccess().getKeyValsKeyValParserRuleCall_1_0());
				}
				lv_keyVals_1_0=ruleKeyVal
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAttributeFilterRule());
					}
					add(
						$current,
						"keyVals",
						lv_keyVals_1_0,
						"org.eclipse.trace4cps.tl.Etl.KeyVal");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getAttributeFilterAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getAttributeFilterAccess().getKeyValsKeyValParserRuleCall_2_1_0());
					}
					lv_keyVals_3_0=ruleKeyVal
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAttributeFilterRule());
						}
						add(
							$current,
							"keyVals",
							lv_keyVals_3_0,
							"org.eclipse.trace4cps.tl.Etl.KeyVal");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_4='}'
		{
			newLeafNode(otherlv_4, grammarAccess.getAttributeFilterAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleKeyVal
entryRuleKeyVal returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getKeyValRule()); }
	iv_ruleKeyVal=ruleKeyVal
	{ $current=$iv_ruleKeyVal.current; }
	EOF;

// Rule KeyVal
ruleKeyVal returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getKeyValAccess().getAttIdStringParserRuleCall_0_0());
				}
				lv_att_0_0=ruleIdString
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getKeyValRule());
					}
					set(
						$current,
						"att",
						lv_att_0_0,
						"org.eclipse.trace4cps.tl.Etl.IdString");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getKeyValAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getKeyValAccess().getValIdStringParserRuleCall_2_0());
				}
				lv_val_2_0=ruleIdString
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getKeyValRule());
					}
					set(
						$current,
						"val",
						lv_val_2_0,
						"org.eclipse.trace4cps.tl.Etl.IdString");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleIdString
entryRuleIdString returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIdStringRule()); }
	iv_ruleIdString=ruleIdString
	{ $current=$iv_ruleIdString.current; }
	EOF;

// Rule IdString
ruleIdString returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_left_0_0=RULE_STRING
				{
					newLeafNode(lv_left_0_0, grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIdStringRule());
					}
					setWithLastConsumed(
						$current,
						"left",
						lv_left_0_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		    |
		(
			(
				lv_id_1_0=RULE_ID
				{
					newLeafNode(lv_id_1_0, grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIdStringRule());
					}
					setWithLastConsumed(
						$current,
						"id",
						lv_id_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		    |
		(
			(
				(
					lv_left_2_0=RULE_STRING
					{
						newLeafNode(lv_left_2_0, grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_2_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIdStringRule());
						}
						setWithLastConsumed(
							$current,
							"left",
							lv_left_2_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
			otherlv_3='+'
			{
				newLeafNode(otherlv_3, grammarAccess.getIdStringAccess().getPlusSignKeyword_2_1());
			}
			(
				(
					lv_id_4_0=RULE_ID
					{
						newLeafNode(lv_id_4_0, grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_2_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIdStringRule());
						}
						setWithLastConsumed(
							$current,
							"id",
							lv_id_4_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
		)
		    |
		(
			(
				(
					lv_id_5_0=RULE_ID
					{
						newLeafNode(lv_id_5_0, grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_3_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIdStringRule());
						}
						setWithLastConsumed(
							$current,
							"id",
							lv_id_5_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			otherlv_6='+'
			{
				newLeafNode(otherlv_6, grammarAccess.getIdStringAccess().getPlusSignKeyword_3_1());
			}
			(
				(
					lv_right_7_0=RULE_STRING
					{
						newLeafNode(lv_right_7_0, grammarAccess.getIdStringAccess().getRightSTRINGTerminalRuleCall_3_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIdStringRule());
						}
						setWithLastConsumed(
							$current,
							"right",
							lv_right_7_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
		)
		    |
		(
			(
				(
					lv_left_8_0=RULE_STRING
					{
						newLeafNode(lv_left_8_0, grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_4_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIdStringRule());
						}
						setWithLastConsumed(
							$current,
							"left",
							lv_left_8_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
			otherlv_9='+'
			{
				newLeafNode(otherlv_9, grammarAccess.getIdStringAccess().getPlusSignKeyword_4_1());
			}
			(
				(
					lv_id_10_0=RULE_ID
					{
						newLeafNode(lv_id_10_0, grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_4_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIdStringRule());
						}
						setWithLastConsumed(
							$current,
							"id",
							lv_id_10_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			otherlv_11='+'
			{
				newLeafNode(otherlv_11, grammarAccess.getIdStringAccess().getPlusSignKeyword_4_3());
			}
			(
				(
					lv_right_12_0=RULE_STRING
					{
						newLeafNode(lv_right_12_0, grammarAccess.getIdStringAccess().getRightSTRINGTerminalRuleCall_4_4_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIdStringRule());
						}
						setWithLastConsumed(
							$current,
							"right",
							lv_right_12_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
		)
	)
;

// Entry rule entryRuleInterval
entryRuleInterval returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntervalRule()); }
	iv_ruleInterval=ruleInterval
	{ $current=$iv_ruleInterval.current; }
	EOF;

// Rule Interval
ruleInterval returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getIntervalAccess().getIssIntervalSSParserRuleCall_0_0_0());
					}
					lv_iss_0_0=ruleIntervalSS
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getIntervalRule());
						}
						set(
							$current,
							"iss",
							lv_iss_0_0,
							"org.eclipse.trace4cps.tl.Etl.IntervalSS");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getIntervalAccess().getIsnIntervalSNParserRuleCall_0_1_0());
					}
					lv_isn_1_0=ruleIntervalSN
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getIntervalRule());
						}
						set(
							$current,
							"isn",
							lv_isn_1_0,
							"org.eclipse.trace4cps.tl.Etl.IntervalSN");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getIntervalAccess().getInsIntervalNSParserRuleCall_0_2_0());
					}
					lv_ins_2_0=ruleIntervalNS
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getIntervalRule());
						}
						set(
							$current,
							"ins",
							lv_ins_2_0,
							"org.eclipse.trace4cps.tl.Etl.IntervalNS");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getIntervalAccess().getInnIntervalNNParserRuleCall_0_3_0());
					}
					lv_inn_3_0=ruleIntervalNN
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getIntervalRule());
						}
						set(
							$current,
							"inn",
							lv_inn_3_0,
							"org.eclipse.trace4cps.tl.Etl.IntervalNN");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getIntervalAccess().getTimeUnitTimeUnitEnumEnumRuleCall_1_0());
				}
				lv_timeUnit_4_0=ruleTimeUnitEnum
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getIntervalRule());
					}
					set(
						$current,
						"timeUnit",
						lv_timeUnit_4_0,
						"org.eclipse.trace4cps.tl.Etl.TimeUnitEnum");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleIntervalSS
entryRuleIntervalSS returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntervalSSRule()); }
	iv_ruleIntervalSS=ruleIntervalSS
	{ $current=$iv_ruleIntervalSS.current; }
	EOF;

// Rule IntervalSS
ruleIntervalSS returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='('
		{
			newLeafNode(otherlv_0, grammarAccess.getIntervalSSAccess().getLeftParenthesisKeyword_0());
		}
		(
			(
				lv_lb_1_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_lb_1_0, grammarAccess.getIntervalSSAccess().getLbDOUBLE_TTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntervalSSRule());
					}
					setWithLastConsumed(
						$current,
						"lb",
						lv_lb_1_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
		otherlv_2=','
		{
			newLeafNode(otherlv_2, grammarAccess.getIntervalSSAccess().getCommaKeyword_2());
		}
		(
			(
				(
					lv_ub_3_0=RULE_DOUBLE_T
					{
						newLeafNode(lv_ub_3_0, grammarAccess.getIntervalSSAccess().getUbDOUBLE_TTerminalRuleCall_3_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIntervalSSRule());
						}
						setWithLastConsumed(
							$current,
							"ub",
							lv_ub_3_0,
							"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
					}
				)
			)
			    |
			(
				(
					lv_infty_4_0='Infty'
					{
						newLeafNode(lv_infty_4_0, grammarAccess.getIntervalSSAccess().getInftyInftyKeyword_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIntervalSSRule());
						}
						setWithLastConsumed($current, "infty", lv_infty_4_0, "Infty");
					}
				)
			)
		)
		otherlv_5=')'
		{
			newLeafNode(otherlv_5, grammarAccess.getIntervalSSAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleIntervalSN
entryRuleIntervalSN returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntervalSNRule()); }
	iv_ruleIntervalSN=ruleIntervalSN
	{ $current=$iv_ruleIntervalSN.current; }
	EOF;

// Rule IntervalSN
ruleIntervalSN returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='('
		{
			newLeafNode(otherlv_0, grammarAccess.getIntervalSNAccess().getLeftParenthesisKeyword_0());
		}
		(
			(
				lv_lb_1_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_lb_1_0, grammarAccess.getIntervalSNAccess().getLbDOUBLE_TTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntervalSNRule());
					}
					setWithLastConsumed(
						$current,
						"lb",
						lv_lb_1_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
		otherlv_2=','
		{
			newLeafNode(otherlv_2, grammarAccess.getIntervalSNAccess().getCommaKeyword_2());
		}
		(
			(
				lv_ub_3_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_ub_3_0, grammarAccess.getIntervalSNAccess().getUbDOUBLE_TTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntervalSNRule());
					}
					setWithLastConsumed(
						$current,
						"ub",
						lv_ub_3_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
		otherlv_4=']'
		{
			newLeafNode(otherlv_4, grammarAccess.getIntervalSNAccess().getRightSquareBracketKeyword_4());
		}
	)
;

// Entry rule entryRuleIntervalNS
entryRuleIntervalNS returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntervalNSRule()); }
	iv_ruleIntervalNS=ruleIntervalNS
	{ $current=$iv_ruleIntervalNS.current; }
	EOF;

// Rule IntervalNS
ruleIntervalNS returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='['
		{
			newLeafNode(otherlv_0, grammarAccess.getIntervalNSAccess().getLeftSquareBracketKeyword_0());
		}
		(
			(
				lv_lb_1_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_lb_1_0, grammarAccess.getIntervalNSAccess().getLbDOUBLE_TTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntervalNSRule());
					}
					setWithLastConsumed(
						$current,
						"lb",
						lv_lb_1_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
		otherlv_2=','
		{
			newLeafNode(otherlv_2, grammarAccess.getIntervalNSAccess().getCommaKeyword_2());
		}
		(
			(
				(
					lv_ub_3_0=RULE_DOUBLE_T
					{
						newLeafNode(lv_ub_3_0, grammarAccess.getIntervalNSAccess().getUbDOUBLE_TTerminalRuleCall_3_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIntervalNSRule());
						}
						setWithLastConsumed(
							$current,
							"ub",
							lv_ub_3_0,
							"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
					}
				)
			)
			    |
			(
				(
					lv_infty_4_0='Infty'
					{
						newLeafNode(lv_infty_4_0, grammarAccess.getIntervalNSAccess().getInftyInftyKeyword_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getIntervalNSRule());
						}
						setWithLastConsumed($current, "infty", lv_infty_4_0, "Infty");
					}
				)
			)
		)
		otherlv_5=')'
		{
			newLeafNode(otherlv_5, grammarAccess.getIntervalNSAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleIntervalNN
entryRuleIntervalNN returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntervalNNRule()); }
	iv_ruleIntervalNN=ruleIntervalNN
	{ $current=$iv_ruleIntervalNN.current; }
	EOF;

// Rule IntervalNN
ruleIntervalNN returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='['
		{
			newLeafNode(otherlv_0, grammarAccess.getIntervalNNAccess().getLeftSquareBracketKeyword_0());
		}
		(
			(
				lv_lb_1_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_lb_1_0, grammarAccess.getIntervalNNAccess().getLbDOUBLE_TTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntervalNNRule());
					}
					setWithLastConsumed(
						$current,
						"lb",
						lv_lb_1_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
		otherlv_2=','
		{
			newLeafNode(otherlv_2, grammarAccess.getIntervalNNAccess().getCommaKeyword_2());
		}
		(
			(
				lv_ub_3_0=RULE_DOUBLE_T
				{
					newLeafNode(lv_ub_3_0, grammarAccess.getIntervalNNAccess().getUbDOUBLE_TTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntervalNNRule());
					}
					setWithLastConsumed(
						$current,
						"ub",
						lv_ub_3_0,
						"org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
				}
			)
		)
		otherlv_4=']'
		{
			newLeafNode(otherlv_4, grammarAccess.getIntervalNNAccess().getRightSquareBracketKeyword_4());
		}
	)
;

// Rule TimeUnitEnum
ruleTimeUnitEnum returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='s'
			{
				$current = grammarAccess.getTimeUnitEnumAccess().getSEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getTimeUnitEnumAccess().getSEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='ns'
			{
				$current = grammarAccess.getTimeUnitEnumAccess().getNSEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getTimeUnitEnumAccess().getNSEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='us'
			{
				$current = grammarAccess.getTimeUnitEnumAccess().getUSEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getTimeUnitEnumAccess().getUSEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='ms'
			{
				$current = grammarAccess.getTimeUnitEnumAccess().getMSEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getTimeUnitEnumAccess().getMSEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='min'
			{
				$current = grammarAccess.getTimeUnitEnumAccess().getMINEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getTimeUnitEnumAccess().getMINEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='hr'
			{
				$current = grammarAccess.getTimeUnitEnumAccess().getHREnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getTimeUnitEnumAccess().getHREnumLiteralDeclaration_5());
			}
		)
	)
;

// Rule AndOr
ruleAndOr returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='and'
			{
				$current = grammarAccess.getAndOrAccess().getANDEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getAndOrAccess().getANDEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='or'
			{
				$current = grammarAccess.getAndOrAccess().getOREnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getAndOrAccess().getOREnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule CompOp
ruleCompOp returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='<='
			{
				$current = grammarAccess.getCompOpAccess().getLEEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getCompOpAccess().getLEEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='=='
			{
				$current = grammarAccess.getCompOpAccess().getEQEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getCompOpAccess().getEQEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='>='
			{
				$current = grammarAccess.getCompOpAccess().getGEEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getCompOpAccess().getGEEnumLiteralDeclaration_2());
			}
		)
	)
;

RULE_INT_T : '-'? RULE_INT;

RULE_DOUBLE_T : '-'? RULE_INT '.' RULE_INT;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

fragment RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
