/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.internal;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.xtext.internal.ResourceServiceProviderDescriptor;

abstract class AbstractRegistryReader
extends RegistryReader {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    static final String ATT_CLASS = "class";

    public AbstractRegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
        super(pluginRegistry, pluginID, extensionPointID);
    }

    protected abstract String getKeyAttribute();

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals("resourceServiceProvider")) {
            String contentTypeIdentifier = this.getValueForKeyAttribute(element);
            if (contentTypeIdentifier == null) {
                this.logMissingAttribute(element, this.getKeyAttribute());
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    Object previous = this.getMap().put(contentTypeIdentifier, new ResourceServiceProviderDescriptor(element, ATT_CLASS));
                    if (previous instanceof ResourceServiceProviderDescriptor) {
                        ResourceServiceProviderDescriptor descriptor = (ResourceServiceProviderDescriptor)previous;
                        this.log.warn((Object)("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a content parser for '" + contentTypeIdentifier + "'"));
                    }
                    return true;
                }
                this.getMap().remove(contentTypeIdentifier);
                return true;
            }
        }
        return false;
    }

    protected String getValueForKeyAttribute(IConfigurationElement element) {
        return element.getAttribute(this.getKeyAttribute());
    }

    protected abstract Map<String, Object> getMap();

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        this.log.error((Object)("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier()));
        this.log.error((Object)text);
    }
}

