/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.signal.SignalUtil;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.ui.dialog.LittlesLawDialog;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class ThroughputEventAction
extends AbstractTraceViewAction {
    private static final TimeUnit WINDOW_TIMEUNIT = TimeUnit.SECONDS;

    public ThroughputEventAction(TraceView view) {
        super(view);
        this.setText("Event-based throughput");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1 && this.view.hasEvents(true, true);
    }

    @Override
    protected void doRun() throws TraceException {
        LittlesLawDialog dialog = new LittlesLawDialog(this.view.getEditorSite().getShell(), this.view, LittlesLawDialog.LlDialogType.THROUGHPUT_EVENT);
        if (dialog.open() == 0) {
            ITrace trace = this.view.getTrace();
            Map<String, String> filter = dialog.getFilter();
            ArrayList<IEvent> events = new ArrayList<IEvent>();
            for (IEvent e : trace.getEvents()) {
                if (!this.matches(e, dialog.getEventType()) || !TraceHelper.matches(filter, (Map)e.getAttributes())) continue;
                events.add(e);
            }
            if (events.size() == 0) {
                throw new TraceException("Filter results in empty event list");
            }
            IPsop p = SignalUtil.getTP((TimeUnit)trace.getTimeUnit(), (IInterval)TraceHelper.getDomain((ITrace)trace), events, (TimeUnit)dialog.getTimeUnit(), (double)dialog.getPositiveDoubleValue(), (TimeUnit)WINDOW_TIMEUNIT);
            p.setAttribute("name", "throughput");
            p.setAttribute("type", "event-based");
            p.setAttribute("time unit", dialog.getTimeUnit().toString());
            p.setAttribute("convolution width", Double.toString(dialog.getPositiveDoubleValue()) + " " + String.valueOf((Object)WINDOW_TIMEUNIT));
            this.view.addExtension(p, 0);
            this.view.update();
        }
    }

    private boolean matches(IEvent e, ClaimEventType t) {
        if (t == null) {
            return true;
        }
        return e instanceof IClaimEvent && ((IClaimEvent)e).getType() == t;
    }
}

